/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc;

import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.OtherJavadoc;
import com.github.therapi.runtimejavadoc.SeeAlsoJavadoc;
import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import java.util.List;

public abstract class BaseJavadoc {
    private final String name;
    private final Comment comment;
    private final List<SeeAlsoJavadoc> seeAlso;
    private final List<OtherJavadoc> other;

    BaseJavadoc(String name, Comment comment, List<SeeAlsoJavadoc> seeAlso, List<OtherJavadoc> other) {
        this.name = RuntimeJavadocHelper.requireNonNull(name);
        this.comment = Comment.nullToEmpty(comment);
        this.other = RuntimeJavadocHelper.unmodifiableDefensiveCopy(other);
        this.seeAlso = RuntimeJavadocHelper.unmodifiableDefensiveCopy(seeAlso);
    }

    public String getName() {
        return this.name;
    }

    public Comment getComment() {
        return this.comment;
    }

    public List<SeeAlsoJavadoc> getSeeAlso() {
        return this.seeAlso;
    }

    public List<OtherJavadoc> getOther() {
        return this.other;
    }

    public boolean isPresent() {
        return true;
    }
}

