/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc;

import com.github.therapi.runtimejavadoc.BaseJavadoc;
import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.OtherJavadoc;
import com.github.therapi.runtimejavadoc.ParamJavadoc;
import com.github.therapi.runtimejavadoc.SeeAlsoJavadoc;
import com.github.therapi.runtimejavadoc.ThrowsJavadoc;
import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MethodJavadoc
extends BaseJavadoc {
    private final List<String> paramTypes;
    private final List<ParamJavadoc> params;
    private final List<ThrowsJavadoc> exceptions;
    private final Comment returns;

    public MethodJavadoc(String name, List<String> paramTypes, Comment comment, List<ParamJavadoc> params, List<ThrowsJavadoc> exceptions, List<OtherJavadoc> other, Comment returns, List<SeeAlsoJavadoc> seeAlso) {
        super(name, comment, seeAlso, other);
        this.paramTypes = RuntimeJavadocHelper.unmodifiableDefensiveCopy(paramTypes);
        this.params = RuntimeJavadocHelper.unmodifiableDefensiveCopy(params);
        this.exceptions = RuntimeJavadocHelper.unmodifiableDefensiveCopy(exceptions);
        this.returns = Comment.nullToEmpty(returns);
    }

    public static MethodJavadoc createEmpty(Method method) {
        return new MethodJavadoc(method.getName(), null, null, null, null, null, null, null){

            @Override
            public boolean isEmpty() {
                return true;
            }
        };
    }

    public boolean matches(Method method) {
        if (!method.getName().equals(this.getName())) {
            return false;
        }
        ArrayList<String> methodParamsTypes = new ArrayList<String>();
        for (Class<?> aClass : method.getParameterTypes()) {
            methodParamsTypes.add(aClass.getCanonicalName());
        }
        return methodParamsTypes.equals(this.paramTypes);
    }

    public List<String> getParamTypes() {
        return this.paramTypes;
    }

    public List<ParamJavadoc> getParams() {
        return this.params;
    }

    public List<ThrowsJavadoc> getThrows() {
        return this.exceptions;
    }

    public Comment getReturns() {
        return this.returns;
    }

    public String toString() {
        return "MethodJavadoc{name='" + this.getName() + '\'' + ", paramTypes='" + this.paramTypes + '\'' + ", comment=" + this.getComment() + ", params=" + this.params + ", exceptions=" + this.exceptions + ", other=" + this.getOther() + ", returns=" + this.returns + ", seeAlso=" + this.getSeeAlso() + '}';
    }
}

