/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc.internal.parser;

import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.CommentElement;
import com.github.therapi.runtimejavadoc.CommentText;
import com.github.therapi.runtimejavadoc.InlineLink;
import com.github.therapi.runtimejavadoc.InlineTag;
import com.github.therapi.runtimejavadoc.Link;
import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CommentParser {
    private static final Pattern inlineTag = Pattern.compile("\\{@(\\w+)(?:\\s+([\\w#][^}]+)?)?}");
    private static final Pattern linkPattern = Pattern.compile("^(?<classname>[\\w\\.]+)?(?:#(?<member>\\w+))?(?:\\((?<params>.*)\\))?(?:\\s(?<label>\\w+(?:\\s\\w+)*))?$");

    CommentParser() {
    }

    static Comment parse(String owningClass, String commentText) {
        return RuntimeJavadocHelper.isBlank(commentText) ? Comment.createEmpty() : new Comment(CommentParser.parseElements(owningClass, commentText.trim()));
    }

    private static List<CommentElement> parseElements(String owningClass, String commentText) {
        Matcher matcher = inlineTag.matcher(commentText);
        ArrayList<CommentElement> elements = new ArrayList<CommentElement>();
        int pos = 0;
        while (matcher.find()) {
            int start = matcher.start();
            if (start > pos) {
                elements.add(new CommentText(commentText.substring(pos, start)));
            }
            CommentElement elt = CommentParser.createTagElement(owningClass, matcher.group(1), matcher.group(2));
            elements.add(elt);
            pos = matcher.end();
        }
        if (pos < commentText.length()) {
            elements.add(new CommentText(commentText.substring(pos)));
        }
        return elements;
    }

    private static CommentElement createTagElement(String owningClass, String name, String value) {
        if ("link".equals(name)) {
            return CommentParser.createLinkElement(owningClass, value);
        }
        return new InlineTag(name, value);
    }

    private static InlineLink createLinkElement(String owningClass, String value) {
        Matcher linkMatcher = linkPattern.matcher(value);
        if (!linkMatcher.matches()) {
            throw new AssertionError((Object)"Link didn't match regex format");
        }
        String classRef = linkMatcher.group("classname");
        String memberRef = linkMatcher.group("member");
        String params = linkMatcher.group("params");
        String label = linkMatcher.group("label");
        String effectiveClassName = classRef == null ? owningClass : classRef;
        String effectiveLabel = label != null ? label : linkMatcher.group(0);
        return new InlineLink(new Link(effectiveLabel, effectiveClassName, memberRef, CommentParser.formatMember(params)));
    }

    private static List<String> formatMember(String params) {
        if (params != null && !params.trim().isEmpty()) {
            return Arrays.asList(params.trim().split(",\\s*"));
        }
        return Collections.emptyList();
    }
}

