/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc;

import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.FieldJavadoc;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.internal.JsonJavadocReader;
import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.Json;
import com.github.therapi.runtimejavadoc.repack.com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class RuntimeJavadoc {
    private RuntimeJavadoc() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static ClassJavadoc getJavadoc(Class clazz) {
        return RuntimeJavadoc.getJavadoc(clazz.getName(), clazz);
    }

    public static ClassJavadoc getJavadoc(String qualifiedClassName) {
        return RuntimeJavadoc.getJavadoc(qualifiedClassName, RuntimeJavadoc.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassJavadoc getJavadoc(String qualifiedClassName, ClassLoader classLoader) {
        String resourceName = RuntimeJavadoc.getResourceName(qualifiedClassName);
        try (InputStream is = classLoader.getResourceAsStream(resourceName);){
            ClassJavadoc classJavadoc = RuntimeJavadoc.parseJavadocResource(qualifiedClassName, is);
            return classJavadoc;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassJavadoc getJavadoc(String qualifiedClassName, Class loader) {
        String resourceName = RuntimeJavadoc.getResourceName(qualifiedClassName);
        try (InputStream is = loader.getResourceAsStream("/" + resourceName);){
            ClassJavadoc classJavadoc = RuntimeJavadoc.parseJavadocResource(qualifiedClassName, is);
            return classJavadoc;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getResourceName(String qualifiedClassName) {
        return qualifiedClassName.replace(".", "/") + RuntimeJavadocHelper.javadocResourceSuffix();
    }

    private static ClassJavadoc parseJavadocResource(String qualifiedClassName, InputStream is) throws IOException {
        if (is == null) {
            return ClassJavadoc.createEmpty(qualifiedClassName);
        }
        try (InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);){
            JsonObject json = Json.parse(r).asObject();
            ClassJavadoc classJavadoc = JsonJavadocReader.readClassJavadoc(qualifiedClassName, json);
            return classJavadoc;
        }
    }

    public static MethodJavadoc getJavadoc(Method method) {
        ClassJavadoc javadoc = RuntimeJavadoc.getJavadoc(method.getDeclaringClass());
        return RuntimeJavadoc.findMethodJavadoc(javadoc.getMethods(), method);
    }

    private static MethodJavadoc findMethodJavadoc(List<MethodJavadoc> methodDocs, Method method) {
        for (MethodJavadoc methodJavadoc : methodDocs) {
            if (!methodJavadoc.matches(method)) continue;
            return methodJavadoc;
        }
        return MethodJavadoc.createEmpty(method);
    }

    public static FieldJavadoc getJavadoc(Field field) {
        ClassJavadoc javadoc = RuntimeJavadoc.getJavadoc(field.getDeclaringClass());
        return RuntimeJavadoc.findFieldJavadoc(javadoc.getFields(), field.getName());
    }

    public static FieldJavadoc getJavadoc(Enum<?> enumValue) {
        ClassJavadoc javadoc = RuntimeJavadoc.getJavadoc(enumValue.getDeclaringClass());
        return RuntimeJavadoc.findFieldJavadoc(javadoc.getEnumConstants(), enumValue.name());
    }

    private static FieldJavadoc findFieldJavadoc(List<FieldJavadoc> fieldDocs, String fieldName) {
        for (FieldJavadoc fDoc : fieldDocs) {
            if (!fDoc.getName().equals(fieldName)) continue;
            return fDoc;
        }
        return FieldJavadoc.createEmpty(fieldName);
    }
}

