/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc.internal.parser;

import com.github.therapi.runtimejavadoc.Link;
import com.github.therapi.runtimejavadoc.SeeAlsoJavadoc;
import com.github.therapi.runtimejavadoc.internal.parser.LinkParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SeeAlsoParser {
    private static final Pattern stringLiteralPattern = Pattern.compile("^\"(?<string>.*)\"$");
    private static final Pattern htmlLink = Pattern.compile("(?s)<a\\s*href=['\"](?<link>.+?)['\"]\\s*>(?<text>.+)<\\/a>");

    public static SeeAlsoJavadoc parseSeeAlso(String owningClass, String value) {
        SeeAlsoJavadoc seeAlsoJavadoc = SeeAlsoParser.parseAsStringLiteral(value);
        if (seeAlsoJavadoc == null) {
            seeAlsoJavadoc = SeeAlsoParser.parseAsHtmlLink(value);
        }
        if (seeAlsoJavadoc == null) {
            seeAlsoJavadoc = SeeAlsoParser.parseAsJavadocLink(owningClass, value);
        }
        if (seeAlsoJavadoc == null) {
            throw new AssertionError((Object)"SeeAlso not recognized as string literal, HTML link or Javadoc link");
        }
        return seeAlsoJavadoc;
    }

    private static SeeAlsoJavadoc parseAsStringLiteral(String value) {
        Matcher stringLiteralMatcher = stringLiteralPattern.matcher(value);
        return stringLiteralMatcher.find() ? new SeeAlsoJavadoc(stringLiteralMatcher.group("string")) : null;
    }

    private static SeeAlsoJavadoc parseAsHtmlLink(String value) {
        Matcher matcher = htmlLink.matcher(value);
        if (matcher.matches()) {
            return new SeeAlsoJavadoc(new SeeAlsoJavadoc.HtmlLink(matcher.group("text"), matcher.group("link")));
        }
        return null;
    }

    private static SeeAlsoJavadoc parseAsJavadocLink(String owningClass, String value) {
        Link javadocLink = LinkParser.createLinkElement(owningClass, value);
        return javadocLink == null ? null : new SeeAlsoJavadoc(javadocLink);
    }
}

