/*
 * Decompiled with CFR 0.152.
 */
package io.kimo.lib.faker;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.ToggleButton;
import io.kimo.lib.faker.FakerCoreComponent;
import io.kimo.lib.faker.component.FakerColorComponent;
import io.kimo.lib.faker.component.FakerNumericComponent;
import io.kimo.lib.faker.component.FakerTextComponent;
import io.kimo.lib.faker.component.number.ColorComponent;
import io.kimo.lib.faker.component.number.NumberComponent;
import io.kimo.lib.faker.component.text.AddressComponent;
import io.kimo.lib.faker.component.text.InternetComponent;
import io.kimo.lib.faker.component.text.LoremComponent;
import io.kimo.lib.faker.component.text.NameComponent;
import io.kimo.lib.faker.component.text.PhoneComponent;
import io.kimo.lib.faker.component.text.URLComponent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;

public class Faker {
    private static Faker mFaker;
    public static LoremComponent Lorem;
    public static NameComponent Name;
    public static NumberComponent Number;
    public static PhoneComponent Phone;
    public static InternetComponent Internet;
    public static URLComponent Url;
    public static ColorComponent Color;
    public static AddressComponent Address;
    private HashSet<Integer> mIds = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Faker with(Context context) {
        if (mFaker != null) return mFaker;
        Class<Faker> clazz = Faker.class;
        synchronized (Faker.class) {
            if (mFaker != null) return mFaker;
            mFaker = new Faker(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mFaker;
        }
    }

    private Faker(Context context) {
        Lorem = new LoremComponent(context);
        Name = new NameComponent(context);
        Number = new NumberComponent(context);
        Phone = new PhoneComponent(context);
        Internet = new InternetComponent(context);
        Url = new URLComponent(context);
        Color = new ColorComponent(context);
        Address = new AddressComponent(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(View view) {
        this.validateNotNullableView(view);
        try {
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    View child = viewGroup.getChildAt(i);
                    this.fill(child);
                }
            } else if (this.mIds == null) {
                this.fillView(view);
            } else if (this.mIds.contains(view.getId())) {
                this.fillView(view);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            mFaker = null;
        }
    }

    public void fillWithText(TextView view, FakerTextComponent component) {
        this.validateNotNullableView((View)view);
        this.validateIfIsATextView((View)view);
        this.validateNotNullableFakerComponent(component);
        view.setText((CharSequence)component.randomText());
    }

    public Faker targetViews(Integer ... ids) {
        this.mIds = new HashSet<Integer>(Arrays.asList(ids));
        return this;
    }

    public void fillWithNumber(TextView view, FakerNumericComponent component) {
        this.validateNotNullableView((View)view);
        this.validateIfIsATextView((View)view);
        this.validateNotNullableFakerComponent(component);
        view.setText((CharSequence)String.valueOf(component.randomNumber()));
    }

    public void fillWithColor(View view, FakerColorComponent component) {
        this.validateNotNullableView(view);
        this.validateNotNullableFakerComponent(component);
        view.setBackgroundColor(component.randomColor());
    }

    public void fillWithCheckState(CompoundButton view) {
        this.validateNotNullableView((View)view);
        this.validateIfIsACompoundButton((View)view);
        view.setChecked(new Random().nextBoolean());
    }

    public void fillOnAndOffWithText(ToggleButton view, FakerTextComponent component) {
        this.validateNotNullableView((View)view);
        this.validateIfIsAToggleButton((View)view);
        this.validateNotNullableFakerComponent(component);
        String word = component.randomText();
        view.setTextOff((CharSequence)word);
        view.setTextOn((CharSequence)word);
    }

    public void fillWithProgress(ProgressBar view, FakerNumericComponent component) {
        this.validateNotNullableView((View)view);
        this.validateIfIsAProgressBar((View)view);
        this.validateNotNullableFakerComponent(component);
        view.setProgress(Math.abs(component.randomNumber().intValue()));
    }

    private void fillView(View view) {
        if (view instanceof TextView) {
            if (view instanceof ToggleButton) {
                this.fillOnAndOffWithText((ToggleButton)view, Lorem);
            } else {
                this.fillWithText((TextView)view, Lorem);
            }
        }
        if (view instanceof CompoundButton) {
            this.fillWithCheckState((CompoundButton)view);
        }
        if (view instanceof ImageView) {
            this.fillWithColor(view, Color);
        }
        if (view instanceof ProgressBar) {
            this.fillWithProgress((ProgressBar)view, Number);
        }
    }

    private void validateIfIsACompoundButton(View view) {
        if (!(view instanceof CompoundButton)) {
            throw new IllegalArgumentException("View must be a CompoundButton");
        }
    }

    private void validateIfIsATextView(View view) {
        if (!(view instanceof TextView)) {
            throw new IllegalArgumentException("View must be a TextView");
        }
    }

    private void validateNotNullableView(View view) {
        if (view == null) {
            throw new IllegalArgumentException("View must not be null");
        }
    }

    private void validateNotNullableFakerComponent(FakerCoreComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("FakerComponent must not be null");
        }
    }

    private void validateIfIsAToggleButton(View view) {
        if (!(view instanceof ToggleButton)) {
            throw new IllegalArgumentException("View must be a ToggleButton");
        }
    }

    private void validateIfIsAProgressBar(View view) {
        if (!(view instanceof ProgressBar)) {
            throw new IllegalArgumentException("View must be a ProgressBar");
        }
    }
}

