/*
 * Decompiled with CFR 0.152.
 */
package io.kimo.lib.faker.component.number;

import android.content.Context;
import io.kimo.lib.faker.api.NumberAPI;
import io.kimo.lib.faker.component.FakerNumericComponent;
import java.util.Random;

public class NumberComponent
extends FakerNumericComponent
implements NumberAPI {
    public NumberComponent(Context context) {
        super(context);
    }

    @Override
    public Number randomNumber() {
        int method = (int)(Math.random() * 10.0);
        switch (method % 6) {
            case 0: {
                return new Integer(this.digit());
            }
            case 1: {
                return new Integer(this.positiveDigit());
            }
            case 2: {
                return new Integer(this.negativeDigit());
            }
            case 3: {
                return new Integer(this.number());
            }
            case 4: {
                return new Integer(this.positiveNumber());
            }
            case 5: {
                return new Integer(this.negativeNumber());
            }
        }
        return new Integer(0);
    }

    private int randomNumberInRangePositiveOrNegative(int min, int max) {
        return new Random().nextInt(max - min + 1) + min;
    }

    @Override
    public int digit() {
        return this.randomNumberInRangePositiveOrNegative(-9, 9);
    }

    @Override
    public int positiveDigit() {
        return this.randomNumberInRangePositiveOrNegative(0, 9);
    }

    @Override
    public int negativeDigit() {
        return this.randomNumberInRangePositiveOrNegative(-9, -1);
    }

    @Override
    public int number() {
        int randomSignal = (int)Math.random() * 10;
        if (randomSignal % 2 == 0) {
            return this.number(this.randomNumberInRangePositiveOrNegative(1, 9));
        }
        return -this.number(this.randomNumberInRangePositiveOrNegative(1, 9));
    }

    @Override
    public int number(int amountOfDigits) {
        if (amountOfDigits < 1) {
            throw new IllegalArgumentException("Argument must be bigger than 0");
        }
        StringBuilder randomNumbers = new StringBuilder();
        for (int i = 0; i < amountOfDigits; ++i) {
            randomNumbers.append(this.randomNumberInRangePositiveOrNegative(1, 9));
        }
        return Math.abs(Integer.parseInt(randomNumbers.toString()));
    }

    @Override
    public int positiveNumber() {
        return Math.abs(this.number());
    }

    @Override
    public int negativeNumber() {
        return -this.positiveNumber();
    }
}

