/*
 * Decompiled with CFR 0.152.
 */
package io.kimo.lib.faker.component.text;

import android.content.Context;
import io.kimo.lib.faker.R;
import io.kimo.lib.faker.api.AddressAPI;
import io.kimo.lib.faker.component.FakerTextComponent;
import io.kimo.lib.faker.component.number.NumberComponent;
import io.kimo.lib.faker.component.text.NameComponent;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class AddressComponent
extends FakerTextComponent
implements AddressAPI {
    private NameComponent nameComponent;
    private NumberComponent numberComponent;
    private List<String> cityPrefixes;
    private List<String> citySuffixes;
    private List<String> streetSuffixes;
    private List<String> secondaryAddressPrefixes;
    private List<String> zipCodeMasks;
    private List<String> timezones;
    private List<String> states;
    private List<String> statesAbbrv;
    private List<String> countries;
    private List<String> countriesAbbrv;

    public AddressComponent(Context context) {
        super(context);
        this.nameComponent = new NameComponent(context);
        this.numberComponent = new NumberComponent(context);
        this.cityPrefixes = Arrays.asList(context.getResources().getStringArray(R.array.city_prefixes));
        this.citySuffixes = Arrays.asList(context.getResources().getStringArray(R.array.city_suffixes));
        this.streetSuffixes = Arrays.asList(context.getResources().getStringArray(R.array.street_suffixes));
        this.secondaryAddressPrefixes = Arrays.asList(context.getResources().getStringArray(R.array.secondary_address_prefixes));
        this.zipCodeMasks = Arrays.asList(context.getResources().getStringArray(R.array.zipcode_masks));
        this.timezones = Arrays.asList(context.getResources().getStringArray(R.array.timezone));
        this.states = Arrays.asList(context.getResources().getStringArray(R.array.states));
        this.statesAbbrv = Arrays.asList(context.getResources().getStringArray(R.array.states_abbrv));
        this.countries = Arrays.asList(context.getResources().getStringArray(R.array.countries));
        this.countriesAbbrv = Arrays.asList(context.getResources().getStringArray(R.array.countries_abbrv));
    }

    private String numbersInMask(String mask, char maskPlaceholder) {
        StringBuilder phoneInMask = new StringBuilder();
        for (int i = 0; i < mask.length(); ++i) {
            char currentChar = mask.charAt(i);
            if (currentChar == maskPlaceholder) {
                phoneInMask.append(this.numberComponent.positiveDigit());
                continue;
            }
            phoneInMask.append(currentChar);
        }
        return phoneInMask.toString();
    }

    @Override
    public String city() {
        Random random = new Random();
        StringBuilder cityName = new StringBuilder();
        boolean withFirstName = random.nextBoolean();
        boolean withPrefix = random.nextBoolean();
        boolean withSuffix = withPrefix ? random.nextBoolean() : true;
        if (withPrefix) {
            cityName.append(this.cityPrefix());
        }
        cityName.append(" ");
        if (withFirstName) {
            cityName.append(this.nameComponent.firstName());
        } else {
            cityName.append(this.nameComponent.lastName());
        }
        if (withSuffix) {
            cityName.append(" ");
            cityName.append(this.citySuffix());
        }
        return cityName.toString();
    }

    @Override
    public String street() {
        boolean firstName = new Random().nextBoolean();
        if (firstName) {
            return this.nameComponent.firstName() + " " + this.streetSuffixes.get(new Random().nextInt(this.streetSuffixes.size()));
        }
        return this.nameComponent.lastName() + " " + this.streetSuffixes.get(new Random().nextInt(this.streetSuffixes.size()));
    }

    @Override
    public String streetWithNumber() {
        return this.buildingNumber() + " " + this.street();
    }

    @Override
    public String secondaryAddress() {
        return this.secondaryAddressPrefixes.get(new Random().nextInt(this.secondaryAddressPrefixes.size())) + " " + this.buildingNumber();
    }

    @Override
    public String buildingNumber() {
        return this.numberComponent.positiveNumber() + "";
    }

    @Override
    public String zipCode() {
        String mask = this.zipCodeMasks.get(new Random().nextInt(this.zipCodeMasks.size()));
        return this.numbersInMask(mask, '#');
    }

    @Override
    public String postCode() {
        return this.zipCode();
    }

    @Override
    public String timeZone() {
        return this.timezones.get(new Random().nextInt(this.timezones.size()));
    }

    @Override
    public String citySuffix() {
        return this.citySuffixes.get(new Random().nextInt(this.citySuffixes.size()));
    }

    @Override
    public String cityPrefix() {
        return this.cityPrefixes.get(new Random().nextInt(this.cityPrefixes.size()));
    }

    @Override
    public String state() {
        return this.states.get(new Random().nextInt(this.states.size()));
    }

    @Override
    public String stateAbbreviation() {
        return this.statesAbbrv.get(new Random().nextInt(this.statesAbbrv.size()));
    }

    @Override
    public String country() {
        return this.countries.get(new Random().nextInt(this.countries.size()));
    }

    @Override
    public String countryAbbreviation() {
        return this.countriesAbbrv.get(new Random().nextInt(this.countriesAbbrv.size()));
    }

    @Override
    public String latitude() {
        return String.valueOf(Math.random() * 180.0 - 90.0);
    }

    @Override
    public String longitude() {
        return String.valueOf(Math.random() * 360.0 - 90.0);
    }

    @Override
    public String randomText() {
        int method = (int)Math.random() * 10;
        switch (method % 15) {
            case 0: {
                return this.city();
            }
            case 1: {
                return this.street();
            }
            case 2: {
                return this.streetWithNumber();
            }
            case 3: {
                return this.secondaryAddress();
            }
            case 4: {
                return this.buildingNumber();
            }
            case 5: {
                return this.zipCode();
            }
            case 6: {
                return this.postCode();
            }
            case 7: {
                return this.citySuffix();
            }
            case 8: {
                return this.cityPrefix();
            }
            case 9: {
                return this.state();
            }
            case 10: {
                return this.stateAbbreviation();
            }
            case 11: {
                return this.country();
            }
            case 12: {
                return this.countryAbbreviation();
            }
            case 13: {
                return this.latitude();
            }
            case 14: {
                return this.longitude();
            }
        }
        return "";
    }
}

