/*
 * Decompiled with CFR 0.152.
 */
package io.kimo.lib.faker.component.text;

import android.content.Context;
import io.kimo.lib.faker.R;
import io.kimo.lib.faker.api.InternetAPI;
import io.kimo.lib.faker.component.FakerTextComponent;
import io.kimo.lib.faker.component.text.NameComponent;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class InternetComponent
extends FakerTextComponent
implements InternetAPI {
    private NameComponent nameComponent;
    private List<String> domainSuffix;

    public InternetComponent(Context context) {
        super(context);
        this.nameComponent = new NameComponent(context);
        this.domainSuffix = Arrays.asList(context.getResources().getStringArray(R.array.domain_suffixes));
    }

    @Override
    public String randomText() {
        int method = (int)(Math.random() * 10.0);
        switch (method % 4) {
            case 0: {
                return this.email();
            }
            case 1: {
                return this.domain();
            }
            case 2: {
                return this.domainSuffix();
            }
            case 3: {
                return this.url();
            }
        }
        return "";
    }

    @Override
    public String email() {
        return this.email(this.nameComponent.firstName(), this.domain(), this.domainSuffix());
    }

    @Override
    public String email(String name, String domain, String suffix) {
        return (name + "@" + domain + suffix).toLowerCase();
    }

    @Override
    public String domain() {
        return this.nameComponent.lastName().toLowerCase();
    }

    @Override
    public String domainSuffix() {
        return this.domainSuffix(this.domainSuffix.get(new Random().nextInt(this.domainSuffix.size())));
    }

    @Override
    public String domainSuffix(String suffix) {
        return "." + suffix;
    }

    @Override
    public String url() {
        return this.url(this.nameComponent.lastName(), this.domainSuffix());
    }

    @Override
    public String url(String domain, String suffix) {
        return ("http://" + domain + suffix).toLowerCase();
    }
}

