/*
 * Decompiled with CFR 0.152.
 */
package io.kimo.lib.faker.component.text;

import android.content.Context;
import android.text.TextUtils;
import io.kimo.lib.faker.R;
import io.kimo.lib.faker.api.LoremAPI;
import io.kimo.lib.faker.component.FakerTextComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class LoremComponent
extends FakerTextComponent
implements LoremAPI {
    public static final int[] DEFAULT_RANDOM_NUMBERS_POOL = new int[]{3, 4, 5, 6, 7};
    public static final int DEFAULT_NUMBER_OF_CHARACTERS = 255;
    public static final String ALPHA_NUMERIC_CHARACTERS = "0123456789abcdefghijklmnopqrstuwvxyz";
    public static final String INVALID_ARGUMENT_ERROR_MSG = "Argument should be bigger than 0";
    private List<String> loremWords;

    public LoremComponent(Context context) {
        super(context);
        this.loremWords = Arrays.asList(context.getResources().getStringArray(R.array.lorem_words));
    }

    @Override
    public String randomText() {
        int method = (int)(Math.random() * 10.0);
        switch (method % 4) {
            case 0: {
                return this.characters();
            }
            case 1: {
                return this.words();
            }
            case 2: {
                return this.sentences();
            }
            case 3: {
                return this.paragraphs();
            }
        }
        return "";
    }

    @Override
    public String word() {
        return this.loremWords.get(new Random().nextInt(this.loremWords.size()));
    }

    @Override
    public String words() {
        int numberOfWords = DEFAULT_RANDOM_NUMBERS_POOL[new Random().nextInt(DEFAULT_RANDOM_NUMBERS_POOL.length)];
        return this.words(numberOfWords);
    }

    @Override
    public String words(int numberOfWords) {
        if (numberOfWords < 1) {
            throw new IllegalArgumentException(INVALID_ARGUMENT_ERROR_MSG);
        }
        ArrayList<String> loremWords = new ArrayList<String>();
        for (int i = 0; i < numberOfWords; ++i) {
            loremWords.add(this.word());
        }
        return TextUtils.join((CharSequence)" ", loremWords);
    }

    @Override
    public String sentence() {
        String randomWords = this.words();
        return randomWords.substring(0, 1).toUpperCase() + randomWords.substring(1) + ".";
    }

    @Override
    public String sentences() {
        int randomNumberOfSentences = DEFAULT_RANDOM_NUMBERS_POOL[new Random().nextInt(DEFAULT_RANDOM_NUMBERS_POOL.length)];
        return this.sentences(randomNumberOfSentences);
    }

    @Override
    public String sentences(int numberOfSentences) {
        if (numberOfSentences < 1) {
            throw new IllegalArgumentException(INVALID_ARGUMENT_ERROR_MSG);
        }
        ArrayList<String> sentences = new ArrayList<String>();
        for (int i = 0; i < numberOfSentences; ++i) {
            sentences.add(this.sentence());
        }
        return TextUtils.join((CharSequence)" ", sentences);
    }

    @Override
    public String character() {
        return this.characters(1);
    }

    @Override
    public String characters() {
        return this.characters(255);
    }

    @Override
    public String characters(int numberOfCharacters) {
        if (numberOfCharacters < 1) {
            throw new IllegalArgumentException(INVALID_ARGUMENT_ERROR_MSG);
        }
        StringBuilder randomCharacters = new StringBuilder();
        for (int i = 0; i < numberOfCharacters; ++i) {
            randomCharacters.append(ALPHA_NUMERIC_CHARACTERS.charAt(new Random().nextInt(ALPHA_NUMERIC_CHARACTERS.length())));
        }
        return randomCharacters.toString();
    }

    @Override
    public String paragraph() {
        return this.paragraphs(1);
    }

    @Override
    public String paragraphs() {
        int randomNumberOfParagraphs = DEFAULT_RANDOM_NUMBERS_POOL[new Random().nextInt(DEFAULT_RANDOM_NUMBERS_POOL.length)];
        return this.paragraphs(randomNumberOfParagraphs);
    }

    @Override
    public String paragraphs(int numberOfParagraphs) {
        if (numberOfParagraphs < 1) {
            throw new IllegalArgumentException(INVALID_ARGUMENT_ERROR_MSG);
        }
        StringBuilder paragraphs = new StringBuilder();
        for (int i = 0; i < numberOfParagraphs; ++i) {
            paragraphs.append(this.sentences());
            if (i == numberOfParagraphs - 1) continue;
            paragraphs.append("\n");
        }
        return paragraphs.toString();
    }
}

