/*
 * Decompiled with CFR 0.152.
 */
package io.kimo.lib.faker.component.text;

import android.content.Context;
import io.kimo.lib.faker.R;
import io.kimo.lib.faker.api.NameAPI;
import io.kimo.lib.faker.component.FakerTextComponent;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class NameComponent
extends FakerTextComponent
implements NameAPI {
    private List<String> firstNames;
    private List<String> lastNames;
    private List<String> prefixes;
    private List<String> suffixes;
    private List<String> titleDescriptons;
    private List<String> titleLevels;
    private List<String> titleJobs;

    public NameComponent(Context context) {
        super(context);
        this.firstNames = Arrays.asList(context.getResources().getStringArray(R.array.first_names));
        this.lastNames = Arrays.asList(context.getResources().getStringArray(R.array.last_names));
        this.prefixes = Arrays.asList(context.getResources().getStringArray(R.array.prefixes));
        this.suffixes = Arrays.asList(context.getResources().getStringArray(R.array.suffixes));
        this.titleDescriptons = Arrays.asList(context.getResources().getStringArray(R.array.title_descriptions));
        this.titleLevels = Arrays.asList(context.getResources().getStringArray(R.array.title_levels));
        this.titleJobs = Arrays.asList(context.getResources().getStringArray(R.array.title_jobs));
    }

    @Override
    public String randomText() {
        int method = (int)(Math.random() * 10.0);
        switch (method % 7) {
            case 0: {
                return this.firstName();
            }
            case 1: {
                return this.lastName();
            }
            case 2: {
                return this.fullName();
            }
            case 3: {
                return this.completeName();
            }
            case 4: {
                return this.prefix();
            }
            case 5: {
                return this.suffix();
            }
            case 6: {
                return this.title();
            }
        }
        return "";
    }

    @Override
    public String firstName() {
        return this.firstNames.get(new Random().nextInt(this.firstNames.size()));
    }

    @Override
    public String lastName() {
        return this.lastNames.get(new Random().nextInt(this.lastNames.size()));
    }

    @Override
    public String fullName() {
        return this.firstName() + " " + this.lastName();
    }

    @Override
    public String completeName() {
        return this.prefix() + " " + this.firstName() + " " + this.lastName() + " " + this.suffix();
    }

    @Override
    public String prefix() {
        return this.prefixes.get(new Random().nextInt(this.prefixes.size()));
    }

    @Override
    public String suffix() {
        return this.suffixes.get(new Random().nextInt(this.suffixes.size()));
    }

    @Override
    public String title() {
        return this.titleDescriptons.get(new Random().nextInt(this.titleDescriptons.size())) + " " + this.titleLevels.get(new Random().nextInt(this.titleLevels.size())) + " " + this.titleJobs.get(new Random().nextInt(this.titleJobs.size()));
    }
}

