/*
 * Decompiled with CFR 0.152.
 */
package io.kimo.lib.faker.component.text;

import android.content.Context;
import io.kimo.lib.faker.R;
import io.kimo.lib.faker.api.PhoneAPI;
import io.kimo.lib.faker.component.FakerTextComponent;
import io.kimo.lib.faker.component.number.NumberComponent;

public class PhoneComponent
extends FakerTextComponent
implements PhoneAPI {
    private String areaCodeMask;
    private String countryCodeMask;
    private NumberComponent numberComponent;

    public PhoneComponent(Context context) {
        super(context);
        this.numberComponent = new NumberComponent(context);
        this.areaCodeMask = context.getResources().getString(R.string.area_code_phone_mask);
        this.countryCodeMask = context.getResources().getString(R.string.country_code_phone_mask);
    }

    @Override
    public String randomText() {
        int method = (int)(Math.random() * 10.0);
        switch (method % 2) {
            case 0: {
                return this.phoneWithAreaCode();
            }
            case 1: {
                return this.phoneWithCountryCode();
            }
        }
        return "";
    }

    private String numbersInMask(String mask, char maskPlaceholder) {
        StringBuilder phoneInMask = new StringBuilder();
        for (int i = 0; i < mask.length(); ++i) {
            char currentChar = mask.charAt(i);
            if (currentChar == maskPlaceholder) {
                phoneInMask.append(this.numberComponent.positiveDigit());
                continue;
            }
            phoneInMask.append(currentChar);
        }
        return phoneInMask.toString();
    }

    @Override
    public String phoneWithAreaCode() {
        return this.numbersInMask(this.areaCodeMask, '#');
    }

    @Override
    public String phoneWithCountryCode() {
        return this.numbersInMask(this.countryCodeMask, '#');
    }
}

