/*
 * Decompiled with CFR 0.152.
 */
package io.kimo.lib.faker.component.text;

import android.content.Context;
import io.kimo.lib.faker.api.UrlAPI;
import io.kimo.lib.faker.component.FakerTextComponent;
import io.kimo.lib.faker.component.text.NameComponent;

public class URLComponent
extends FakerTextComponent
implements UrlAPI {
    private static final String BASE_IMAGE_URL = "http://lorempixel.com/";
    private static final String BASE_AVATAR_URL = "https://robohash.org/";
    private static final int DEFAULT_DIMENSION = 300;
    private NameComponent nameComponent;

    public URLComponent(Context context) {
        super(context);
        this.nameComponent = new NameComponent(context);
    }

    @Override
    public String randomText() {
        int method = (int)(Math.random() * 10.0);
        switch (method % 2) {
            case 0: {
                return this.image();
            }
            case 1: {
                return this.avatar();
            }
        }
        return "";
    }

    @Override
    public String image() {
        return this.image(300, 300);
    }

    @Override
    public String image(int width, int height) {
        return BASE_IMAGE_URL + width + "/" + height;
    }

    @Override
    public String avatar() {
        return this.avatar(300, 300);
    }

    @Override
    public String avatar(int width, int height) {
        return BASE_AVATAR_URL + this.nameComponent.firstName() + "?size=" + width + "x" + height;
    }
}

