/*
 * Decompiled with CFR 0.152.
 */
package io.kimo.gameoflifeview.game;

import io.kimo.gameoflifeview.game.Cell;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class World {
    private int width;
    private int height;
    private Cell[] cells;
    private Cell[][] board;

    public World(int width, int height) {
        this.width = width;
        this.height = height;
        this.cells = new Cell[this.width * this.height];
        this.board = new Cell[this.width][this.height];
        this.setup(false);
    }

    public World(int width, int height, boolean random) {
        this.width = width;
        this.height = height;
        this.cells = new Cell[this.width * this.height];
        this.board = new Cell[this.width][this.height];
        this.setup(random);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Cell[] getCells() {
        return this.cells;
    }

    public Cell[][] getBoard() {
        return this.board;
    }

    private void setup(boolean random) {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                this.board[i][j] = random ? new Cell(i, j, new Random().nextBoolean()) : new Cell(i, j);
            }
        }
        this.updateCells();
    }

    private void updateCells() {
        ArrayList<Cell> boardCells = new ArrayList<Cell>();
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                boardCells.add(this.board[i][j]);
            }
        }
        this.cells = boardCells.toArray(new Cell[this.width * this.height]);
    }

    public Cell get(int i, int j) {
        return this.board[i][j];
    }

    public void kill(int i, int j) {
        this.board[i][j].die();
    }

    public void revive(int i, int j) {
        this.board[i][j].reborn();
    }

    public Cell[] liveNeighboursOf(int i, int j) {
        Cell neighbour;
        ArrayList<Cell> liveNeighbours = new ArrayList<Cell>();
        if (i - 1 >= 0 && j + 1 <= this.height - 1) {
            neighbour = this.get(i - 1, j + 1);
            if (neighbour.isAlive) {
                liveNeighbours.add(neighbour);
            }
        }
        if (j + 1 <= this.height - 1) {
            neighbour = this.get(i, j + 1);
            if (neighbour.isAlive) {
                liveNeighbours.add(neighbour);
            }
        }
        if (i + 1 <= this.width - 1 && j + 1 <= this.height - 1) {
            neighbour = this.get(i + 1, j + 1);
            if (neighbour.isAlive) {
                liveNeighbours.add(neighbour);
            }
        }
        if (i - 1 >= 0) {
            neighbour = this.get(i - 1, j);
            if (neighbour.isAlive) {
                liveNeighbours.add(neighbour);
            }
        }
        if (i + 1 <= this.width - 1) {
            neighbour = this.get(i + 1, j);
            if (neighbour.isAlive) {
                liveNeighbours.add(neighbour);
            }
        }
        if (i - 1 >= 0 && j - 1 >= 0) {
            neighbour = this.get(i - 1, j - 1);
            if (neighbour.isAlive) {
                liveNeighbours.add(neighbour);
            }
        }
        if (j - 1 >= 0) {
            neighbour = this.get(i, j - 1);
            if (neighbour.isAlive) {
                liveNeighbours.add(neighbour);
            }
        }
        if (i + 1 <= this.width - 1 && j - 1 >= 0) {
            neighbour = this.get(i + 1, j - 1);
            if (neighbour.isAlive) {
                liveNeighbours.add(neighbour);
            }
        }
        return liveNeighbours.toArray(new Cell[liveNeighbours.size()]);
    }

    public void rotate() {
        ArrayList<Cell> futureLiveCells = new ArrayList<Cell>();
        ArrayList<Cell> futureDeadCells = new ArrayList<Cell>();
        for (Cell cell : this.cells) {
            Cell[] neighbours = this.liveNeighboursOf(cell.x, cell.y);
            if (this.rule1(cell, neighbours)) {
                futureDeadCells.add(cell);
            }
            if (this.rule2(cell, neighbours)) {
                futureLiveCells.add(cell);
            }
            if (this.rule3(cell, neighbours)) {
                futureDeadCells.add(cell);
            }
            if (!this.rule4(cell, neighbours)) continue;
            futureLiveCells.add(cell);
        }
        this.updateBoard(futureLiveCells, futureDeadCells);
        this.updateCells();
    }

    private void updateBoard(List<Cell> lives, List<Cell> deads) {
        for (Cell cell : lives) {
            this.revive(cell.x, cell.y);
        }
        for (Cell cell : deads) {
            this.kill(cell.x, cell.y);
        }
    }

    private boolean rule1(Cell c, Cell[] n) {
        return c.isAlive && n.length < 2;
    }

    private boolean rule2(Cell c, Cell[] n) {
        return c.isAlive && (n.length == 3 || n.length == 2);
    }

    private boolean rule3(Cell c, Cell[] n) {
        return c.isAlive && n.length > 3;
    }

    private boolean rule4(Cell c, Cell[] n) {
        return !c.isAlive && n.length == 3;
    }
}

