/*
 * Decompiled with CFR 0.152.
 */
package io.kimo.gameoflifeview.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.Display;
import android.view.SurfaceView;
import android.view.WindowManager;
import io.kimo.gameoflifeview.R;
import io.kimo.gameoflifeview.game.Cell;
import io.kimo.gameoflifeview.game.World;

public class GameOfLifeView
extends SurfaceView
implements Runnable {
    public static final int DEFAULT_PROPORTION = 50;
    public static final int DEFAULT_ALIVE_COLOR = -16777216;
    public static final int DEFAULT_DEAD_COLOR = -1;
    private Thread thread;
    private boolean isRunning = false;
    private int columnWidth = 1;
    private int rowHeight = 1;
    private int numberOfColumns = 1;
    private int numberOfRows = 1;
    private World world;
    private int proportion = 50;
    private int aliveColor = -16777216;
    private int deadColor = -1;

    public GameOfLifeView(Context context) {
        super(context);
        this.calculateWorldParams();
    }

    public GameOfLifeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.game_of_life_view, 0, 0);
        this.ensureCorrectAttributes(a);
        this.calculateWorldParams();
    }

    public GameOfLifeView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.game_of_life_view, defStyle, 0);
        this.ensureCorrectAttributes(a);
        this.calculateWorldParams();
    }

    @Override
    public void run() {
        try {
            while (this.isRunning) {
                if (!this.getHolder().getSurface().isValid()) continue;
                Canvas canvas = this.getHolder().lockCanvas();
                this.world.rotate();
                this.getHolder().unlockCanvasAndPost(this.drawCells(canvas));
            }
        }
        catch (NullPointerException e) {
            this.stop();
        }
    }

    public void begin() {
        this.thread = null;
        this.isRunning = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.isRunning = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void reviveCellsAt(float x, float y) {
        int X;
        int Y = (int)(y / (float)this.proportion);
        for (X = (int)(x / (float)this.proportion); X >= this.world.getWidth(); --X) {
        }
        while (Y >= this.world.getHeight()) {
            --Y;
        }
        this.world.revive(X, Y);
    }

    public int getProportion() {
        return this.proportion;
    }

    public void setProportion(int proportion) {
        this.proportion = proportion;
        this.invalidate();
    }

    public int getAliveColor() {
        return this.aliveColor;
    }

    public void setAliveColor(int aliveColor) {
        this.aliveColor = aliveColor;
        this.invalidate();
    }

    public int getDeadColor() {
        return this.deadColor;
    }

    public void setDeadColor(int deadColor) {
        this.deadColor = deadColor;
        this.invalidate();
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    private void calculateWorldParams() {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point point = new Point();
        display.getSize(point);
        this.numberOfColumns = point.x / this.proportion;
        this.numberOfRows = point.y / this.proportion;
        this.columnWidth = point.x / this.numberOfColumns;
        this.rowHeight = point.y / this.numberOfRows;
        this.world = new World(this.numberOfColumns, this.numberOfRows, true);
    }

    private Canvas drawCells(Canvas canvas) {
        for (Cell cell : this.world.getCells()) {
            Rect r = new Rect();
            Paint p = new Paint();
            if (cell.isAlive) {
                r.set(cell.x * this.columnWidth - 1, cell.y * this.rowHeight - 1, cell.x * this.columnWidth + this.columnWidth - 1, cell.y * this.rowHeight + this.rowHeight - 1);
                p.setColor(this.aliveColor);
            } else {
                r.set(cell.x * this.columnWidth - 1, cell.y * this.rowHeight - 1, cell.x * this.columnWidth + this.columnWidth - 1, cell.y * this.rowHeight + this.rowHeight - 1);
                p.setColor(this.deadColor);
            }
            canvas.drawRect(r, p);
        }
        return canvas;
    }

    private void ensureCorrectAttributes(TypedArray styles) {
        int styledProportion = styles.getInt(R.styleable.game_of_life_view_proportion, 50);
        if (styledProportion <= 0) {
            throw new IllegalArgumentException("Proportion must be higher than 0.");
        }
        this.proportion = styledProportion;
        this.aliveColor = styles.getColor(R.styleable.game_of_life_view_aliveCellColor, -16777216);
        this.deadColor = styles.getColor(R.styleable.game_of_life_view_deadCellColor, -1);
        styles.recycle();
    }
}

