/*
 * Decompiled with CFR 0.152.
 */
package com.github.thinker0.mesos;

import com.github.thinker0.mesos.MesosHealthCheckerServer;
import com.github.thinker0.mesos.Response;
import io.netty.channel.EventLoopGroup;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckServe
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Set<BooleanSupplier> healthCheckers = new HashSet<BooleanSupplier>();
    private final Optional<Runnable> quit;
    private final Optional<Runnable> abort;
    private final String body;
    EventLoopGroup server;

    public HealthCheckServe() {
        this("", () -> {});
    }

    public HealthCheckServe(String ok) {
        this(ok, () -> {});
    }

    public HealthCheckServe(String ok, Runnable quit) {
        this(ok, quit, () -> {});
    }

    public HealthCheckServe(String ok, Runnable quit, Runnable abort) {
        this.body = ok;
        this.quit = Optional.of(quit);
        this.abort = Optional.of(abort);
    }

    public HealthCheckServe addHealthCheck(BooleanSupplier checker) {
        this.healthCheckers.add(checker);
        return this;
    }

    public Optional<BooleanSupplier> health() {
        return ((Stream)this.healthCheckers.stream().parallel()).filter(b -> !b.getAsBoolean()).findFirst();
    }

    public HealthCheckServe quitQuitQuit() {
        this.quit.ifPresent(Runnable::run);
        return this;
    }

    public HealthCheckServe abortAbortAbort() {
        this.abort.ifPresent(Runnable::run);
        return this;
    }

    public void start() {
        int port = Integer.parseInt(System.getProperty("admin.port", "9990"));
        try {
            this.server = new MesosHealthCheckerServer(port).get("/health", () -> {
                if (this.health().isPresent()) {
                    return new Response(500, "ERROR");
                }
                return new Response(200, "OK");
            }).post("/quitquitquit", () -> {
                this.quitQuitQuit();
                return new Response(200, "OK");
            }).post("/abortabortabort", () -> {
                this.abortAbortAbort();
                this.close();
                return new Response(200, "OK");
            }).start();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.server.shutdownGracefully();
    }
}

