/*
 * Decompiled with CFR 0.152.
 */
package com.github.thinker0.mesos;

import com.github.thinker0.mesos.Handler;
import com.github.thinker0.mesos.Response;
import com.github.thinker0.mesos.Route;
import com.github.thinker0.mesos.RouteTable;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MesosHealthCheckerServer
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    public static final String TYPE_PLAIN = "text/plain; charset=UTF-8";
    public static final String TYPE_JSON = "application/json; charset=UTF-8";
    public static final String SERVER_NAME = "Netty";
    private final RouteTable routeTable = new RouteTable();
    private final int port;
    EventLoopGroup eventLoopGroup;

    MesosHealthCheckerServer(Integer port) {
        this.port = port;
    }

    private void writeNotFound(ChannelHandlerContext ctx, FullHttpRequest request) {
        this.writeErrorResponse(ctx, request, HttpResponseStatus.NOT_FOUND);
    }

    private void writeInternalServerError(ChannelHandlerContext ctx, FullHttpRequest request) {
        this.writeErrorResponse(ctx, request, HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    private void writeErrorResponse(ChannelHandlerContext ctx, FullHttpRequest request, HttpResponseStatus status) {
        this.writeResponse(ctx, request, status, TYPE_PLAIN, status.reasonPhrase());
    }

    private void writeResponse(ChannelHandlerContext ctx, FullHttpRequest request, HttpResponseStatus status, CharSequence contentType, String content) {
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        ByteBuf entity = Unpooled.wrappedBuffer((byte[])bytes);
        this.writeResponse(ctx, request, status, entity, contentType, bytes.length);
    }

    private void writeResponse(ChannelHandlerContext ctx, FullHttpRequest request, HttpResponseStatus status, ByteBuf buf, CharSequence contentType, int contentLength) {
        boolean keepAlive = this.isKeepAlive((HttpMessage)request);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, buf, false);
        ZonedDateTime dateTime = ZonedDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.RFC_1123_DATE_TIME;
        DefaultHttpHeaders headers = (DefaultHttpHeaders)response.headers();
        headers.set((CharSequence)HttpHeaderNames.SERVER, (Object)SERVER_NAME);
        headers.set((CharSequence)HttpHeaderNames.DATE, (Object)dateTime.format(formatter));
        headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)Integer.toString(contentLength));
        if (!keepAlive) {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.writeAndFlush((Object)response, ctx.voidPromise());
        }
    }

    public boolean is100ContinueExpected(HttpMessage message) {
        if (!(message instanceof HttpRequest)) {
            return false;
        }
        if (message.protocolVersion().compareTo(HttpVersion.HTTP_1_1) < 0) {
            return false;
        }
        String value = message.headers().get((CharSequence)HttpHeaderNames.EXPECT);
        return value == null ? false : (HttpHeaderValues.CONTINUE.contentEqualsIgnoreCase((CharSequence)value) ? true : message.headers().contains((CharSequence)HttpHeaderNames.EXPECT, (CharSequence)HttpHeaderValues.CONTINUE, true));
    }

    public boolean isKeepAlive(HttpMessage message) {
        String connection = message.headers().get((CharSequence)HttpHeaderNames.CONNECTION);
        return connection != null && HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)connection) ? false : (message.protocolVersion().isKeepAliveDefault() ? !HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)connection) : HttpHeaderValues.KEEP_ALIVE.contentEqualsIgnoreCase((CharSequence)connection));
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
    }

    public MesosHealthCheckerServer get(String path, Handler handler) {
        this.routeTable.addRoute(new Route(HttpMethod.GET, path, handler));
        return this;
    }

    public MesosHealthCheckerServer post(String path, Handler handler) {
        this.routeTable.addRoute(new Route(HttpMethod.POST, path, handler));
        return this;
    }

    public EventLoopGroup start() throws Exception {
        if (Epoll.isAvailable()) {
            this.eventLoopGroup = new EpollEventLoopGroup();
            this.start((EventLoopGroup)new EpollEventLoopGroup(), EpollServerSocketChannel.class);
        } else {
            this.eventLoopGroup = new NioEventLoopGroup();
            this.start((EventLoopGroup)new NioEventLoopGroup(), NioServerSocketChannel.class);
        }
        return this.eventLoopGroup;
    }

    @Override
    public void close() {
        try {
            this.eventLoopGroup.shutdownGracefully().sync();
        }
        catch (InterruptedException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(EventLoopGroup loopGroup, Class<? extends ServerChannel> serverChannelClass) throws InterruptedException {
        try {
            InetSocketAddress inet = new InetSocketAddress(this.port);
            ServerBootstrap b = new ServerBootstrap();
            b.option(ChannelOption.SO_BACKLOG, (Object)1024);
            b.option(ChannelOption.SO_REUSEADDR, (Object)true);
            ((ServerBootstrap)b.group(loopGroup).channel(serverChannelClass)).childHandler((ChannelHandler)new WebServerInitializer());
            b.childOption(ChannelOption.ALLOCATOR, (Object)new PooledByteBufAllocator(true));
            b.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
            b.childOption(ChannelOption.SO_LINGER, (Object)0);
            b.bind((SocketAddress)inet);
            this.logger.info("Listening for Admin on {}", (Object)inet);
        }
        catch (Throwable t) {
            this.logger.warn(t.getMessage(), t);
        }
    }

    private class WebServerHandler
    extends SimpleChannelInboundHandler<Object> {
        private WebServerHandler() {
        }

        public void messageReceived(ChannelHandlerContext ctx, Object msg) {
            this.channelRead0(ctx, msg);
        }

        public void channelRead0(ChannelHandlerContext ctx, Object msg) {
            if (!(msg instanceof FullHttpRequest)) {
                return;
            }
            FullHttpRequest request = (FullHttpRequest)msg;
            if (MesosHealthCheckerServer.this.is100ContinueExpected((HttpMessage)request)) {
                MesosHealthCheckerServer.send100Continue(ctx);
            }
            HttpMethod method = request.method();
            String uri = request.uri();
            Route route = MesosHealthCheckerServer.this.routeTable.findRoute(method, uri);
            if (route == null) {
                MesosHealthCheckerServer.this.writeNotFound(ctx, request);
                return;
            }
            try {
                Response response = route.getHandler().handle();
                MesosHealthCheckerServer.this.writeResponse(ctx, request, HttpResponseStatus.valueOf((int)response.getStatus()), MesosHealthCheckerServer.TYPE_PLAIN, response.getMessage());
            }
            catch (Exception ex) {
                MesosHealthCheckerServer.this.logger.warn(ex.getMessage(), (Throwable)ex);
                MesosHealthCheckerServer.this.writeInternalServerError(ctx, request);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.close();
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            ctx.flush();
        }
    }

    private class WebServerInitializer
    extends ChannelInitializer<SocketChannel> {
        private WebServerInitializer() {
        }

        public void initChannel(SocketChannel ch) throws Exception {
            ChannelPipeline p = ch.pipeline();
            p.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(4096, 8192, 8192, false));
            p.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(0x6400000));
            p.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            p.addLast("handler", (ChannelHandler)new WebServerHandler());
        }
    }
}

