/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.ForwardingHandler;
import de.thjom.java.systemd.SignalConsumer;
import de.thjom.java.systemd.UnitStateListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.exceptions.DBusException;

abstract class AbstractAdapter {
    protected final List<UnitStateListener> unitStateListeners = new ArrayList<UnitStateListener>();
    private final List<ForwardingHandler<? extends DBusSignal>> forwarders = new ArrayList<ForwardingHandler<? extends DBusSignal>>();
    private ForwardingHandler<DBus.Properties.PropertiesChanged> defaultHandler;

    protected AbstractAdapter() {
    }

    public abstract <T extends DBusSignal> void addHandler(Class<T> var1, DBusSigHandler<T> var2) throws DBusException;

    public abstract <T extends DBusSignal> void removeHandler(Class<T> var1, DBusSigHandler<T> var2) throws DBusException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DBusSignal> void addConsumer(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        SignalConsumer consumer = new SignalConsumer(arg_0 -> handler.handle(arg_0));
        ForwardingHandler forwarder = new ForwardingHandler(consumer);
        List<ForwardingHandler<? extends DBusSignal>> list = this.forwarders;
        synchronized (list) {
            this.forwarders.add(forwarder);
        }
        forwarder.startConsumer();
        this.addHandler(type, forwarder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DBusSignal> void removeConsumer(Class<T> type, DBusSigHandler<T> handler) throws DBusException {
        ForwardingHandler<? extends DBusSignal> match = null;
        List<ForwardingHandler<? extends DBusSignal>> list = this.forwarders;
        synchronized (list) {
            for (ForwardingHandler<? extends DBusSignal> forwarder : this.forwarders) {
                if (!Objects.equals(forwarder.getConsumer(), handler)) continue;
                match = forwarder;
                break;
            }
            if (match != null) {
                this.forwarders.remove(match);
            }
        }
        if (match != null) {
            ForwardingHandler<? extends DBusSignal> forwarder = match;
            this.removeHandler(type, forwarder);
            forwarder.stopConsumer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(UnitStateListener listener) throws DBusException {
        List<UnitStateListener> list = this.unitStateListeners;
        synchronized (list) {
            if (this.defaultHandler == null) {
                this.defaultHandler = new ForwardingHandler<DBus.Properties.PropertiesChanged>(this.createStateConsumer());
                this.defaultHandler.startConsumer();
                this.addHandler(DBus.Properties.PropertiesChanged.class, this.defaultHandler);
            }
            this.unitStateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(UnitStateListener listener) throws DBusException {
        List<UnitStateListener> list = this.unitStateListeners;
        synchronized (list) {
            this.unitStateListeners.remove(listener);
            if (this.unitStateListeners.isEmpty() && this.defaultHandler != null) {
                this.removeHandler(DBus.Properties.PropertiesChanged.class, this.defaultHandler);
                this.defaultHandler.stopConsumer();
                this.defaultHandler = null;
            }
        }
    }

    protected SignalConsumer<DBus.Properties.PropertiesChanged> createStateConsumer() {
        return new SignalConsumer<DBus.Properties.PropertiesChanged>(s -> {});
    }
}

