/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.SignalSequencer;
import java.util.ArrayList;
import java.util.Objects;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SignalConsumer<T extends DBusSignal>
implements Runnable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SignalSequencer<T> sequencer;
    private final DBusSigHandler<T> handler;
    private volatile boolean running = true;

    public SignalConsumer(DBusSigHandler<T> handler) {
        this(100, handler);
    }

    public SignalConsumer(int queueLength, DBusSigHandler<T> handler) {
        this.sequencer = new SignalSequencer(queueLength);
        this.handler = Objects.requireNonNull(handler);
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                T signal = this.sequencer.take();
                this.handler.handle(signal);
            }
            catch (InterruptedException signal) {}
        }
        this.log.debug("Draining sequencer queue");
        ArrayList signals = new ArrayList(this.sequencer.size());
        this.sequencer.drainTo(signals);
        for (DBusSignal signal : signals) {
            this.handler.handle(signal);
        }
        this.sequencer.clear();
    }

    public SignalSequencer<T> getSequencer() {
        return this.sequencer;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }
}

