/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.freedesktop.dbus.DBusSignal;

final class SignalSequencer<T extends DBusSignal> {
    public static final long TIMEOUT_INFINITE = -1L;
    private final BlockingQueue<T> buffer;
    private final Queue<T> sequencer;
    private long transferDelay = 50L;
    private int transferChunkSize;
    private int dequeueChunkSize;
    private int dequeued = 0;

    public SignalSequencer(int capacity) {
        this(capacity, 100);
    }

    public SignalSequencer(int capacity, int chunkSize) {
        this.buffer = new ArrayBlockingQueue<T>(capacity);
        this.sequencer = new PriorityQueue(capacity, new SignalComparator());
        if (chunkSize < 1) {
            throw new IllegalArgumentException();
        }
        this.transferChunkSize = chunkSize;
        this.dequeueChunkSize = chunkSize > 1 ? chunkSize / 2 : 1;
    }

    public void put(T item) throws InterruptedException {
        this.buffer.put(item);
    }

    public T take() throws InterruptedException {
        return this.poll(-1L, null);
    }

    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        DBusSignal head = null;
        if (this.dequeued < this.dequeueChunkSize) {
            head = (DBusSignal)this.sequencer.poll();
        } else {
            this.dequeued = 0;
        }
        if (head == null) {
            T pending = this.transfer(timeout, unit, this.transferChunkSize);
            if (pending != null) {
                head = (DBusSignal)this.sequencer.poll();
                this.sequencer.offer(pending);
            } else {
                head = (DBusSignal)this.sequencer.poll();
            }
        } else {
            ++this.dequeued;
        }
        return (T)head;
    }

    public int drainTo(Collection<? super T> drain) {
        DBusSignal head;
        ArrayList buffered = new ArrayList(this.buffer.size());
        int transferred = this.buffer.drainTo(buffered);
        this.sequencer.addAll(buffered);
        do {
            if ((head = (DBusSignal)this.sequencer.poll()) == null) continue;
            drain.add(head);
        } while (head != null);
        return transferred;
    }

    public void clear() {
        this.buffer.clear();
        this.sequencer.clear();
    }

    public int size() {
        return this.buffer.size() + this.sequencer.size();
    }

    private T transfer(long timeout, TimeUnit unit, int chunkSize) throws InterruptedException {
        DBusSignal head;
        boolean delayed = false;
        while ((head = timeout < 0L ? (DBusSignal)this.buffer.take() : (DBusSignal)this.buffer.poll(timeout, unit)) != null) {
            if (!this.sequencer.offer(head)) {
                return (T)head;
            }
            if (!delayed) {
                Thread.sleep(this.transferDelay);
                delayed = true;
            }
            if (!this.buffer.isEmpty() && chunkSize-- > 0) continue;
        }
        return null;
    }

    public long getTransferDelay() {
        return this.transferDelay;
    }

    public void setTransferDelay(long transferDelay) {
        if (transferDelay < 0L) {
            throw new IllegalArgumentException();
        }
        this.transferDelay = transferDelay;
    }

    public int getTransferChunkSize() {
        return this.transferChunkSize;
    }

    public void setTransferChunkSize(int transferChunkSize) {
        if (transferChunkSize < 0) {
            throw new IllegalArgumentException();
        }
        this.transferChunkSize = transferChunkSize;
    }

    static final class SignalComparator<T extends DBusSignal>
    implements Comparator<T> {
        SignalComparator() {
        }

        @Override
        public int compare(T s1, T s2) {
            if (s1 == null) {
                return Integer.MAX_VALUE;
            }
            if (s2 == null) {
                return Integer.MIN_VALUE;
            }
            return Long.compare(s1.getSerial(), s2.getSerial());
        }
    }
}

