/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.interfaces.SnapshotInterface;
import org.freedesktop.dbus.exceptions.DBusException;

public class Snapshot
extends Unit {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Snapshot";
    public static final String UNIT_SUFFIX = ".snapshot";

    private Snapshot(Manager manager, SnapshotInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Snapshot create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        SnapshotInterface iface = (SnapshotInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, SnapshotInterface.class);
        return new Snapshot(manager, iface, name);
    }

    @Override
    public SnapshotInterface getInterface() {
        return (SnapshotInterface)super.getInterface();
    }

    public boolean isCleanup() {
        return this.properties.getBoolean("Cleanup");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String CLEANUP = "Cleanup";

        private Property() {
        }

        public static final String[] getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }
}

