/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.interfaces.SocketInterface;
import de.thjom.java.systemd.types.AddressFamilyRestriction;
import de.thjom.java.systemd.types.AppArmorProfile;
import de.thjom.java.systemd.types.DeviceAllowControl;
import de.thjom.java.systemd.types.EnvironmentFile;
import de.thjom.java.systemd.types.ExecutionInfo;
import de.thjom.java.systemd.types.IOBandwidth;
import de.thjom.java.systemd.types.IODeviceWeight;
import de.thjom.java.systemd.types.ListenInfo;
import de.thjom.java.systemd.types.SELinuxContext;
import de.thjom.java.systemd.types.SmackProcessLabel;
import de.thjom.java.systemd.types.SystemCallFilter;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import org.freedesktop.dbus.exceptions.DBusException;

public class Socket
extends Unit {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Socket";
    public static final String UNIT_SUFFIX = ".socket";

    private Socket(Manager manager, SocketInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Socket create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        SocketInterface iface = (SocketInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, SocketInterface.class);
        return new Socket(manager, iface, name);
    }

    @Override
    public SocketInterface getInterface() {
        return (SocketInterface)super.getInterface();
    }

    public boolean isAccept() {
        return this.properties.getBoolean("Accept");
    }

    public BigInteger getAmbientCapabilities() {
        return this.properties.getBigInteger("AmbientCapabilities");
    }

    public AppArmorProfile getAppArmorProfile() {
        Object[] array = (Object[])this.properties.getVariant("AppArmorProfile").getValue();
        return new AppArmorProfile(array);
    }

    public long getBacklog() {
        return this.properties.getLong("Backlog");
    }

    public String getBindIPv6Only() {
        return this.properties.getString("BindIPv6Only");
    }

    public String getBindToDevice() {
        return this.properties.getString("BindToDevice");
    }

    public boolean isBlockIOAccounting() {
        return this.properties.getBoolean("BlockIOAccounting");
    }

    public List<IODeviceWeight> getBlockIODeviceWeight() {
        return IODeviceWeight.list(this.properties.getVector("BlockIODeviceWeight"));
    }

    public List<IOBandwidth> getBlockIOReadBandwidth() {
        return IOBandwidth.list(this.properties.getVector("BlockIOReadBandwidth"));
    }

    public BigInteger getBlockIOWeight() {
        return this.properties.getBigInteger("BlockIOWeight");
    }

    public List<IOBandwidth> getBlockIOWriteBandwidth() {
        return IOBandwidth.list(this.properties.getVector("BlockIOWriteBandwidth"));
    }

    public boolean isBroadcast() {
        return this.properties.getBoolean("Broadcast");
    }

    public boolean isCPUAccounting() {
        return this.properties.getBoolean("CPUAccounting");
    }

    public byte[] getCPUAffinity() {
        return (byte[])this.properties.getVariant("CPUAffinity").getValue();
    }

    public BigInteger getCPUQuotaPerSecUSec() {
        return this.properties.getBigInteger("CPUQuotaPerSecUSec");
    }

    public int getCPUSchedulingPolicy() {
        return this.properties.getInteger("CPUSchedulingPolicy");
    }

    public int getCPUSchedulingPriority() {
        return this.properties.getInteger("CPUSchedulingPriority");
    }

    public boolean isCPUSchedulingResetOnFork() {
        return this.properties.getBoolean("CPUSchedulingResetOnFork");
    }

    public BigInteger getCPUShares() {
        return this.properties.getBigInteger("CPUShares");
    }

    public BigInteger getCPUUsageNSec() {
        return this.properties.getBigInteger("CPUUsageNSec");
    }

    public String getCapabilities() {
        return this.properties.getString("Capabilities");
    }

    public BigInteger getCapabilityBoundingSet() {
        return this.properties.getBigInteger("CapabilityBoundingSet");
    }

    public long getControlPID() {
        return this.properties.getLong("ControlPID");
    }

    public BigInteger getDeferAcceptUSec() {
        return this.properties.getBigInteger("DeferAcceptUSec");
    }

    public boolean isDelegate() {
        return this.properties.getBoolean("Delegate");
    }

    public List<DeviceAllowControl> getDeviceAllow() {
        return DeviceAllowControl.list(this.properties.getVector("DeviceAllow"));
    }

    public String getDevicePolicy() {
        return this.properties.getString("DevicePolicy");
    }

    public long getDirectoryMode() {
        return this.properties.getLong("DirectoryMode");
    }

    public Vector<String> getEnvironment() {
        return this.properties.getVector("Environment");
    }

    public List<EnvironmentFile> getEnvironmentFiles() {
        return EnvironmentFile.list(this.properties.getVector("EnvironmentFiles"));
    }

    public List<ExecutionInfo> getExecStartPost() {
        return ExecutionInfo.list(this.properties.getVector("ExecStartPost"));
    }

    public List<ExecutionInfo> getExecStartPre() {
        return ExecutionInfo.list(this.properties.getVector("ExecStartPre"));
    }

    public List<ExecutionInfo> getExecStopPost() {
        return ExecutionInfo.list(this.properties.getVector("ExecStopPost"));
    }

    public List<ExecutionInfo> getExecStopPre() {
        return ExecutionInfo.list(this.properties.getVector("ExecStopPre"));
    }

    public String getFileDescriptorName() {
        return this.properties.getString("FileDescriptorName");
    }

    public boolean isFreeBind() {
        return this.properties.getBoolean("FreeBind");
    }

    public String getGroup() {
        return this.properties.getString("Group");
    }

    public int getIOScheduling() {
        return this.properties.getInteger("IOScheduling");
    }

    public int getIPTOS() {
        return this.properties.getInteger("IPTOS");
    }

    public int getIPTTL() {
        return this.properties.getInteger("IPTTL");
    }

    public boolean isIgnoreSIGPIPE() {
        return this.properties.getBoolean("IgnoreSIGPIPE");
    }

    public Vector<String> getInaccessibleDirectories() {
        return this.properties.getVector("InaccessibleDirectories");
    }

    public boolean isKeepAlive() {
        return this.properties.getBoolean("KeepAlive");
    }

    public BigInteger getKeepAliveIntervalUSec() {
        return this.properties.getBigInteger("KeepAliveIntervalUSec");
    }

    public long getKeepAliveProbes() {
        return this.properties.getLong("KeepAliveProbes");
    }

    public BigInteger getKeepAliveTimeUSec() {
        return this.properties.getBigInteger("KeepAliveTimeUSec");
    }

    public String getKillMode() {
        return this.properties.getString("KillMode");
    }

    public int getKillSignal() {
        return this.properties.getInteger("KillSignal");
    }

    public BigInteger getLimitAS() {
        return this.properties.getBigInteger("LimitAS");
    }

    public BigInteger getLimitASSoft() {
        return this.properties.getBigInteger("LimitASSoft");
    }

    public BigInteger getLimitCORE() {
        return this.properties.getBigInteger("LimitCORE");
    }

    public BigInteger getLimitCORESoft() {
        return this.properties.getBigInteger("LimitCORESoft");
    }

    public BigInteger getLimitCPU() {
        return this.properties.getBigInteger("LimitCPU");
    }

    public BigInteger getLimitCPUSoft() {
        return this.properties.getBigInteger("LimitCPUSoft");
    }

    public BigInteger getLimitDATA() {
        return this.properties.getBigInteger("LimitDATA");
    }

    public BigInteger getLimitDATASoft() {
        return this.properties.getBigInteger("LimitDATASoft");
    }

    public BigInteger getLimitFSIZE() {
        return this.properties.getBigInteger("LimitFSIZE");
    }

    public BigInteger getLimitFSIZESoft() {
        return this.properties.getBigInteger("LimitFSIZESoft");
    }

    public BigInteger getLimitLOCKS() {
        return this.properties.getBigInteger("LimitLOCKS");
    }

    public BigInteger getLimitLOCKSSoft() {
        return this.properties.getBigInteger("LimitLOCKSSoft");
    }

    public BigInteger getLimitMEMLOCK() {
        return this.properties.getBigInteger("LimitMEMLOCK");
    }

    public BigInteger getLimitMEMLOCKSoft() {
        return this.properties.getBigInteger("LimitMEMLOCKSoft");
    }

    public BigInteger getLimitMSGQUEUE() {
        return this.properties.getBigInteger("LimitMSGQUEUE");
    }

    public BigInteger getLimitMSGQUEUESoft() {
        return this.properties.getBigInteger("LimitMSGQUEUESoft");
    }

    public BigInteger getLimitNICE() {
        return this.properties.getBigInteger("LimitNICE");
    }

    public BigInteger getLimitNICESoft() {
        return this.properties.getBigInteger("LimitNICESoft");
    }

    public BigInteger getLimitNOFILE() {
        return this.properties.getBigInteger("LimitNOFILE");
    }

    public BigInteger getLimitNOFILESoft() {
        return this.properties.getBigInteger("LimitNOFILESoft");
    }

    public BigInteger getLimitNPROC() {
        return this.properties.getBigInteger("LimitNPROC");
    }

    public BigInteger getLimitNPROCSoft() {
        return this.properties.getBigInteger("LimitNPROCSoft");
    }

    public BigInteger getLimitRSS() {
        return this.properties.getBigInteger("LimitRSS");
    }

    public BigInteger getLimitRSSSoft() {
        return this.properties.getBigInteger("LimitRSSSoft");
    }

    public BigInteger getLimitRTPRIO() {
        return this.properties.getBigInteger("LimitRTPRIO");
    }

    public BigInteger getLimitRTPRIOSoft() {
        return this.properties.getBigInteger("LimitRTPRIOSoft");
    }

    public BigInteger getLimitRTTIME() {
        return this.properties.getBigInteger("LimitRTTIME");
    }

    public BigInteger getLimitRTTIMESoft() {
        return this.properties.getBigInteger("LimitRTTIMESoft");
    }

    public BigInteger getLimitSIGPENDING() {
        return this.properties.getBigInteger("LimitSIGPENDING");
    }

    public BigInteger getLimitSIGPENDINGSoft() {
        return this.properties.getBigInteger("LimitSIGPENDINGSoft");
    }

    public BigInteger getLimitSTACK() {
        return this.properties.getBigInteger("LimitSTACK");
    }

    public BigInteger getLimitSTACKSoft() {
        return this.properties.getBigInteger("LimitSTACKSoft");
    }

    public List<ListenInfo> getListen() {
        return ListenInfo.list(this.properties.getVector("Listen"));
    }

    public int getMark() {
        return this.properties.getInteger("Mark");
    }

    public long getMaxConnections() {
        return this.properties.getLong("MaxConnections");
    }

    public long getMaxConnectionsPerSource() {
        return this.properties.getLong("MaxConnectionsPerSource");
    }

    public boolean isMemoryAccounting() {
        return this.properties.getBoolean("MemoryAccounting");
    }

    public BigInteger getMemoryCurrent() {
        return this.properties.getBigInteger("MemoryCurrent");
    }

    public BigInteger getMemoryLimit() {
        return this.properties.getBigInteger("MemoryLimit");
    }

    public long getMessageQueueMaxMessages() {
        return this.properties.getLong("MessageQueueMaxMessages");
    }

    public long getMessageQueueMessageSize() {
        return this.properties.getLong("MessageQueueMessageSize");
    }

    public BigInteger getMountFlags() {
        return this.properties.getBigInteger("MountFlags");
    }

    public long getNAccepted() {
        return this.properties.getLong("NAccepted");
    }

    public long getNConnections() {
        return this.properties.getLong("NConnections");
    }

    public int getNice() {
        return this.properties.getInteger("Nice");
    }

    public boolean isNoDelay() {
        return this.properties.getBoolean("NoDelay");
    }

    public boolean isNoNewPrivileges() {
        return this.properties.getBoolean("NoNewPrivileges");
    }

    public boolean isNonBlocking() {
        return this.properties.getBoolean("NonBlocking");
    }

    public int getOOMScoreAdjust() {
        return this.properties.getInteger("OOMScoreAdjust");
    }

    public String getPAMName() {
        return this.properties.getString("PAMName");
    }

    public boolean isPassCredentials() {
        return this.properties.getBoolean("PassCredentials");
    }

    public Vector<String> getPassEnvironment() {
        return this.properties.getVector("PassEnvironment");
    }

    public boolean isPassSecurity() {
        return this.properties.getBoolean("PassSecurity");
    }

    public String getPersonality() {
        return this.properties.getString("Personality");
    }

    public BigInteger getPipeSize() {
        return this.properties.getBigInteger("PipeSize");
    }

    public int getPriority() {
        return this.properties.getInteger("Priority");
    }

    public boolean isPrivateDevices() {
        return this.properties.getBoolean("PrivateDevices");
    }

    public boolean isPrivateNetwork() {
        return this.properties.getBoolean("PrivateNetwork");
    }

    public boolean isPrivateTmp() {
        return this.properties.getBoolean("PrivateTmp");
    }

    public String getProtectHome() {
        return this.properties.getString("ProtectHome");
    }

    public String getProtectSystem() {
        return this.properties.getString("ProtectSystem");
    }

    public Vector<String> getReadOnlyDirectories() {
        return this.properties.getVector("ReadOnlyDirectories");
    }

    public Vector<String> getReadWriteDirectories() {
        return this.properties.getVector("ReadWriteDirectories");
    }

    public BigInteger getReceiveBuffer() {
        return this.properties.getBigInteger("ReceiveBuffer");
    }

    public boolean isRemoveOnStop() {
        return this.properties.getBoolean("RemoveOnStop");
    }

    public AddressFamilyRestriction getRestrictAddressFamilies() {
        Object[] array = (Object[])this.properties.getVariant("RestrictAddressFamilies").getValue();
        return new AddressFamilyRestriction(array);
    }

    public String getResult() {
        return this.properties.getString("Result");
    }

    public boolean getReusePort() {
        return this.properties.getBoolean("ReusePort");
    }

    public String getRootDirectory() {
        return this.properties.getString("RootDirectory");
    }

    public Vector<String> getRuntimeDirectory() {
        return this.properties.getVector("RuntimeDirectory");
    }

    public long getRuntimeDirectoryMode() {
        return this.properties.getLong("RuntimeDirectoryMode");
    }

    public SELinuxContext getSELinuxContext() {
        Object[] array = (Object[])this.properties.getVariant("SELinuxContext").getValue();
        return new SELinuxContext(array);
    }

    public boolean isSameProcessGroup() {
        return this.properties.getBoolean("SameProcessGroup");
    }

    public int getSecureBits() {
        return this.properties.getInteger("SecureBits");
    }

    public BigInteger getSendBuffer() {
        return this.properties.getBigInteger("SendBuffer");
    }

    public boolean isSendSIGHUP() {
        return this.properties.getBoolean("SendSIGHUP");
    }

    public boolean isSendSIGKILL() {
        return this.properties.getBoolean("SendSIGKILL");
    }

    public String getSlice() {
        return this.properties.getString("Slice");
    }

    public String getSmackLabel() {
        return this.properties.getString("SmackLabel");
    }

    public String getSmackLabelIPIn() {
        return this.properties.getString("SmackLabelIPIn");
    }

    public String getSmackLabelIPOut() {
        return this.properties.getString("SmackLabelIPOut");
    }

    public SmackProcessLabel getSmackProcessLabel() {
        Object[] array = (Object[])this.properties.getVariant("SmackProcessLabel").getValue();
        return new SmackProcessLabel(array);
    }

    public String getSocketGroup() {
        return this.properties.getString("SocketGroup");
    }

    public long getSocketMode() {
        return this.properties.getLong("SocketMode");
    }

    public int getSocketProtocol() {
        return this.properties.getInteger("SocketProtocol");
    }

    public String getSocketUser() {
        return this.properties.getString("SocketUser");
    }

    public String getStandardError() {
        return this.properties.getString("StandardError");
    }

    public String getStandardInput() {
        return this.properties.getString("StandardInput");
    }

    public String getStandardOutput() {
        return this.properties.getString("StandardOutput");
    }

    public BigInteger getStartupBlockIOWeight() {
        return this.properties.getBigInteger("StartupBlockIOWeight");
    }

    public BigInteger getStartupCPUShares() {
        return this.properties.getBigInteger("StartupCPUShares");
    }

    public Vector<String> getSupplementaryGroups() {
        return this.properties.getVector("SupplementaryGroups");
    }

    public Vector<String> getSymlinks() {
        return this.properties.getVector("Symlinks");
    }

    public int getSyslogFacility() {
        return this.properties.getInteger("SyslogFacility");
    }

    public String getSyslogIdentifier() {
        return this.properties.getString("SyslogIdentifier");
    }

    public int getSyslogLevel() {
        return this.properties.getInteger("SyslogLevel");
    }

    public boolean isSyslogLevelPrefix() {
        return this.properties.getBoolean("SyslogLevelPrefix");
    }

    public int getSyslogPriority() {
        return this.properties.getInteger("SyslogPriority");
    }

    public Vector<String> getSystemCallArchitectures() {
        return this.properties.getVector("SystemCallArchitectures");
    }

    public int getSystemCallErrorNumber() {
        return this.properties.getInteger("SystemCallErrorNumber");
    }

    public SystemCallFilter getSystemCallFilter() {
        Object[] array = (Object[])this.properties.getVariant("SystemCallFilter").getValue();
        return new SystemCallFilter(array);
    }

    public long getTriggerLimitBurst() {
        return this.properties.getLong("TriggerLimitBurst");
    }

    public BigInteger getTriggerLimitIntervalUSec() {
        return this.properties.getBigInteger("TriggerLimitIntervalUSec");
    }

    public String getTTYPath() {
        return this.properties.getString("TTYPath");
    }

    public boolean isTTYReset() {
        return this.properties.getBoolean("TTYReset");
    }

    public boolean isTTYVHangup() {
        return this.properties.getBoolean("TTYVHangup");
    }

    public boolean isTTYVTDisallocate() {
        return this.properties.getBoolean("TTYVTDisallocate");
    }

    public boolean isTasksAccounting() {
        return this.properties.getBoolean("TasksAccounting");
    }

    public BigInteger getTasksCurrent() {
        return this.properties.getBigInteger("TasksCurrent");
    }

    public BigInteger getTasksMax() {
        return this.properties.getBigInteger("TasksMax");
    }

    public BigInteger getTimeoutUSec() {
        return this.properties.getBigInteger("TimeoutUSec");
    }

    public BigInteger getTimerSlackNSec() {
        return this.properties.getBigInteger("TimerSlackNSec");
    }

    public boolean isTransparent() {
        return this.properties.getBoolean("Transparent");
    }

    public long getUMask() {
        return this.properties.getLong("UMask");
    }

    public String getUser() {
        return this.properties.getString("User");
    }

    public String getUtmpIdentifier() {
        return this.properties.getString("UtmpIdentifier");
    }

    public String getUtmpMode() {
        return this.properties.getString("UtmpMode");
    }

    public String getWorkingDirectory() {
        return this.properties.getString("WorkingDirectory");
    }

    public boolean isWritable() {
        return this.properties.getBoolean("Writable");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String ACCEPT = "Accept";
        public static final String AMBIENT_CAPABILITIES = "AmbientCapabilities";
        public static final String APP_ARMOR_PROFILE = "AppArmorProfile";
        public static final String BACKLOG = "Backlog";
        public static final String BIND_IPV6_ONLY = "BindIPv6Only";
        public static final String BIND_TO_DEVICE = "BindToDevice";
        public static final String BLOCK_IO_ACCOUNTING = "BlockIOAccounting";
        public static final String BLOCK_IO_DEVICE_WEIGHT = "BlockIODeviceWeight";
        public static final String BLOCK_IO_READ_BANDWIDTH = "BlockIOReadBandwidth";
        public static final String BLOCK_IO_WEIGHT = "BlockIOWeight";
        public static final String BLOCK_IO_WRITE_BANDWIDTH = "BlockIOWriteBandwidth";
        public static final String BROADCAST = "Broadcast";
        public static final String CPU_ACCOUNTING = "CPUAccounting";
        public static final String CPU_AFFINITY = "CPUAffinity";
        public static final String CPU_QUOTA_PER_SEC_USEC = "CPUQuotaPerSecUSec";
        public static final String CPU_SCHEDULING_POLICY = "CPUSchedulingPolicy";
        public static final String CPU_SCHEDULING_PRIORITY = "CPUSchedulingPriority";
        public static final String CPU_SCHEDULING_RESET_ON_FORK = "CPUSchedulingResetOnFork";
        public static final String CPU_SHARES = "CPUShares";
        public static final String CPU_USAGE_NSEC = "CPUUsageNSec";
        public static final String CAPABILITIES = "Capabilities";
        public static final String CAPABILITY_BOUNDING_SET = "CapabilityBoundingSet";
        public static final String CONTROL_PID = "ControlPID";
        public static final String DEFER_ACCEPT_USEC = "DeferAcceptUSec";
        public static final String DELEGATE = "Delegate";
        public static final String DEVICE_ALLOW = "DeviceAllow";
        public static final String DEVICE_POLICY = "DevicePolicy";
        public static final String DIRECTORY_MODE = "DirectoryMode";
        public static final String ENVIRONMENT = "Environment";
        public static final String ENVIRONMENT_FILES = "EnvironmentFiles";
        public static final String EXEC_START_POST = "ExecStartPost";
        public static final String EXEC_START_PRE = "ExecStartPre";
        public static final String EXEC_STOP_POST = "ExecStopPost";
        public static final String EXEC_STOP_PRE = "ExecStopPre";
        public static final String FILE_DESCRIPTOR_NAME = "FileDescriptorName";
        public static final String FREE_BIND = "FreeBind";
        public static final String GROUP = "Group";
        public static final String IO_SCHEDULING = "IOScheduling";
        public static final String IP_TOS = "IPTOS";
        public static final String IP_TTL = "IPTTL";
        public static final String IGNORE_SIGPIPE = "IgnoreSIGPIPE";
        public static final String INACCESSIBLE_DIRECTORIES = "InaccessibleDirectories";
        public static final String KEEP_ALIVE = "KeepAlive";
        public static final String KEEP_ALIVE_INTERVAL_USEC = "KeepAliveIntervalUSec";
        public static final String KEEP_ALIVE_PROBES = "KeepAliveProbes";
        public static final String KEEP_ALIVE_TIME_USEC = "KeepAliveTimeUSec";
        public static final String KILL_MODE = "KillMode";
        public static final String KILL_SIGNAL = "KillSignal";
        public static final String LIMIT_AS = "LimitAS";
        public static final String LIMIT_AS_SOFT = "LimitASSoft";
        public static final String LIMIT_CORE = "LimitCORE";
        public static final String LIMIT_CORE_SOFT = "LimitCORESoft";
        public static final String LIMIT_CPU = "LimitCPU";
        public static final String LIMIT_CPU_SOFT = "LimitCPUSoft";
        public static final String LIMIT_DATA = "LimitDATA";
        public static final String LIMIT_DATA_SOFT = "LimitDATASoft";
        public static final String LIMIT_FSIZE = "LimitFSIZE";
        public static final String LIMIT_FSIZE_SOFT = "LimitFSIZESoft";
        public static final String LIMIT_LOCKS = "LimitLOCKS";
        public static final String LIMIT_LOCKS_SOFT = "LimitLOCKSSoft";
        public static final String LIMIT_MEMLOCK = "LimitMEMLOCK";
        public static final String LIMIT_MEMLOCK_SOFT = "LimitMEMLOCKSoft";
        public static final String LIMIT_MSGQUEUE = "LimitMSGQUEUE";
        public static final String LIMIT_MSGQUEUE_SOFT = "LimitMSGQUEUESoft";
        public static final String LIMIT_NICE = "LimitNICE";
        public static final String LIMIT_NICE_SOFT = "LimitNICESoft";
        public static final String LIMIT_NOFILE = "LimitNOFILE";
        public static final String LIMIT_NOFILE_SOFT = "LimitNOFILESoft";
        public static final String LIMIT_NPROC = "LimitNPROC";
        public static final String LIMIT_NPROC_SOFT = "LimitNPROCSoft";
        public static final String LIMIT_RSS = "LimitRSS";
        public static final String LIMIT_RSS_SOFT = "LimitRSSSoft";
        public static final String LIMIT_RTPRIO = "LimitRTPRIO";
        public static final String LIMIT_RTPRIO_SOFT = "LimitRTPRIOSoft";
        public static final String LIMIT_RTTIME = "LimitRTTIME";
        public static final String LIMIT_RTTIME_SOFT = "LimitRTTIMESoft";
        public static final String LIMIT_SIGPENDING = "LimitSIGPENDING";
        public static final String LIMIT_SIGPENDING_SOFT = "LimitSIGPENDINGSoft";
        public static final String LIMIT_STACK = "LimitSTACK";
        public static final String LIMIT_STACK_SOFT = "LimitSTACKSoft";
        public static final String LISTEN = "Listen";
        public static final String MARK = "Mark";
        public static final String MAX_CONNECTIONS = "MaxConnections";
        public static final String MAX_CONNECTIONS_PER_SOURCE = "MaxConnectionsPerSource";
        public static final String MEMORY_ACCOUNTING = "MemoryAccounting";
        public static final String MEMORY_CURRENT = "MemoryCurrent";
        public static final String MEMORY_LIMIT = "MemoryLimit";
        public static final String MESSAGE_QUEUE_MAX_MESSAGES = "MessageQueueMaxMessages";
        public static final String MESSAGE_QUEUE_MESSAGE_SIZE = "MessageQueueMessageSize";
        public static final String MOUNT_FLAGS = "MountFlags";
        public static final String NACCEPTED = "NAccepted";
        public static final String NCONNECTIONS = "NConnections";
        public static final String NICE = "Nice";
        public static final String NO_DELAY = "NoDelay";
        public static final String NO_NEW_PRIVILEGES = "NoNewPrivileges";
        public static final String NON_BLOCKING = "NonBlocking";
        public static final String OOM_SCORE_ADJUST = "OOMScoreAdjust";
        public static final String PAM_NAME = "PAMName";
        public static final String PASS_CREDENTIALS = "PassCredentials";
        public static final String PASS_ENVIRONMENT = "PassEnvironment";
        public static final String PASS_SECURITY = "PassSecurity";
        public static final String PERSONALITY = "Personality";
        public static final String PIPE_SIZE = "PipeSize";
        public static final String PRIORITY = "Priority";
        public static final String PRIVATE_DEVICES = "PrivateDevices";
        public static final String PRIVATE_NETWORK = "PrivateNetwork";
        public static final String PRIVATE_TMP = "PrivateTmp";
        public static final String PROTECT_HOME = "ProtectHome";
        public static final String PROTECT_SYSTEM = "ProtectSystem";
        public static final String READ_ONLY_DIRECTORIES = "ReadOnlyDirectories";
        public static final String READ_WRITE_DIRECTORIES = "ReadWriteDirectories";
        public static final String RECEIVE_BUFFER = "ReceiveBuffer";
        public static final String REMOVE_ON_STOP = "RemoveOnStop";
        public static final String RESTRICT_ADDRESS_FAMILIES = "RestrictAddressFamilies";
        public static final String RESULT = "Result";
        public static final String REUSE_PORT = "ReusePort";
        public static final String ROOT_DIRECTORY = "RootDirectory";
        public static final String RUNTIME_DIRECTORY = "RuntimeDirectory";
        public static final String RUNTIME_DIRECTORY_MODE = "RuntimeDirectoryMode";
        public static final String SELINUX_CONTEXT = "SELinuxContext";
        public static final String SAME_PROCESS_GROUP = "SameProcessGroup";
        public static final String SECURE_BITS = "SecureBits";
        public static final String SEND_BUFFER = "SendBuffer";
        public static final String SEND_SIGHUP = "SendSIGHUP";
        public static final String SEND_SIGKILL = "SendSIGKILL";
        public static final String SLICE = "Slice";
        public static final String SMACK_LABEL = "SmackLabel";
        public static final String SMACK_LABEL_IPIN = "SmackLabelIPIn";
        public static final String SMACK_LABEL_IPOUT = "SmackLabelIPOut";
        public static final String SMACK_PROCESS_LABEL = "SmackProcessLabel";
        public static final String SOCKET_GROUP = "SocketGroup";
        public static final String SOCKET_MODE = "SocketMode";
        public static final String SOCKET_PROTOCOL = "SocketProtocol";
        public static final String SOCKET_USER = "SocketUser";
        public static final String STANDARD_ERROR = "StandardError";
        public static final String STANDARD_INPUT = "StandardInput";
        public static final String STANDARD_OUTPUT = "StandardOutput";
        public static final String STARTUP_BLOCK_IO_WEIGHT = "StartupBlockIOWeight";
        public static final String STARTUP_CPU_SHARES = "StartupCPUShares";
        public static final String SUPPLEMENTARY_GROUPS = "SupplementaryGroups";
        public static final String SYMLINKS = "Symlinks";
        public static final String SYSLOG_FACILITY = "SyslogFacility";
        public static final String SYSLOG_IDENTIFIER = "SyslogIdentifier";
        public static final String SYSLOG_LEVEL = "SyslogLevel";
        public static final String SYSLOG_LEVEL_PREFIX = "SyslogLevelPrefix";
        public static final String SYSLOG_PRIORITY = "SyslogPriority";
        public static final String SYSTEM_CALL_ARCHITECTURES = "SystemCallArchitectures";
        public static final String SYSTEM_CALL_ERROR_NUMBER = "SystemCallErrorNumber";
        public static final String SYSTEM_CALL_FILTER = "SystemCallFilter";
        public static final String TRIGGER_LIMIT_BURST = "TriggerLimitBurst";
        public static final String TRIGGER_LIMIT_INTERVAL_USEC = "TriggerLimitIntervalUSec";
        public static final String TTY_PATH = "TTYPath";
        public static final String TTY_RESET = "TTYReset";
        public static final String TTY_V_HANGUP = "TTYVHangup";
        public static final String TTY_VT_DISALLOCATE = "TTYVTDisallocate";
        public static final String TASKS_ACCOUNTING = "TasksAccounting";
        public static final String TASKS_CURRENT = "TasksCurrent";
        public static final String TASKS_MAX = "TasksMax";
        public static final String TIMEOUT_USEC = "TimeoutUSec";
        public static final String TIMER_SLACK_NSEC = "TimerSlackNSec";
        public static final String TRANSPARENT = "Transparent";
        public static final String UMASK = "UMask";
        public static final String USER = "User";
        public static final String UTMP_IDENTIFIER = "UtmpIdentifier";
        public static final String UTMP_MODE = "UtmpMode";
        public static final String WORKING_DIRECTORY = "WorkingDirectory";
        public static final String WRITABLE = "Writable";

        private Property() {
        }

        public static final String[] getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }
}

