/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.InterfaceAdapter;
import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Properties;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.Unit;
import de.thjom.java.systemd.interfaces.SwapInterface;
import de.thjom.java.systemd.types.DeviceAllowControl;
import de.thjom.java.systemd.types.EnvironmentFile;
import de.thjom.java.systemd.types.ExecutionInfo;
import de.thjom.java.systemd.types.IOBandwidth;
import de.thjom.java.systemd.types.IODeviceWeight;
import de.thjom.java.systemd.types.IOIops;
import de.thjom.java.systemd.types.SystemCallFilter;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import org.freedesktop.dbus.exceptions.DBusException;

public class Swap
extends Unit {
    public static final String SERVICE_NAME = "org.freedesktop.systemd1.Swap";
    public static final String UNIT_SUFFIX = ".swap";

    private Swap(Manager manager, SwapInterface iface, String name) throws DBusException {
        super(manager, iface, name);
        this.properties = Properties.create(this.dbus, iface.getObjectPath(), SERVICE_NAME);
    }

    static Swap create(Manager manager, String name) throws DBusException {
        name = Unit.normalizeName(name, UNIT_SUFFIX);
        String objectPath = "/org/freedesktop/systemd1/unit/" + Systemd.escapePath(name);
        SwapInterface iface = (SwapInterface)manager.dbus.getRemoteObject("org.freedesktop.systemd1", objectPath, SwapInterface.class);
        return new Swap(manager, iface, name);
    }

    @Override
    public SwapInterface getInterface() {
        return (SwapInterface)super.getInterface();
    }

    public boolean isBlockIOAccounting() {
        return this.properties.getBoolean("BlockIOAccounting");
    }

    public List<IODeviceWeight> getBlockIODeviceWeight() {
        return IODeviceWeight.list(this.properties.getVector("BlockIODeviceWeight"));
    }

    public List<IOBandwidth> getBlockIOReadBandwidth() {
        return IOBandwidth.list(this.properties.getVector("BlockIOReadBandwidth"));
    }

    public BigInteger getBlockIOWeight() {
        return this.properties.getBigInteger("BlockIOWeight");
    }

    public List<IOBandwidth> getBlockIOWriteBandwidth() {
        return IOBandwidth.list(this.properties.getVector("BlockIOWriteBandwidth"));
    }

    public boolean isCPUAccounting() {
        return this.properties.getBoolean("CPUAccounting");
    }

    public byte[] getCPUAffinity() {
        return (byte[])this.properties.getVariant("CPUAffinity").getValue();
    }

    public int getCPUSchedulingPolicy() {
        return this.properties.getInteger("CPUSchedulingPolicy");
    }

    public int getCPUSchedulingPriority() {
        return this.properties.getInteger("CPUSchedulingPriority");
    }

    public boolean isCPUSchedulingResetOnFork() {
        return this.properties.getBoolean("CPUSchedulingResetOnFork");
    }

    public BigInteger getCPUShares() {
        return this.properties.getBigInteger("CPUShares");
    }

    public BigInteger getCPUWeight() {
        return this.properties.getBigInteger("CPUWeight");
    }

    public String getCapabilities() {
        return this.properties.getString("Capabilities");
    }

    public BigInteger getCapabilityBoundingSet() {
        return this.properties.getBigInteger("CapabilityBoundingSet");
    }

    public String getControlGroup() {
        return this.properties.getString("ControlGroup");
    }

    public long getControlPID() {
        return this.properties.getLong("ControlPID");
    }

    public List<DeviceAllowControl> getDeviceAllow() {
        return DeviceAllowControl.list(this.properties.getVector("DeviceAllow"));
    }

    public String getDevicePolicy() {
        return this.properties.getString("DevicePolicy");
    }

    public boolean isDynamicUser() {
        return this.properties.getBoolean("DynamicUser");
    }

    public Vector<String> getEnvironment() {
        return this.properties.getVector("Environment");
    }

    public List<EnvironmentFile> getEnvironmentFiles() {
        return EnvironmentFile.list(this.properties.getVector("EnvironmentFiles"));
    }

    public List<ExecutionInfo> getExecActivate() {
        return ExecutionInfo.list(this.properties.getVector("ExecActivate"));
    }

    public List<ExecutionInfo> getExecDeactivate() {
        return ExecutionInfo.list(this.properties.getVector("ExecDeactivate"));
    }

    public int getGID() {
        return this.properties.getInteger("GID");
    }

    public String getGroup() {
        return this.properties.getString("Group");
    }

    public boolean isIgnoreSIGPIPE() {
        return this.properties.getBoolean("IgnoreSIGPIPE");
    }

    public Vector<String> getInaccessibleDirectories() {
        return this.properties.getVector("InaccessibleDirectories");
    }

    public Vector<String> getInaccessiblePaths() {
        return this.properties.getVector("InaccessiblePaths");
    }

    public boolean isIOAccounting() {
        return this.properties.getBoolean("IOAccounting");
    }

    public List<IODeviceWeight> getIODeviceWeight() {
        return IODeviceWeight.list(this.properties.getVector("IODeviceWeight"));
    }

    public List<IOBandwidth> getIOReadBandwidthMax() {
        return IOBandwidth.list(this.properties.getVector("IOReadBandwidthMax"));
    }

    public List<IOIops> getIOReadIOPSMax() {
        return IOIops.list(this.properties.getVector("IOReadIOPSMax"));
    }

    public int getIOScheduling() {
        return this.properties.getInteger("IOScheduling");
    }

    public BigInteger getIOWeight() {
        return this.properties.getBigInteger("IOWeight");
    }

    public List<IOBandwidth> getIOWriteBandwidthMax() {
        return IOBandwidth.list(this.properties.getVector("IOWriteBandwidthMax"));
    }

    public List<IOIops> getIOWriteIOPSMax() {
        return IOIops.list(this.properties.getVector("IOWriteIOPSMax"));
    }

    public String getKillMode() {
        return this.properties.getString("KillMode");
    }

    public int getKillSignal() {
        return this.properties.getInteger("KillSignal");
    }

    public BigInteger getLimitAS() {
        return this.properties.getBigInteger("LimitAS");
    }

    public BigInteger getLimitCORE() {
        return this.properties.getBigInteger("LimitCORE");
    }

    public BigInteger getLimitCPU() {
        return this.properties.getBigInteger("LimitCPU");
    }

    public BigInteger getLimitDATA() {
        return this.properties.getBigInteger("LimitDATA");
    }

    public BigInteger getLimitFSIZE() {
        return this.properties.getBigInteger("LimitFSIZE");
    }

    public BigInteger getLimitLOCKS() {
        return this.properties.getBigInteger("LimitLOCKS");
    }

    public BigInteger getLimitMEMLOCK() {
        return this.properties.getBigInteger("LimitMEMLOCK");
    }

    public BigInteger getLimitMSGQUEUE() {
        return this.properties.getBigInteger("LimitMSGQUEUE");
    }

    public BigInteger getLimitNICE() {
        return this.properties.getBigInteger("LimitNICE");
    }

    public BigInteger getLimitNOFILE() {
        return this.properties.getBigInteger("LimitNOFILE");
    }

    public BigInteger getLimitNPROC() {
        return this.properties.getBigInteger("LimitNPROC");
    }

    public BigInteger getLimitRSS() {
        return this.properties.getBigInteger("LimitRSS");
    }

    public BigInteger getLimitRTPRIO() {
        return this.properties.getBigInteger("LimitRTPRIO");
    }

    public BigInteger getLimitRTTIME() {
        return this.properties.getBigInteger("LimitRTTIME");
    }

    public BigInteger getLimitSIGPENDING() {
        return this.properties.getBigInteger("LimitSIGPENDING");
    }

    public BigInteger getLimitSTACK() {
        return this.properties.getBigInteger("LimitSTACK");
    }

    public boolean isMemoryAccounting() {
        return this.properties.getBoolean("MemoryAccounting");
    }

    public boolean isMemoryDenyWriteExecute() {
        return this.properties.getBoolean("MemoryDenyWriteExecute");
    }

    public BigInteger getMemoryHigh() {
        return this.properties.getBigInteger("MemoryHigh");
    }

    public BigInteger getMemoryLimit() {
        return this.properties.getBigInteger("MemoryLimit");
    }

    public BigInteger getMemoryLow() {
        return this.properties.getBigInteger("MemoryLow");
    }

    public BigInteger getMemoryMax() {
        return this.properties.getBigInteger("MemoryMax");
    }

    public BigInteger getMemorySwapMax() {
        return this.properties.getBigInteger("MemorySwapMax");
    }

    public BigInteger getMountFlags() {
        return this.properties.getBigInteger("MountFlags");
    }

    public int getNice() {
        return this.properties.getInteger("Nice");
    }

    public boolean isNoNewPrivileges() {
        return this.properties.getBoolean("NoNewPrivileges");
    }

    public boolean isNonBlocking() {
        return this.properties.getBoolean("NonBlocking");
    }

    public int getOOMScoreAdjust() {
        return this.properties.getInteger("OOMScoreAdjust");
    }

    public String getPAMName() {
        return this.properties.getString("PAMName");
    }

    public int getPriority() {
        return this.properties.getInteger("Priority");
    }

    public boolean isPrivateNetwork() {
        return this.properties.getBoolean("PrivateNetwork");
    }

    public boolean isPrivateTmp() {
        return this.properties.getBoolean("PrivateTmp");
    }

    public boolean isPrivateUsers() {
        return this.properties.getBoolean("PrivateUsers");
    }

    public boolean isProtectControlGroups() {
        return this.properties.getBoolean("ProtectControlGroups");
    }

    public boolean isProtectKernelModules() {
        return this.properties.getBoolean("ProtectKernelModules");
    }

    public boolean isProtectKernelTunables() {
        return this.properties.getBoolean("ProtectKernelTunables");
    }

    public Vector<String> getReadOnlyDirectories() {
        return this.properties.getVector("ReadOnlyDirectories");
    }

    public Vector<String> getReadOnlyPaths() {
        return this.properties.getVector("ReadOnlyPaths");
    }

    public Vector<String> getReadWriteDirectories() {
        return this.properties.getVector("ReadWriteDirectories");
    }

    public Vector<String> getReadWritePaths() {
        return this.properties.getVector("ReadWritePaths");
    }

    public boolean isRemoveIPC() {
        return this.properties.getBoolean("RemoveIPC");
    }

    public boolean isRestrictRealtime() {
        return this.properties.getBoolean("RestrictRealtime");
    }

    public String getResult() {
        return this.properties.getString("Result");
    }

    public String getRootDirectory() {
        return this.properties.getString("RootDirectory");
    }

    public boolean isSameProcessGroup() {
        return this.properties.getBoolean("SameProcessGroup");
    }

    public int getSecureBits() {
        return this.properties.getInteger("SecureBits");
    }

    public boolean isSendSIGHUP() {
        return this.properties.getBoolean("SendSIGHUP");
    }

    public boolean isSendSIGKILL() {
        return this.properties.getBoolean("SendSIGKILL");
    }

    public String getSlice() {
        return this.properties.getString("Slice");
    }

    public String getStandardError() {
        return this.properties.getString("StandardError");
    }

    public String getStandardErrorFileDescriptorName() {
        return this.properties.getString("StandardErrorFileDescriptorName");
    }

    public String getStandardInput() {
        return this.properties.getString("StandardInput");
    }

    public String getStandardInputFileDescriptorName() {
        return this.properties.getString("StandardInputFileDescriptorName");
    }

    public String getStandardOutput() {
        return this.properties.getString("StandardOutput");
    }

    public String getStandardOutputFileDescriptorName() {
        return this.properties.getString("StandardOutputFileDescriptorName");
    }

    public BigInteger getStartupCPUWeight() {
        return this.properties.getBigInteger("StartupCPUWeight");
    }

    public BigInteger getStartupIOWeight() {
        return this.properties.getBigInteger("StartupIOWeight");
    }

    public Vector<String> getSupplementaryGroups() {
        return this.properties.getVector("SupplementaryGroups");
    }

    public String getSyslogIdentifier() {
        return this.properties.getString("SyslogIdentifier");
    }

    public boolean isSyslogLevelPrefix() {
        return this.properties.getBoolean("SyslogLevelPrefix");
    }

    public int getSyslogPriority() {
        return this.properties.getInteger("SyslogPriority");
    }

    public SystemCallFilter getSystemCallFilter() {
        Object[] array = (Object[])this.properties.getVariant("SystemCallFilter").getValue();
        return new SystemCallFilter(array);
    }

    public String getTCPWrapName() {
        return this.properties.getString("TCPWrapName");
    }

    public String getTTYPath() {
        return this.properties.getString("TTYPath");
    }

    public boolean isTTYReset() {
        return this.properties.getBoolean("TTYReset");
    }

    public boolean isTTYVHangup() {
        return this.properties.getBoolean("TTYVHangup");
    }

    public boolean isTTYVTDisallocate() {
        return this.properties.getBoolean("TTYVTDisallocate");
    }

    public BigInteger getTimeoutUSec() {
        return this.properties.getBigInteger("TimeoutUSec");
    }

    public long getTimerSlackNS() {
        return this.properties.getLong("TimerSlackNS");
    }

    public int getUID() {
        return this.properties.getInteger("UID");
    }

    public long getUMask() {
        return this.properties.getLong("UMask");
    }

    public String getUser() {
        return this.properties.getString("User");
    }

    public String getUtmpIdentifier() {
        return this.properties.getString("UtmpIdentifier");
    }

    public String getWhat() {
        return this.properties.getString("What");
    }

    public String getWorkingDirectory() {
        return this.properties.getString("WorkingDirectory");
    }

    public static class Property
    extends InterfaceAdapter.AdapterProperty {
        public static final String BLOCK_IO_ACCOUNTING = "BlockIOAccounting";
        public static final String BLOCK_IO_DEVICE_WEIGHT = "BlockIODeviceWeight";
        public static final String BLOCK_IO_READ_BANDWIDTH = "BlockIOReadBandwidth";
        public static final String BLOCK_IO_WEIGHT = "BlockIOWeight";
        public static final String BLOCK_IO_WRITE_BANDWIDTH = "BlockIOWriteBandwidth";
        public static final String CAPABILITIES = "Capabilities";
        public static final String CAPABILITY_BOUNDING_SET = "CapabilityBoundingSet";
        public static final String CONTROL_GROUP = "ControlGroup";
        public static final String CONTROL_PID = "ControlPID";
        public static final String CPU_ACCOUNTING = "CPUAccounting";
        public static final String CPU_AFFINITY = "CPUAffinity";
        public static final String CPU_SCHEDULING_POLICY = "CPUSchedulingPolicy";
        public static final String CPU_SCHEDULING_PRIORITY = "CPUSchedulingPriority";
        public static final String CPU_SCHEDULING_RESET_ON_FORK = "CPUSchedulingResetOnFork";
        public static final String CPU_SHARES = "CPUShares";
        public static final String CPU_WEIGHT = "CPUWeight";
        public static final String DEVICE_ALLOW = "DeviceAllow";
        public static final String DEVICE_POLICY = "DevicePolicy";
        public static final String DYNAMIC_USER = "DynamicUser";
        public static final String ENVIRONMENT = "Environment";
        public static final String ENVIRONMENT_FILES = "EnvironmentFiles";
        public static final String EXEC_ACTIVATE = "ExecActivate";
        public static final String EXEC_DEACTIVATE = "ExecDeactivate";
        public static final String GID = "GID";
        public static final String GROUP = "Group";
        public static final String IGNORE_SIGPIPE = "IgnoreSIGPIPE";
        public static final String INACCESSIBLE_DIRECTORIES = "InaccessibleDirectories";
        public static final String INACCESSIBLE_PATHS = "InaccessiblePaths";
        public static final String IO_ACCOUNTING = "IOAccounting";
        public static final String IO_DEVICE_WEIGHT = "IODeviceWeight";
        public static final String IO_READ_BANDWIDTH_MAX = "IOReadBandwidthMax";
        public static final String IO_READ_IOPS_MAX = "IOReadIOPSMax";
        public static final String IO_SCHEDULING = "IOScheduling";
        public static final String IO_WEIGHT = "IOWeight";
        public static final String IO_WRITE_BANDWIDTH_MAX = "IOWriteBandwidthMax";
        public static final String IO_WRITE_IOPS_MAX = "IOWriteIOPSMax";
        public static final String KILL_MODE = "KillMode";
        public static final String KILL_SIGNAL = "KillSignal";
        public static final String LIMIT_AS = "LimitAS";
        public static final String LIMIT_CORE = "LimitCORE";
        public static final String LIMIT_CPU = "LimitCPU";
        public static final String LIMIT_DATA = "LimitDATA";
        public static final String LIMIT_FSIZE = "LimitFSIZE";
        public static final String LIMIT_LOCKS = "LimitLOCKS";
        public static final String LIMIT_MEMLOCK = "LimitMEMLOCK";
        public static final String LIMIT_MSGQUEUE = "LimitMSGQUEUE";
        public static final String LIMIT_NICE = "LimitNICE";
        public static final String LIMIT_NOFILE = "LimitNOFILE";
        public static final String LIMIT_NPROC = "LimitNPROC";
        public static final String LIMIT_RSS = "LimitRSS";
        public static final String LIMIT_RTPRIO = "LimitRTPRIO";
        public static final String LIMIT_RTTIME = "LimitRTTIME";
        public static final String LIMIT_SIGPENDING = "LimitSIGPENDING";
        public static final String LIMIT_STACK = "LimitSTACK";
        public static final String MEMORY_ACCOUNTING = "MemoryAccounting";
        public static final String MEMORY_DENY_WRITE_EXECUTE = "MemoryDenyWriteExecute";
        public static final String MEMORY_HIGH = "MemoryHigh";
        public static final String MEMORY_LIMIT = "MemoryLimit";
        public static final String MEMORY_LOW = "MemoryLow";
        public static final String MEMORY_MAX = "MemoryMax";
        public static final String MEMORY_SWAP_MAX = "MemorySwapMax";
        public static final String MOUNT_FLAGS = "MountFlags";
        public static final String NICE = "Nice";
        public static final String NON_BLOCKING = "NonBlocking";
        public static final String NO_NEW_PRIVILEGES = "NoNewPrivileges";
        public static final String OOM_SCORE_ADJUST = "OOMScoreAdjust";
        public static final String PAM_NAME = "PAMName";
        public static final String PRIORITY = "Priority";
        public static final String PRIVATE_NETWORK = "PrivateNetwork";
        public static final String PRIVATE_TMP = "PrivateTmp";
        public static final String PRIVATE_USERS = "PrivateUsers";
        public static final String PROTECT_CONTROL_GROUPS = "ProtectControlGroups";
        public static final String PROTECT_KERNEL_MODULES = "ProtectKernelModules";
        public static final String PROTECT_KERNEL_TUNABLES = "ProtectKernelTunables";
        public static final String READ_ONLY_DIRECTORIES = "ReadOnlyDirectories";
        public static final String READ_ONLY_PATHS = "ReadOnlyPaths";
        public static final String READ_WRITE_DIRECTORIES = "ReadWriteDirectories";
        public static final String READ_WRITE_PATHS = "ReadWritePaths";
        public static final String REMOVE_IPC = "RemoveIPC";
        public static final String RESTRICT_REALTIME = "RestrictRealtime";
        public static final String RESULT = "Result";
        public static final String ROOT_DIRECTORY = "RootDirectory";
        public static final String SAME_PROCESS_GROUP = "SameProcessGroup";
        public static final String SECURE_BITS = "SecureBits";
        public static final String SEND_SIGHUP = "SendSIGHUP";
        public static final String SEND_SIGKILL = "SendSIGKILL";
        public static final String SLICE = "Slice";
        public static final String STANDARD_ERROR = "StandardError";
        public static final String STANDARD_ERROR_FILE_DESCRIPTOR_NAME = "StandardErrorFileDescriptorName";
        public static final String STANDARD_INPUT = "StandardInput";
        public static final String STANDARD_INPUT_FILE_DESCRIPTOR_NAME = "StandardInputFileDescriptorName";
        public static final String STANDARD_OUTPUT = "StandardOutput";
        public static final String STANDARD_OUTPUT_FILE_DESCRIPTOR_NAME = "StandardOutputFileDescriptorName";
        public static final String STARTUP_CPU_WEIGHT = "StartupCPUWeight";
        public static final String STARTUP_IO_WEIGHT = "StartupIOWeight";
        public static final String SUPPLEMENTARY_GROUPS = "SupplementaryGroups";
        public static final String SYSLOG_IDENTIFIER = "SyslogIdentifier";
        public static final String SYSLOG_LEVEL_PREFIX = "SyslogLevelPrefix";
        public static final String SYSLOG_PRIORITY = "SyslogPriority";
        public static final String SYSTEM_CALL_FILTER = "SystemCallFilter";
        public static final String TCP_WRAP_NAME = "TCPWrapName";
        public static final String TIMEOUT_USEC = "TimeoutUSec";
        public static final String TIMER_SLACK_NS = "TimerSlackNS";
        public static final String TTY_PATH = "TTYPath";
        public static final String TTY_RESET = "TTYReset";
        public static final String TTY_V_HANGUP = "TTYVHangup";
        public static final String TTY_VT_DISALLOCATE = "TTYVTDisallocate";
        public static final String UID = "UID";
        public static final String UMASK = "UMask";
        public static final String USER = "User";
        public static final String UTMP_IDENTIFIER = "UtmpIdentifier";
        public static final String WHAT = "What";
        public static final String WORKING_DIRECTORY = "WorkingDirectory";

        private Property() {
        }

        public static final String[] getAllNames() {
            return Property.getAllNames(Property.class);
        }
    }
}

