/*
 * Decompiled with CFR 0.152.
 */
package de.thjom.java.systemd;

import de.thjom.java.systemd.Manager;
import de.thjom.java.systemd.Systemd;
import de.thjom.java.systemd.UnitMonitor;
import de.thjom.java.systemd.types.UnitType;
import java.util.EnumSet;
import org.freedesktop.dbus.exceptions.DBusException;

public class UnitTypeMonitor
extends UnitMonitor {
    protected final EnumSet<MonitoredType> monitoredTypes = EnumSet.noneOf(MonitoredType.class);

    public UnitTypeMonitor(Manager manager) {
        super(manager);
    }

    protected boolean isIncluded(UnitType unit) {
        boolean monitored = false;
        for (MonitoredType type : this.monitoredTypes) {
            switch (type) {
                case AUTOMOUNT: {
                    monitored = unit.isAutomount();
                    break;
                }
                case BUSNAME: {
                    monitored = unit.isBusName();
                    break;
                }
                case DEVICE: {
                    monitored = unit.isDevice();
                    break;
                }
                case MOUNT: {
                    monitored = unit.isMount();
                    break;
                }
                case PATH: {
                    monitored = unit.isPath();
                    break;
                }
                case SCOPE: {
                    monitored = unit.isScope();
                    break;
                }
                case SERVICE: {
                    monitored = unit.isService();
                    break;
                }
                case SLICE: {
                    monitored = unit.isSlice();
                    break;
                }
                case SNAPSHOT: {
                    monitored = unit.isSnapshot();
                    break;
                }
                case SOCKET: {
                    monitored = unit.isSocket();
                    break;
                }
                case SWAP: {
                    monitored = unit.isSwap();
                    break;
                }
                case TARGET: {
                    monitored = unit.isTarget();
                    break;
                }
                case TIMER: {
                    monitored = unit.isTimer();
                    break;
                }
                default: {
                    monitored = false;
                }
            }
            if (!monitored) continue;
            break;
        }
        return monitored;
    }

    @Override
    public synchronized void reset() {
        this.monitoredTypes.clear();
        this.monitoredUnits.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void refresh() throws DBusException {
        try {
            this.monitoredUnits.clear();
            for (UnitType unit : this.manager.listUnits()) {
                if (!this.isIncluded(unit)) continue;
                String name = unit.getUnitName();
                this.monitoredUnits.put(Systemd.escapePath(name), this.manager.getUnit(name));
            }
        }
        finally {
            this.unitMonitorListeners.forEach(l -> l.monitorRefreshed(this.monitoredUnits.values()));
        }
    }

    public final void addMonitoredTypes(MonitoredType ... monitoredTypes) throws DBusException {
        for (MonitoredType monitoredType : monitoredTypes) {
            this.monitoredTypes.add(monitoredType);
        }
        this.refresh();
    }

    public final void removeMonitoredTypes(MonitoredType ... monitoredTypes) throws DBusException {
        for (MonitoredType monitoredType : monitoredTypes) {
            this.monitoredTypes.remove((Object)monitoredType);
        }
        this.refresh();
    }

    @Override
    public boolean monitorsUnit(String unitName) {
        boolean monitored = super.monitorsUnit(unitName);
        if (!monitored) {
            String dot = Systemd.escapePath(".");
            for (MonitoredType monitoredType : this.monitoredTypes) {
                if (!unitName.endsWith(dot + monitoredType.name().toLowerCase())) continue;
                monitored = true;
                break;
            }
        }
        return monitored;
    }

    public static enum MonitoredType {
        AUTOMOUNT,
        BUSNAME,
        DEVICE,
        MOUNT,
        PATH,
        SCOPE,
        SERVICE,
        SLICE,
        SNAPSHOT,
        SOCKET,
        SWAP,
        TARGET,
        TIMER;

    }
}

