/*
 * Decompiled with CFR 0.152.
 */
package com.github.tianjing.tgtools.flowable.db.dm.database;

import liquibase.CatalogAndSchema;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.DatabaseException;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawCallStatement;
import liquibase.structure.core.Schema;

public class DmDatabase
extends OracleDatabase {
    public String getShortName() {
        return "dm";
    }

    protected String getDefaultDatabaseProductName() {
        return "DM DBMS";
    }

    public Integer getDefaultPort() {
        return 5236;
    }

    public String getJdbcCatalogName(CatalogAndSchema schema) {
        return null;
    }

    public String getJdbcSchemaName(CatalogAndSchema schema) {
        return this.correctObjectName(schema.getCatalogName() == null ? schema.getSchemaName() : schema.getCatalogName(), Schema.class);
    }

    protected String getConnectionCatalogName() throws DatabaseException {
        return super.getConnectionCatalogName();
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return "DM DBMS".equalsIgnoreCase(conn.getDatabaseProductName());
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:dm")) {
            return "dm.jdbc.driver.DmDriver";
        }
        return null;
    }

    protected SqlStatement getConnectionSchemaNameCallStatement() {
        return new RawCallStatement("select user");
    }
}

