/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.DB2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MariaDBDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.snapshot.ResultSetCache;
import liquibase.snapshot.SnapshotControl;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.JdbcUtils;

public class DmJdbcDatabaseSnapshot
extends JdbcDatabaseSnapshot {
    private boolean warnedAboutDbaRecycleBin;
    private static final boolean ignoreWarnAboutDbaRecycleBin = Boolean.getBoolean("liquibase.ignoreRecycleBinWarning");
    private JdbcDatabaseSnapshot.CachingDatabaseMetaData cachingDatabaseMetaData;
    private Set<String> userDefinedTypes;

    public DmJdbcDatabaseSnapshot(DatabaseObject[] examples, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        super(examples, database, snapshotControl);
    }

    public DmJdbcDatabaseSnapshot(DatabaseObject[] examples, Database database) throws DatabaseException, InvalidExampleException {
        super(examples, database);
    }

    public JdbcDatabaseSnapshot.CachingDatabaseMetaData getMetaDataFromCache() throws SQLException {
        if (this.cachingDatabaseMetaData == null) {
            DatabaseMetaData databaseMetaData = null;
            if (this.getDatabase().getConnection() != null) {
                databaseMetaData = ((JdbcConnection)this.getDatabase().getConnection()).getUnderlyingConnection().getMetaData();
            }
            this.cachingDatabaseMetaData = new DmCachingDatabaseMetaData(this.getDatabase(), databaseMetaData);
        }
        return this.cachingDatabaseMetaData;
    }

    private String getAllCatalogsStringScratchData() {
        return (String)this.getScratchData("DatabaseSnapshot.allCatalogsString");
    }

    public class DmCachingDatabaseMetaData
    extends JdbcDatabaseSnapshot.CachingDatabaseMetaData {
        private static final String ASANY_NO_FOREIGN_KEYS_FOUND_SQLSTATE = "WW012";
        private static final String SQL_FILTER_MATCH_ALL = "%";
        private DatabaseMetaData databaseMetaData;
        private Database database;

        public DmCachingDatabaseMetaData(Database database, DatabaseMetaData metaData) {
            super((JdbcDatabaseSnapshot)DmJdbcDatabaseSnapshot.this, database, metaData);
            this.databaseMetaData = metaData;
            this.database = database;
        }

        public DatabaseMetaData getDatabaseMetaData() {
            return this.databaseMetaData;
        }

        public List<CachedRow> getForeignKeys(final String catalogName, final String schemaName, final String tableName, final String fkName) throws DatabaseException {
            return DmJdbcDatabaseSnapshot.this.getResultSetCache("getImportedKeys").get((ResultSetCache.ResultSetExtractor)new ResultSetCache.UnionResultSetExtractor(this.database){

                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("FKTABLE_CAT"), row.getString("FKTABLE_SCHEM"), DmCachingDatabaseMetaData.this.database, new String[]{row.getString("FKTABLE_NAME"), row.getString("FK_NAME")});
                }

                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, DmCachingDatabaseMetaData.this.database, new String[]{tableName, fkName});
                }

                public boolean bulkContainsSchema(String schemaKey) {
                    return DmCachingDatabaseMetaData.this.database instanceof OracleDatabase;
                }

                public String getSchemaKey(CachedRow row) {
                    return row.getString("FKTABLE_SCHEM");
                }

                public List<CachedRow> fastFetch() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                    ArrayList<CachedRow> returnList = new ArrayList<CachedRow>();
                    ArrayList<String> tables = new ArrayList<String>();
                    String jdbcCatalogName = ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema);
                    String jdbcSchemaName = ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                    if (DmCachingDatabaseMetaData.this.database instanceof DB2Database) {
                        return this.executeAndExtract(this.getDB2Sql(jdbcSchemaName, tableName), DmCachingDatabaseMetaData.this.database);
                    }
                    if (DmCachingDatabaseMetaData.this.database instanceof Db2zDatabase) {
                        return this.executeAndExtract(this.getDB2ZOSSql(jdbcSchemaName, tableName), DmCachingDatabaseMetaData.this.database);
                    }
                    if (tableName == null) {
                        for (CachedRow row : DmCachingDatabaseMetaData.this.getTables(jdbcCatalogName, jdbcSchemaName, null)) {
                            tables.add(row.getString("TABLE_NAME"));
                        }
                    } else {
                        tables.add(tableName);
                    }
                    for (String foundTable : tables) {
                        if (DmCachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                            throw new RuntimeException("Should have bulk selected");
                        }
                        ResultSet metaData = null;
                        try {
                            metaData = DmCachingDatabaseMetaData.this.databaseMetaData.getImportedKeys(jdbcCatalogName, jdbcSchemaName, foundTable);
                            returnList.addAll(this.extract(metaData));
                        }
                        catch (SQLException e) {
                            if (DmCachingDatabaseMetaData.this.database instanceof SybaseASADatabase && e.getSQLState().equalsIgnoreCase(DmCachingDatabaseMetaData.ASANY_NO_FOREIGN_KEYS_FOUND_SQLSTATE)) {
                                LogService.getLog(((Object)((Object)this)).getClass()).debug(LogType.LOG, String.format("Ignored SAP SQL Anywhere SQL exception thrown when FOREIGN KEY list of table '%s' was empty.", foundTable));
                                continue;
                            }
                            throw e;
                        }
                    }
                    return returnList;
                }

                public List<CachedRow> bulkFetch() throws SQLException, DatabaseException {
                    if (DmCachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                        String jdbcSchemaName = ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                        String sql = "SELECT  /*+rule*/  NULL AS pktable_cat,    p.owner as pktable_schem,    p.table_name as pktable_name,    pc.column_name as pkcolumn_name,    NULL as fktable_cat,    f.owner as fktable_schem,    f.table_name as fktable_name,    fc.column_name as fkcolumn_name,    fc.position as key_seq,    NULL as update_rule,    decode (f.delete_rule, 'CASCADE', 0, 'SET NULL', 2, 1) as delete_rule,    f.constraint_name as fk_name,    p.constraint_name as pk_name,    decode(f.deferrable, 'DEFERRABLE', 5, 'NOT DEFERRABLE', 7, 'DEFERRED', 6) deferrability,    f.validated as fk_validate FROM all_cons_columns pc INNER JOIN all_constraints p ON pc.owner = p.owner AND pc.constraint_name = p.constraint_name INNER JOIN all_constraints f ON pc.owner = f.r_owner AND pc.constraint_name = f.r_constraint_name INNER JOIN all_cons_columns fc ON fc.owner = f.owner AND fc.constraint_name = f.constraint_name AND fc.position = pc.position ";
                        sql = DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() == null ? sql + "WHERE f.owner = '" + jdbcSchemaName + "' " : sql + "WHERE f.owner IN ('" + jdbcSchemaName + "', " + DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() + ") ";
                        sql = sql + "AND p.constraint_type in ('P', 'U') AND f.constraint_type = 'R' AND p.table_name NOT LIKE 'BIN$%' ORDER BY fktable_schem, fktable_name, key_seq";
                        return this.executeAndExtract(sql, DmCachingDatabaseMetaData.this.database);
                    }
                    if (DmCachingDatabaseMetaData.this.database instanceof DB2Database) {
                        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                        String jdbcSchemaName = ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                        return this.executeAndExtract(this.getDB2Sql(jdbcSchemaName, null), DmCachingDatabaseMetaData.this.database);
                    }
                    if (DmCachingDatabaseMetaData.this.database instanceof Db2zDatabase) {
                        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                        String jdbcSchemaName = ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                        return this.executeAndExtract(this.getDB2ZOSSql(jdbcSchemaName, null), DmCachingDatabaseMetaData.this.database);
                    }
                    if (DmCachingDatabaseMetaData.this.database instanceof MSSQLDatabase) {
                        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                        String jdbcSchemaName = ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                        String sql = this.getMSSQLSql(jdbcSchemaName);
                        return this.executeAndExtract(sql, DmCachingDatabaseMetaData.this.database);
                    }
                    throw new RuntimeException("Cannot bulk select");
                }

                protected String getMSSQLSql(String jdbcSchemaName) {
                    return "select convert(sysname,db_name()) AS PKTABLE_CAT, convert(sysname,schema_name(o1.schema_id)) AS PKTABLE_SCHEM, convert(sysname,o1.name) AS PKTABLE_NAME, convert(sysname,c1.name) AS PKCOLUMN_NAME, convert(sysname,db_name()) AS FKTABLE_CAT, convert(sysname,schema_name(o2.schema_id)) AS FKTABLE_SCHEM, convert(sysname,o2.name) AS FKTABLE_NAME, convert(sysname,c2.name) AS FKCOLUMN_NAME, isnull(convert(smallint,k.constraint_column_id), convert(smallint,0)) AS KEY_SEQ, convert(smallint, case ObjectProperty(f.object_id, 'CnstIsUpdateCascade') when 1 then 0 else 1 end) AS UPDATE_RULE, convert(smallint, case ObjectProperty(f.object_id, 'CnstIsDeleteCascade') when 1 then 0 else 1 end) AS DELETE_RULE, convert(sysname,object_name(f.object_id)) AS FK_NAME, convert(sysname,i.name) AS PK_NAME, convert(smallint, 7) AS DEFERRABILITY from sys.objects o1, sys.objects o2, sys.columns c1, sys.columns c2, sys.foreign_keys f inner join sys.foreign_key_columns k on (k.constraint_object_id = f.object_id) inner join sys.indexes i on (f.referenced_object_id = i.object_id and f.key_index_id = i.index_id) where o1.object_id = f.referenced_object_id and o2.object_id = f.parent_object_id and c1.object_id = f.referenced_object_id and c2.object_id = f.parent_object_id and c1.column_id = k.referenced_column_id and c2.column_id = k.parent_column_id and object_schema_name(o1.object_id)='" + jdbcSchemaName + "' order by 5, 6, 7, 9, 8";
                }

                protected String getDB2Sql(String jdbcSchemaName, String tableName2) {
                    return "SELECT    pk_col.tabschema AS pktable_cat,    pk_col.tabname as pktable_name,    pk_col.colname as pkcolumn_name,   fk_col.tabschema as fktable_cat,    fk_col.tabname as fktable_name,    fk_col.colname as fkcolumn_name,   fk_col.colseq as key_seq,    decode (ref.updaterule, 'A', 3, 'R', 1, 1) as update_rule,    decode (ref.deleterule, 'A', 3, 'C', 0, 'N', 2, 'R', 1, 1) as delete_rule,    ref.constname as fk_name,    ref.refkeyname as pk_name,    7 as deferrability  FROM syscat.references ref join syscat.keycoluse fk_col on ref.constname=fk_col.constname and ref.tabschema=fk_col.tabschema and ref.tabname=fk_col.tabname join syscat.keycoluse pk_col on ref.refkeyname=pk_col.constname and ref.reftabschema=pk_col.tabschema and ref.reftabname=pk_col.tabname WHERE ref.tabschema = '" + jdbcSchemaName + "' and pk_col.colseq=fk_col.colseq " + (tableName2 != null ? " AND fk_col.tabname='" + tableName2 + "' " : "") + "ORDER BY fk_col.colseq";
                }

                protected String getDB2ZOSSql(String jdbcSchemaName, String tableName2) {
                    return "SELECT    ref.REFTBCREATOR AS pktable_cat,    ref.REFTBNAME as pktable_name,    pk_col.colname as pkcolumn_name,   ref.CREATOR as fktable_cat,    ref.TBNAME as fktable_name,    fk_col.colname as fkcolumn_name,   fk_col.colseq as key_seq,    decode (ref.deleterule, 'A', 3, 'C', 0, 'N', 2, 'R', 1, 1) as delete_rule,    ref.relname as fk_name,    pk_col.colname as pk_name,    7 as deferrability  FROM SYSIBM.SYSRELS ref join SYSIBM.SYSFOREIGNKEYS fk_col on ref.relname = fk_col.RELNAME and ref.CREATOR = fk_col.CREATOR and ref.TBNAME = fk_col.TBNAME join SYSIBM.SYSKEYCOLUSE pk_col on ref.REFTBCREATOR = pk_col.TBCREATOR and ref.REFTBNAME = pk_col.TBNAME WHERE ref.CREATOR = '" + jdbcSchemaName + "' and pk_col.colseq=fk_col.colseq " + (tableName2 != null ? " AND ref.TBNAME='" + tableName2 + "' " : "") + "ORDER BY fk_col.colseq";
                }
            });
        }

        public List<CachedRow> getIndexInfo(final String catalogName, final String schemaName, final String tableName, final String indexName) throws DatabaseException, SQLException {
            List indexes = DmJdbcDatabaseSnapshot.this.getResultSetCache("getIndexInfo").get((ResultSetCache.ResultSetExtractor)new ResultSetCache.UnionResultSetExtractor(this.database){
                public boolean isBulkFetchMode;

                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), DmCachingDatabaseMetaData.this.database, new String[]{row.getString("TABLE_NAME"), row.getString("INDEX_NAME")});
                }

                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, DmCachingDatabaseMetaData.this.database, new String[]{tableName, indexName});
                }

                public boolean bulkContainsSchema(String schemaKey) {
                    return DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() != null && DmCachingDatabaseMetaData.this.database instanceof OracleDatabase;
                }

                public String getSchemaKey(CachedRow row) {
                    return row.getString("TABLE_SCHEM");
                }

                public List<CachedRow> fastFetch() throws SQLException, DatabaseException {
                    ArrayList<CachedRow> returnList = new ArrayList<CachedRow>();
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                    if (DmCachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        DmCachingDatabaseMetaData.this.warnAboutDbaRecycleBin();
                        String sql = "SELECT c.INDEX_NAME, 3 AS TYPE, c.TABLE_OWNER AS TABLE_SCHEM, c.TABLE_NAME, c.COLUMN_NAME, c.COLUMN_POSITION AS ORDINAL_POSITION, e.COLUMN_EXPRESSION AS FILTER_CONDITION, CASE I.UNIQUENESS WHEN 'UNIQUE' THEN 0 ELSE 1 END AS NON_UNIQUE, CASE c.DESCEND WHEN 'DESC' THEN 'D' WHEN 'ASC' THEN 'A' END AS ASC_OR_DESC, CASE WHEN tablespace_name = (SELECT default_tablespace FROM user_users) THEN NULL ELSE tablespace_name END AS tablespace_name  FROM ALL_IND_COLUMNS c JOIN ALL_INDEXES i ON i.owner=c.index_owner AND i.index_name = c.index_name and i.table_owner = c.table_owner LEFT OUTER JOIN all_ind_expressions e ON e.index_owner=c.index_owner AND e.index_name = c.index_name AND e.column_position = c.column_position   LEFT OUTER JOIN " + (((OracleDatabase)DmCachingDatabaseMetaData.this.database).canAccessDbaRecycleBin() ? "dba_recyclebin" : "user_recyclebin") + " d ON d.object_name=c.table_name ";
                        sql = !this.isBulkFetchMode || DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() == null ? sql + "WHERE c.TABLE_OWNER = '" + DmCachingDatabaseMetaData.this.database.correctObjectName(catalogAndSchema.getCatalogName(), Schema.class) + "' " : sql + "WHERE c.TABLE_OWNER IN ('" + DmCachingDatabaseMetaData.this.database.correctObjectName(catalogAndSchema.getCatalogName(), Schema.class) + "', " + DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() + ")";
                        sql = sql + "AND i.OWNER = c.TABLE_OWNER AND d.object_name IS NULL ";
                        if (!this.isBulkFetchMode && tableName != null) {
                            sql = sql + " AND c.TABLE_NAME='" + tableName + "'";
                        }
                        if (!this.isBulkFetchMode && indexName != null) {
                            sql = sql + " AND c.INDEX_NAME='" + indexName + "'";
                        }
                        sql = sql + " ORDER BY c.INDEX_NAME, ORDINAL_POSITION";
                        returnList.addAll(this.executeAndExtract(sql, DmCachingDatabaseMetaData.this.database));
                    } else if (DmCachingDatabaseMetaData.this.database instanceof MSSQLDatabase) {
                        String tableCat = "original_db_name()";
                        if (9 <= DmCachingDatabaseMetaData.this.database.getDatabaseMajorVersion()) {
                            tableCat = "db_name()";
                        }
                        String sql = "SELECT " + tableCat + " as TABLE_CAT, object_schema_name(i.object_id) as TABLE_SCHEM, object_name(i.object_id) as TABLE_NAME, CASE is_unique WHEN 1 then 0 else 1 end as NON_UNIQUE, object_name(i.object_id) as INDEX_QUALIFIER, i.name as INDEX_NAME, case i.type when 1 then 1 ELSE 3 end as TYPE, key_ordinal as ORDINAL_POSITION, COL_NAME(c.object_id,c.column_id) AS COLUMN_NAME, case is_descending_key when 0 then 'A' else 'D' end as ASC_OR_DESC, null as CARDINALITY, null as PAGES, i.filter_definition as FILTER_CONDITION, o.type AS INTERNAL_OBJECT_TYPE, i.*, c.*, s.* FROM sys.indexes i join sys.index_columns c on i.object_id=c.object_id and i.index_id=c.index_id join sys.stats s on i.object_id=s.object_id and i.name=s.name join sys.objects o on i.object_id=o.object_id WHERE object_schema_name(i.object_id)='" + DmCachingDatabaseMetaData.this.database.correctObjectName(catalogAndSchema.getSchemaName(), Schema.class) + "'";
                        if (!this.isBulkFetchMode && tableName != null) {
                            sql = sql + " AND object_name(i.object_id)='" + DmCachingDatabaseMetaData.this.database.escapeStringForDatabase(tableName) + "'";
                        }
                        if (!this.isBulkFetchMode && indexName != null) {
                            sql = sql + " AND i.name='" + DmCachingDatabaseMetaData.this.database.escapeStringForDatabase(indexName) + "'";
                        }
                        sql = sql + "ORDER BY i.object_id, i.index_id, c.key_ordinal";
                        returnList.addAll(this.executeAndExtract(sql, DmCachingDatabaseMetaData.this.database));
                    } else if (DmCachingDatabaseMetaData.this.database instanceof Db2zDatabase) {
                        String sql = "SELECT i.CREATOR AS TABLE_SCHEM, i.TBNAME AS TABLE_NAME, i.NAME AS INDEX_NAME, 3 AS TYPE, k.COLNAME AS COLUMN_NAME, k.COLSEQ AS ORDINAL_POSITION, CASE UNIQUERULE WHEN 'D' then 1 else 0 end as NON_UNIQUE, k.ORDERING AS ORDER, i.CREATOR AS INDEX_QUALIFIER FROM SYSIBM.SYSKEYS k JOIN SYSIBM.SYSINDEXES i ON k.IXNAME = i.NAME WHERE  i.CREATOR = '" + DmCachingDatabaseMetaData.this.database.correctObjectName(catalogAndSchema.getSchemaName(), Schema.class) + "'";
                        if (!this.isBulkFetchMode && tableName != null) {
                            sql = sql + " AND i.TBNAME='" + DmCachingDatabaseMetaData.this.database.escapeStringForDatabase(tableName) + "'";
                        }
                        if (!this.isBulkFetchMode && indexName != null) {
                            sql = sql + " AND i.NAME='" + DmCachingDatabaseMetaData.this.database.escapeStringForDatabase(indexName) + "'";
                        }
                        sql = sql + "ORDER BY i.NAME, k.COLSEQ";
                        returnList.addAll(this.executeAndExtract(sql, DmCachingDatabaseMetaData.this.database));
                    } else {
                        ArrayList<String> tables = new ArrayList<String>();
                        if (tableName == null) {
                            for (CachedRow row : DmCachingDatabaseMetaData.this.getTables(((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), null)) {
                                tables.add(row.getString("TABLE_NAME"));
                            }
                        } else {
                            tables.add(tableName);
                        }
                        for (String tableName2 : tables) {
                            ResultSet rs = DmCachingDatabaseMetaData.this.databaseMetaData.getIndexInfo(((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), tableName2, false, true);
                            List rows = this.extract(rs, DmCachingDatabaseMetaData.this.database instanceof InformixDatabase);
                            returnList.addAll(rows);
                        }
                    }
                    return returnList;
                }

                public List<CachedRow> bulkFetch() throws SQLException, DatabaseException {
                    this.isBulkFetchMode = true;
                    return this.fastFetch();
                }

                boolean shouldBulkSelect(String schemaKey, ResultSetCache resultSetCache) {
                    if (DmCachingDatabaseMetaData.this.database instanceof OracleDatabase || DmCachingDatabaseMetaData.this.database instanceof MSSQLDatabase) {
                        return DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() != null || tableName == null && indexName == null || super.shouldBulkSelect(schemaKey, resultSetCache);
                    }
                    return false;
                }
            });
            return indexes;
        }

        protected void warnAboutDbaRecycleBin() {
            if (!(ignoreWarnAboutDbaRecycleBin || DmJdbcDatabaseSnapshot.this.warnedAboutDbaRecycleBin || ((OracleDatabase)this.database).canAccessDbaRecycleBin())) {
                LogService.getLog(((Object)((Object)this)).getClass()).warning(LogType.LOG, ((OracleDatabase)this.database).getDbaRecycleBinWarning());
                DmJdbcDatabaseSnapshot.this.warnedAboutDbaRecycleBin = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<CachedRow> getColumns(final String catalogName, final String schemaName, final String tableName, final String columnName) throws SQLException, DatabaseException {
            if (this.database instanceof MSSQLDatabase && DmJdbcDatabaseSnapshot.this.userDefinedTypes == null) {
                DmJdbcDatabaseSnapshot.this.userDefinedTypes = new HashSet();
                DatabaseConnection databaseConnection = this.database.getConnection();
                if (databaseConnection instanceof JdbcConnection) {
                    Statement stmt = null;
                    ResultSet resultSet = null;
                    try {
                        String sql = "select name from sys.types where is_user_defined=1";
                        stmt = ((JdbcConnection)databaseConnection).getUnderlyingConnection().createStatement();
                        resultSet = stmt.executeQuery(sql);
                        while (resultSet.next()) {
                            DmJdbcDatabaseSnapshot.this.userDefinedTypes.add(resultSet.getString("name").toLowerCase());
                        }
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.close(resultSet, stmt);
                        throw throwable;
                    }
                    JdbcUtils.close((ResultSet)resultSet, (Statement)stmt);
                }
            }
            List columns = DmJdbcDatabaseSnapshot.this.getResultSetCache("getColumns").get((ResultSetCache.ResultSetExtractor)new ResultSetCache.SingleResultSetExtractor(this.database){

                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), DmCachingDatabaseMetaData.this.database, new String[]{row.getString("TABLE_NAME"), row.getString("COLUMN_NAME")});
                }

                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, DmCachingDatabaseMetaData.this.database, new String[]{tableName, columnName});
                }

                public boolean bulkContainsSchema(String schemaKey) {
                    String catalogs = DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData();
                    return catalogs != null && schemaKey != null && catalogs.contains("'" + schemaKey.toUpperCase() + "'") && DmCachingDatabaseMetaData.this.database instanceof OracleDatabase;
                }

                public String getSchemaKey(CachedRow row) {
                    return row.getString("TABLE_SCHEM");
                }

                boolean shouldBulkSelect(String schemaKey, ResultSetCache resultSetCache) {
                    return !tableName.equalsIgnoreCase(DmCachingDatabaseMetaData.this.database.getDatabaseChangeLogTableName()) && !tableName.equalsIgnoreCase(DmCachingDatabaseMetaData.this.database.getDatabaseChangeLogLockTableName());
                }

                public List<CachedRow> fastFetchQuery() throws SQLException, DatabaseException {
                    if (DmCachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.oracleQuery(false);
                    }
                    if (DmCachingDatabaseMetaData.this.database instanceof MSSQLDatabase) {
                        return this.mssqlQuery(false);
                    }
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                    try {
                        return this.extract(DmCachingDatabaseMetaData.this.databaseMetaData.getColumns(((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), tableName, DmCachingDatabaseMetaData.SQL_FILTER_MATCH_ALL));
                    }
                    catch (SQLException e) {
                        if (this.shouldReturnEmptyColumns(e)) {
                            return new ArrayList<CachedRow>();
                        }
                        throw e;
                    }
                }

                public List<CachedRow> bulkFetchQuery() throws SQLException, DatabaseException {
                    if (DmCachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.oracleQuery(true);
                    }
                    if (DmCachingDatabaseMetaData.this.database instanceof MSSQLDatabase) {
                        return this.mssqlQuery(true);
                    }
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                    try {
                        return this.extract(DmCachingDatabaseMetaData.this.databaseMetaData.getColumns(((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), DmCachingDatabaseMetaData.SQL_FILTER_MATCH_ALL, DmCachingDatabaseMetaData.SQL_FILTER_MATCH_ALL));
                    }
                    catch (SQLException e) {
                        if (this.shouldReturnEmptyColumns(e)) {
                            return new ArrayList<CachedRow>();
                        }
                        throw e;
                    }
                }

                protected boolean shouldReturnEmptyColumns(SQLException e) {
                    return e.getMessage().contains("references invalid table");
                }

                protected List<CachedRow> oracleQuery(boolean bulk) throws DatabaseException, SQLException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                    boolean getMapDateToTimestamp = true;
                    String sql = "select NULL AS TABLE_CAT, OWNER AS TABLE_SCHEM, 'NO' as IS_AUTOINCREMENT, cc.COMMENTS AS REMARKS,OWNER, TABLE_NAME, COLUMN_NAME, DATA_TYPE AS DATA_TYPE_NAME, DATA_TYPE_MOD, DATA_TYPE_OWNER, DECODE (c.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NUMBER', 3, 'LONG', -1, 'DATE', " + (getMapDateToTimestamp ? "93" : "91") + ", 'RAW', -3, 'LONG RAW', -4, 'BLOB', 2004, 'CLOB', 2005, 'BFILE', -13, 'FLOAT', 6, 'TIMESTAMP(6)', 93, 'TIMESTAMP(6) WITH TIME ZONE', -101, 'TIMESTAMP(6) WITH LOCAL TIME ZONE', -102, 'INTERVAL YEAR(2) TO MONTH', -103, 'INTERVAL DAY(2) TO SECOND(6)', -104, 'BINARY_FLOAT', 100, 'BINARY_DOUBLE', 101, 'XMLTYPE', 2009, 1111) AS data_type, DECODE( CHAR_USED, 'C',CHAR_LENGTH, DATA_LENGTH ) as DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, COLUMN_ID as ORDINAL_POSITION, DEFAULT_LENGTH, DATA_DEFAULT, NUM_BUCKETS, CHARACTER_SET_NAME, CHAR_COL_DECL_LENGTH, CHAR_LENGTH, CHAR_USED, VIRTUAL_COLUMN FROM ALL_TAB_COLS c JOIN ALL_COL_COMMENTS cc USING ( OWNER, TABLE_NAME, COLUMN_NAME ) ";
                    sql = !bulk || DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() == null ? sql + "WHERE OWNER='" + ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema) + "'" : sql + "WHERE OWNER IN ('" + ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema) + "', " + DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() + ") ";
                    if (!bulk) {
                        if (tableName != null) {
                            sql = sql + " AND TABLE_NAME='" + DmCachingDatabaseMetaData.this.database.escapeStringForDatabase(tableName) + "'";
                        }
                        if (columnName != null) {
                            sql = sql + " AND COLUMN_NAME='" + DmCachingDatabaseMetaData.this.database.escapeStringForDatabase(columnName) + "'";
                        }
                    }
                    sql = sql + " AND " + ((OracleDatabase)DmCachingDatabaseMetaData.this.database).getSystemTableWhereClause("TABLE_NAME");
                    sql = sql + " ORDER BY OWNER, TABLE_NAME, c.COLUMN_ID";
                    return this.executeAndExtract(sql, DmCachingDatabaseMetaData.this.database);
                }

                protected List<CachedRow> mssqlQuery(boolean bulk) throws DatabaseException, SQLException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                    String tableCat = "original_db_name()";
                    if (9 <= DmCachingDatabaseMetaData.this.database.getDatabaseMajorVersion()) {
                        tableCat = "db_name()";
                    }
                    String sql = "select " + tableCat + " AS TABLE_CAT, object_schema_name(c.object_id) AS TABLE_SCHEM, object_name(c.object_id) AS TABLE_NAME, c.name AS COLUMN_NAME, is_filestream, is_rowguidcol, CASE WHEN c.is_identity = 'true' THEN 'YES' ELSE 'NO' END as IS_AUTOINCREMENT, {REMARKS_COLUMN_PLACEHOLDER}t.name AS TYPE_NAME, dc.name as COLUMN_DEF_NAME, dc.definition as COLUMN_DEF, CASE t.name WHEN 'bigint' THEN " + -5 + " WHEN 'binary' THEN " + -2 + " WHEN 'bit' THEN " + -7 + " WHEN 'char' THEN " + 1 + " WHEN 'date' THEN " + 91 + " WHEN 'datetime' THEN " + 93 + " WHEN 'datetime2' THEN " + 93 + " WHEN 'datetimeoffset' THEN -155 WHEN 'decimal' THEN " + 3 + " WHEN 'float' THEN " + 8 + " WHEN 'image' THEN " + -4 + " WHEN 'int' THEN " + 4 + " WHEN 'money' THEN " + 3 + " WHEN 'nchar' THEN " + -15 + " WHEN 'ntext' THEN " + -16 + " WHEN 'numeric' THEN " + 2 + " WHEN 'nvarchar' THEN " + -9 + " WHEN 'real' THEN " + 7 + " WHEN 'smalldatetime' THEN " + 93 + " WHEN 'smallint' THEN " + 5 + " WHEN 'smallmoney' THEN " + 3 + " WHEN 'text' THEN " + -1 + " WHEN 'time' THEN " + 92 + " WHEN 'timestamp' THEN " + -2 + " WHEN 'tinyint' THEN " + -6 + " WHEN 'udt' THEN " + -3 + " WHEN 'uniqueidentifier' THEN " + 1 + " WHEN 'varbinary' THEN " + -3 + " WHEN 'varbinary(max)' THEN " + -3 + " WHEN 'varchar' THEN " + 12 + " WHEN 'varchar(max)' THEN " + 12 + " WHEN 'xml' THEN " + -1 + " WHEN 'LONGNVARCHAR' THEN " + 2009 + " ELSE " + 1111 + " END AS data_type, CASE WHEN c.is_nullable = 'true' THEN 1 ELSE 0 END AS NULLABLE, 10 as NUM_PREC_RADIX, c.column_id as ORDINAL_POSITION, c.scale as DECIMAL_DIGITS, c.max_length as COLUMN_SIZE, c.precision as DATA_PRECISION FROM sys.columns c inner join sys.types t on c.user_type_id=t.user_type_id {REMARKS_JOIN_PLACEHOLDER}left outer join sys.default_constraints dc on dc.parent_column_id = c.column_id AND dc.parent_object_id=c.object_id AND type_desc='DEFAULT_CONSTRAINT' WHERE object_schema_name(c.object_id)='" + ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema) + "'";
                    if (!bulk) {
                        if (tableName != null) {
                            sql = sql + " and object_name(c.object_id)='" + DmCachingDatabaseMetaData.this.database.escapeStringForDatabase(tableName) + "'";
                        }
                        if (columnName != null) {
                            sql = sql + " and c.name='" + DmCachingDatabaseMetaData.this.database.escapeStringForDatabase(columnName) + "'";
                        }
                    }
                    sql = sql + "order by object_schema_name(c.object_id), object_name(c.object_id), c.column_id";
                    if (!((MSSQLDatabase)DmCachingDatabaseMetaData.this.database).isAzureDb() || DmCachingDatabaseMetaData.this.database.getDatabaseMajorVersion() >= 12) {
                        sql = sql.replace("{REMARKS_COLUMN_PLACEHOLDER}", "CAST([ep].[value] AS [nvarchar](MAX)) AS [REMARKS], ");
                        sql = sql.replace("{REMARKS_JOIN_PLACEHOLDER}", "left outer join [sys].[extended_properties] AS [ep] ON [ep].[class] = 1 AND [ep].[major_id] = c.object_id AND [ep].[minor_id] = column_id AND [ep].[name] = 'MS_Description' ");
                    } else {
                        sql = sql.replace("{REMARKS_COLUMN_PLACEHOLDER}", "");
                        sql = sql.replace("{REMARKS_JOIN_PLACEHOLDER}", "");
                    }
                    List rows = this.executeAndExtract(sql, DmCachingDatabaseMetaData.this.database);
                    for (CachedRow row : rows) {
                        String typeName = row.getString("TYPE_NAME");
                        if ("nvarchar".equals(typeName) || "nchar".equals(typeName)) {
                            Integer size = row.getInt("COLUMN_SIZE");
                            if (size <= 0) continue;
                            row.set("COLUMN_SIZE", (Object)(size / 2));
                            continue;
                        }
                        if (row.getInt("DATA_PRECISION") == null || row.getInt("DATA_PRECISION") <= 0) continue;
                        row.set("COLUMN_SIZE", (Object)row.getInt("DATA_PRECISION"));
                    }
                    return rows;
                }

                protected List<CachedRow> extract(ResultSet resultSet, boolean informixIndexTrimHint) throws SQLException {
                    List rows = super.extract(resultSet, informixIndexTrimHint);
                    if (DmCachingDatabaseMetaData.this.database instanceof MSSQLDatabase && !DmJdbcDatabaseSnapshot.this.userDefinedTypes.isEmpty()) {
                        for (CachedRow row : rows) {
                            String dataType = (String)row.get("TYPE_NAME");
                            if (!DmJdbcDatabaseSnapshot.this.userDefinedTypes.contains(dataType.toLowerCase())) continue;
                            row.set("COLUMN_SIZE", null);
                            row.set("DECIMAL_DIGITS ", null);
                        }
                    }
                    return rows;
                }
            });
            return columns;
        }

        public List<CachedRow> getTables(final String catalogName, final String schemaName, final String table) throws DatabaseException {
            return DmJdbcDatabaseSnapshot.this.getResultSetCache("getTables").get((ResultSetCache.ResultSetExtractor)new ResultSetCache.SingleResultSetExtractor(this.database){

                boolean shouldBulkSelect(String schemaKey, ResultSetCache resultSetCache) {
                    return table == null || DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() != null || super.shouldBulkSelect(schemaKey, resultSetCache);
                }

                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), DmCachingDatabaseMetaData.this.database, new String[]{row.getString("TABLE_NAME")});
                }

                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, DmCachingDatabaseMetaData.this.database, new String[]{table});
                }

                public boolean bulkContainsSchema(String schemaKey) {
                    return DmCachingDatabaseMetaData.this.database instanceof OracleDatabase;
                }

                public String getSchemaKey(CachedRow row) {
                    return row.getString("TABLE_SCHEM");
                }

                public List<CachedRow> fastFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                    if (DmCachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.queryOracle(catalogAndSchema, table);
                    }
                    if (DmCachingDatabaseMetaData.this.database instanceof MSSQLDatabase) {
                        return this.queryMssql(catalogAndSchema, table);
                    }
                    if (DmCachingDatabaseMetaData.this.database instanceof Db2zDatabase) {
                        return this.queryDb2Zos(catalogAndSchema, table);
                    }
                    String catalog = ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema);
                    String schema = ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                    return this.extract(DmCachingDatabaseMetaData.this.databaseMetaData.getTables(catalog, schema, table == null ? DmCachingDatabaseMetaData.SQL_FILTER_MATCH_ALL : table, new String[]{"TABLE"}));
                }

                public List<CachedRow> bulkFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                    if (DmCachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.queryOracle(catalogAndSchema, null);
                    }
                    if (DmCachingDatabaseMetaData.this.database instanceof MSSQLDatabase) {
                        return this.queryMssql(catalogAndSchema, null);
                    }
                    if (DmCachingDatabaseMetaData.this.database instanceof Db2zDatabase) {
                        return this.queryDb2Zos(catalogAndSchema, null);
                    }
                    String catalog = ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema);
                    String schema = ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                    return this.extract(DmCachingDatabaseMetaData.this.databaseMetaData.getTables(catalog, schema, DmCachingDatabaseMetaData.SQL_FILTER_MATCH_ALL, new String[]{"TABLE"}));
                }

                private List<CachedRow> queryMssql(CatalogAndSchema catalogAndSchema, String tableName) throws DatabaseException, SQLException {
                    String ownerName = DmCachingDatabaseMetaData.this.database.correctObjectName(catalogAndSchema.getSchemaName(), Schema.class);
                    String sql = "select convert(sysname,db_name()) AS TABLE_QUALIFIER, convert(sysname,schema_name(o.schema_id)) AS TABLE_SCHEM, convert(sysname,o.name) AS TABLE_NAME, 'TABLE' AS TABLE_TYPE, CAST(ep.value as varchar(max)) as REMARKS from  sys.all_objects o left outer join sys.extended_properties ep on ep.name='MS_Description' and major_id=o.object_id and minor_id=0 where o.type in ('U') and has_perms_by_name(quotename(schema_name(o.schema_id)) + '.' + quotename(o.name), 'object', 'select') = 1 and charindex(substring(o.type,1,1),'U') <> 0 and schema_name(o.schema_id)='" + DmCachingDatabaseMetaData.this.database.escapeStringForDatabase(ownerName) + "'";
                    if (tableName != null) {
                        sql = sql + " AND o.name='" + DmCachingDatabaseMetaData.this.database.escapeStringForDatabase(tableName) + "' ";
                    }
                    sql = sql + "order by 4, 1, 2, 3";
                    return this.executeAndExtract(sql, DmCachingDatabaseMetaData.this.database);
                }

                private List<CachedRow> queryOracle(CatalogAndSchema catalogAndSchema, String tableName) throws DatabaseException, SQLException {
                    String ownerName = DmCachingDatabaseMetaData.this.database.correctObjectName(catalogAndSchema.getCatalogName(), Schema.class);
                    String sql = "SELECT null as TABLE_CAT, a.OWNER as TABLE_SCHEM, a.TABLE_NAME as TABLE_NAME, a.TEMPORARY as TEMPORARY, a.DURATION as DURATION, 'TABLE' as TABLE_TYPE, c.COMMENTS as REMARKS, CASE WHEN A.tablespace_name = (SELECT DEFAULT_TABLESPACE FROM USER_USERS) THEN NULL ELSE tablespace_name END AS tablespace_name  from ALL_TABLES a join ALL_TAB_COMMENTS c on a.TABLE_NAME=c.table_name and a.owner=c.owner ";
                    String allCatalogsString = DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData();
                    sql = tableName != null || allCatalogsString == null ? sql + "WHERE a.OWNER='" + ownerName + "'" : sql + "WHERE a.OWNER IN ('" + ownerName + "', " + allCatalogsString + ")";
                    if (tableName != null) {
                        sql = sql + " AND a.TABLE_NAME='" + tableName + "'";
                    }
                    return this.executeAndExtract(sql, DmCachingDatabaseMetaData.this.database);
                }

                private List<CachedRow> queryDb2Zos(CatalogAndSchema catalogAndSchema, String tableName) throws DatabaseException, SQLException {
                    String ownerName = DmCachingDatabaseMetaData.this.database.correctObjectName(catalogAndSchema.getCatalogName(), Schema.class);
                    String sql = "SELECT CREATOR AS TABLE_SCHEM, NAME AS TABLE_NAME, 'TABLE' AS TABLE_TYPE, REMARKS FROM  SYSIBM.SYSTABLES WHERE TYPE = 'T' ";
                    if (ownerName != null) {
                        sql = sql + "AND CREATOR='" + ownerName + "'";
                    }
                    if (tableName != null) {
                        sql = sql + " AND NAME='" + tableName + "'";
                    }
                    return this.executeAndExtract(sql, DmCachingDatabaseMetaData.this.database);
                }
            });
        }

        public List<CachedRow> getViews(final String catalogName, final String schemaName, final String view) throws DatabaseException {
            return DmJdbcDatabaseSnapshot.this.getResultSetCache("getViews").get((ResultSetCache.ResultSetExtractor)new ResultSetCache.SingleResultSetExtractor(this.database){

                boolean shouldBulkSelect(String schemaKey, ResultSetCache resultSetCache) {
                    return view == null || DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() != null || super.shouldBulkSelect(schemaKey, resultSetCache);
                }

                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), DmCachingDatabaseMetaData.this.database, new String[]{row.getString("TABLE_NAME")});
                }

                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, DmCachingDatabaseMetaData.this.database, new String[]{view});
                }

                public boolean bulkContainsSchema(String schemaKey) {
                    return DmCachingDatabaseMetaData.this.database instanceof OracleDatabase;
                }

                public String getSchemaKey(CachedRow row) {
                    return row.getString("TABLE_SCHEM");
                }

                public List<CachedRow> fastFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                    if (DmCachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.queryOracle(catalogAndSchema, view);
                    }
                    String catalog = ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema);
                    String schema = ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                    return this.extract(DmCachingDatabaseMetaData.this.databaseMetaData.getTables(catalog, schema, view == null ? DmCachingDatabaseMetaData.SQL_FILTER_MATCH_ALL : view, new String[]{"VIEW"}));
                }

                public List<CachedRow> bulkFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                    if (DmCachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.queryOracle(catalogAndSchema, null);
                    }
                    String catalog = ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema);
                    String schema = ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                    return this.extract(DmCachingDatabaseMetaData.this.databaseMetaData.getTables(catalog, schema, DmCachingDatabaseMetaData.SQL_FILTER_MATCH_ALL, new String[]{"VIEW"}));
                }

                private List<CachedRow> queryOracle(CatalogAndSchema catalogAndSchema, String viewName) throws DatabaseException, SQLException {
                    String ownerName = DmCachingDatabaseMetaData.this.database.correctObjectName(catalogAndSchema.getCatalogName(), Schema.class);
                    String sql = "SELECT null as TABLE_CAT, a.OWNER as TABLE_SCHEM, a.VIEW_NAME as TABLE_NAME, 'TABLE' as TABLE_TYPE, c.COMMENTS as REMARKS, TEXT as OBJECT_BODY";
                    if (DmCachingDatabaseMetaData.this.database.getDatabaseMajorVersion() > 10) {
                        sql = sql + ", EDITIONING_VIEW";
                    }
                    sql = sql + " from ALL_VIEWS a join ALL_TAB_COMMENTS c on a.VIEW_NAME=c.table_name and a.owner=c.owner ";
                    sql = viewName != null || DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() == null ? sql + "WHERE a.OWNER='" + ownerName + "'" : sql + "WHERE a.OWNER IN ('" + ownerName + "', " + DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() + ")";
                    if (viewName != null) {
                        sql = sql + " AND a.VIEW_NAME='" + viewName + "'";
                    }
                    sql = sql + " AND a.VIEW_NAME not in (select mv.name from all_registered_mviews mv where mv.owner=a.owner)";
                    return this.executeAndExtract(sql, DmCachingDatabaseMetaData.this.database);
                }
            });
        }

        public List<CachedRow> getPrimaryKeys(final String catalogName, final String schemaName, final String table) throws DatabaseException {
            return DmJdbcDatabaseSnapshot.this.getResultSetCache("getPrimaryKeys").get((ResultSetCache.ResultSetExtractor)new ResultSetCache.SingleResultSetExtractor(this.database){

                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), DmCachingDatabaseMetaData.this.database, new String[]{row.getString("TABLE_NAME")});
                }

                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, DmCachingDatabaseMetaData.this.database, new String[]{table});
                }

                public boolean bulkContainsSchema(String schemaKey) {
                    return DmCachingDatabaseMetaData.this.database instanceof OracleDatabase;
                }

                public String getSchemaKey(CachedRow row) {
                    return row.getString("TABLE_SCHEM");
                }

                public List<CachedRow> fastFetchQuery() throws SQLException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                    try {
                        ArrayList<CachedRow> foundPks = new ArrayList<CachedRow>();
                        if (table == null) {
                            List<CachedRow> tables = DmCachingDatabaseMetaData.this.getTables(catalogName, schemaName, null);
                            for (CachedRow table2 : tables) {
                                List<CachedRow> pkInfo = this.getPkInfo(schemaName, catalogAndSchema, table2.getString("TABLE_NAME"));
                                if (pkInfo == null) continue;
                                foundPks.addAll(pkInfo);
                            }
                            return foundPks;
                        }
                        List<CachedRow> pkInfo = this.getPkInfo(schemaName, catalogAndSchema, table);
                        if (pkInfo != null) {
                            foundPks.addAll(pkInfo);
                        }
                        return foundPks;
                    }
                    catch (DatabaseException e) {
                        throw new SQLException(e);
                    }
                }

                private List<CachedRow> getPkInfo(String schemaName2, CatalogAndSchema catalogAndSchema, String tableName) throws DatabaseException, SQLException {
                    if (!(DmCachingDatabaseMetaData.this.database instanceof MSSQLDatabase)) {
                        if (DmCachingDatabaseMetaData.this.database instanceof Db2zDatabase) {
                            String sql = "SELECT 'NULL' AS TABLE_CAT, SYSTAB.TBCREATOR AS TABLE_SCHEM, SYSTAB.TBNAME AS TABLE_NAME, COLUSE.COLNAME AS COLUMN_NAME, COLUSE.COLSEQ AS KEY_SEQ, SYSTAB.CONSTNAME AS PK_NAME FROM SYSIBM.SYSTABCONST SYSTAB JOIN SYSIBM.SYSKEYCOLUSE COLUSE ON SYSTAB.TBCREATOR = COLUSE.TBCREATOR WHERE SYSTAB.TYPE = 'P' AND SYSTAB.TBNAME='" + table + "' AND SYSTAB.TBCREATOR='" + schemaName2 + "' AND SYSTAB.TBNAME=COLUSE.TBNAME AND SYSTAB.CONSTNAME=COLUSE.CONSTNAME ORDER BY COLUSE.COLNAME";
                            try {
                                return this.executeAndExtract(sql, DmCachingDatabaseMetaData.this.database);
                            }
                            catch (DatabaseException e) {
                                throw new SQLException(e);
                            }
                        }
                        if (DmCachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                            DmCachingDatabaseMetaData.this.warnAboutDbaRecycleBin();
                            String sql = "SELECT NULL AS table_cat, c.owner AS table_schem, c.table_name, c.column_name, c.position AS key_seq, c.constraint_name AS pk_name FROM all_cons_columns c, all_constraints k LEFT JOIN " + (((OracleDatabase)DmCachingDatabaseMetaData.this.database).canAccessDbaRecycleBin() ? "dba_recyclebin" : "user_recyclebin") + " d ON d.object_name=k.table_name WHERE k.constraint_type = 'P' AND d.object_name IS NULL AND k.table_name = '" + table + "' AND k.owner = '" + ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema) + "' AND k.constraint_name = c.constraint_name AND k.table_name = c.table_name AND k.owner = c.owner ORDER BY column_name";
                            try {
                                return this.executeAndExtract(sql, DmCachingDatabaseMetaData.this.database);
                            }
                            catch (DatabaseException e) {
                                throw new SQLException(e);
                            }
                        }
                        return this.extract(DmCachingDatabaseMetaData.this.databaseMetaData.getPrimaryKeys(((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), table));
                    }
                    String sql = this.mssqlSql(catalogAndSchema, tableName);
                    List pkInfo = this.executeAndExtract(sql, DmCachingDatabaseMetaData.this.database);
                    return pkInfo;
                }

                private String mssqlSql(CatalogAndSchema catalogAndSchema, String tableName) throws DatabaseException {
                    String sql = "SELECT DB_NAME() AS [TABLE_CAT], [s].[name] AS [TABLE_SCHEM], [t].[name] AS [TABLE_NAME], [c].[name] AS [COLUMN_NAME], CASE [ic].[is_descending_key] WHEN 0 THEN N'A' WHEN 1 THEN N'D' END AS [ASC_OR_DESC], [ic].[key_ordinal] AS [KEY_SEQ], [kc].[name] AS [PK_NAME] FROM [sys].[schemas] AS [s] INNER JOIN [sys].[tables] AS [t] ON [t].[schema_id] = [s].[schema_id] INNER JOIN [sys].[key_constraints] AS [kc] ON [kc].[parent_object_id] = [t].[object_id] INNER JOIN [sys].[indexes] AS [i] ON [i].[object_id] = [kc].[parent_object_id] AND [i].[index_id] = [kc].[unique_index_id] INNER JOIN [sys].[index_columns] AS [ic] ON [ic].[object_id] = [i].[object_id] AND [ic].[index_id] = [i].[index_id] INNER JOIN [sys].[columns] AS [c] ON [c].[object_id] = [ic].[object_id] AND [c].[column_id] = [ic].[column_id] WHERE [s].[name] = N'" + DmCachingDatabaseMetaData.this.database.escapeStringForDatabase(catalogAndSchema.getSchemaName()) + "' " + (tableName == null ? "" : "AND [t].[name] = N'" + DmCachingDatabaseMetaData.this.database.escapeStringForDatabase(DmCachingDatabaseMetaData.this.database.correctObjectName(tableName, Table.class)) + "' ") + "AND [kc].[type] = 'PK' AND [ic].[key_ordinal] > 0 ORDER BY [ic].[key_ordinal]";
                    return sql;
                }

                public List<CachedRow> bulkFetchQuery() throws SQLException {
                    if (DmCachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                        DmCachingDatabaseMetaData.this.warnAboutDbaRecycleBin();
                        try {
                            String sql = "SELECT NULL AS table_cat, c.owner AS table_schem, c.table_name, c.column_name, c.position AS key_seq,c.constraint_name AS pk_name FROM all_cons_columns c, all_constraints k LEFT JOIN " + (((OracleDatabase)DmCachingDatabaseMetaData.this.database).canAccessDbaRecycleBin() ? "dba_recyclebin" : "user_recyclebin") + " d ON d.object_name=k.table_name WHERE k.constraint_type = 'P' AND d.object_name IS NULL ";
                            sql = DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() == null ? sql + "AND k.owner='" + catalogAndSchema.getCatalogName() + "' " : sql + "AND k.owner IN ('" + catalogAndSchema.getCatalogName() + "', " + DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() + ")";
                            sql = sql + "AND k.constraint_name = c.constraint_name AND k.table_name = c.table_name AND k.owner = c.owner ORDER BY column_name";
                            return this.executeAndExtract(sql, DmCachingDatabaseMetaData.this.database);
                        }
                        catch (DatabaseException e) {
                            throw new SQLException(e);
                        }
                    }
                    if (DmCachingDatabaseMetaData.this.database instanceof MSSQLDatabase) {
                        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                        try {
                            return this.executeAndExtract(this.mssqlSql(catalogAndSchema, null), DmCachingDatabaseMetaData.this.database);
                        }
                        catch (DatabaseException e) {
                            throw new SQLException(e);
                        }
                    }
                    return null;
                }

                boolean shouldBulkSelect(String schemaKey, ResultSetCache resultSetCache) {
                    if (DmCachingDatabaseMetaData.this.database instanceof OracleDatabase || DmCachingDatabaseMetaData.this.database instanceof MSSQLDatabase) {
                        return table == null || DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() != null || super.shouldBulkSelect(schemaKey, resultSetCache);
                    }
                    return false;
                }
            });
        }

        public List<CachedRow> getUniqueConstraints(final String catalogName, final String schemaName, final String tableName) throws DatabaseException {
            return DmJdbcDatabaseSnapshot.this.getResultSetCache("getUniqueConstraints").get((ResultSetCache.ResultSetExtractor)new ResultSetCache.SingleResultSetExtractor(this.database){

                boolean shouldBulkSelect(String schemaKey, ResultSetCache resultSetCache) {
                    return tableName == null || DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() != null || super.shouldBulkSelect(schemaKey, resultSetCache);
                }

                public boolean bulkContainsSchema(String schemaKey) {
                    return DmCachingDatabaseMetaData.this.database instanceof OracleDatabase;
                }

                public String getSchemaKey(CachedRow row) {
                    return row.getString("CONSTRAINT_SCHEM");
                }

                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(catalogName, schemaName, DmCachingDatabaseMetaData.this.database, new String[]{row.getString("TABLE_NAME")});
                }

                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, DmCachingDatabaseMetaData.this.database, new String[]{tableName});
                }

                public List<CachedRow> fastFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                    return this.executeAndExtract(this.createSql(((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), tableName), DmJdbcDatabaseSnapshot.this.getDatabase(), DmCachingDatabaseMetaData.this.database instanceof InformixDatabase);
                }

                public List<CachedRow> bulkFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(DmCachingDatabaseMetaData.this.database);
                    return this.executeAndExtract(this.createSql(((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), null), DmJdbcDatabaseSnapshot.this.getDatabase());
                }

                private String createSql(String catalogName2, String schemaName2, String tableName2) throws SQLException {
                    String sql;
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName2, schemaName2).customize(DmCachingDatabaseMetaData.this.database);
                    String jdbcCatalogName = DmCachingDatabaseMetaData.this.database.correctObjectName(((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), Catalog.class);
                    String jdbcSchemaName = DmCachingDatabaseMetaData.this.database.correctObjectName(((AbstractJdbcDatabase)DmCachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), Schema.class);
                    Database database = DmJdbcDatabaseSnapshot.this.getDatabase();
                    if (database instanceof MySQLDatabase || database instanceof HsqlDatabase || database instanceof MariaDBDatabase) {
                        sql = "select CONSTRAINT_NAME, TABLE_NAME from " + database.getSystemSchema() + ".table_constraints where constraint_schema='" + jdbcCatalogName + "' and constraint_type='UNIQUE'";
                        if (tableName2 != null) {
                            sql = sql + " and table_name='" + tableName2 + "'";
                        }
                    } else if (database instanceof PostgresDatabase) {
                        sql = "select CONSTRAINT_NAME, TABLE_NAME from " + database.getSystemSchema() + ".table_constraints where constraint_catalog='" + jdbcCatalogName + "' and constraint_schema='" + jdbcSchemaName + "' and constraint_type='UNIQUE'";
                        if (tableName2 != null) {
                            sql = sql + " and table_name='" + tableName2 + "'";
                        }
                    } else if (database instanceof MSSQLDatabase) {
                        sql = "SELECT [TC].[CONSTRAINT_NAME], [TC].[TABLE_NAME], [TC].[CONSTRAINT_CATALOG] AS INDEX_CATALOG, [TC].[CONSTRAINT_SCHEMA] AS INDEX_SCHEMA, [IDX].[TYPE_DESC], [IDX].[name] AS INDEX_NAME FROM [INFORMATION_SCHEMA].[TABLE_CONSTRAINTS] AS [TC] JOIN sys.indexes AS IDX ON IDX.name=[TC].[CONSTRAINT_NAME] AND object_schema_name(object_id)=[TC].[CONSTRAINT_SCHEMA] WHERE [TC].[CONSTRAINT_TYPE] = 'UNIQUE' AND [TC].[CONSTRAINT_CATALOG] = N'" + database.escapeStringForDatabase(jdbcCatalogName) + "' AND [TC].[CONSTRAINT_SCHEMA] = N'" + database.escapeStringForDatabase(jdbcSchemaName) + "'";
                        if (tableName2 != null) {
                            sql = sql + " AND [TC].[TABLE_NAME] = N'" + database.escapeStringForDatabase(database.correctObjectName(tableName2, Table.class)) + "'";
                        }
                    } else if (database instanceof OracleDatabase) {
                        DmCachingDatabaseMetaData.this.warnAboutDbaRecycleBin();
                        sql = "select uc.owner AS CONSTRAINT_SCHEM, uc.constraint_name, uc.table_name,uc.status,uc.deferrable,uc.deferred,ui.tablespace_name, ui.index_name, ui.owner as INDEX_CATALOG from all_constraints uc join all_indexes ui on uc.index_name = ui.index_name and uc.owner=ui.table_owner and uc.table_name=ui.table_name LEFT OUTER JOIN " + (((OracleDatabase)database).canAccessDbaRecycleBin() ? "dba_recyclebin" : "user_recyclebin") + " d ON d.object_name=ui.table_name where uc.constraint_type='U' ";
                        sql = tableName2 != null || DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() == null ? sql + "and uc.owner = '" + jdbcSchemaName + "'" : sql + "and uc.owner IN ('" + jdbcSchemaName + "', " + DmJdbcDatabaseSnapshot.this.getAllCatalogsStringScratchData() + ")";
                        sql = sql + "AND d.object_name IS NULL ";
                        if (tableName2 != null) {
                            sql = sql + " and uc.table_name = '" + tableName2 + "'";
                        }
                    } else if (database instanceof DB2Database) {
                        if (database.getDatabaseProductName().startsWith("DB2 UDB for AS/400")) {
                            sql = "select constraint_name as constraint_name, table_name as table_name from QSYS2.TABLE_CONSTRAINTS where table_schema='" + jdbcSchemaName + "' and constraint_type='UNIQUE'";
                            if (tableName2 != null) {
                                sql = sql + " and table_name = '" + tableName2 + "'";
                            }
                        } else {
                            sql = "select distinct k.constname as constraint_name, t.tabname as TABLE_NAME from syscat.keycoluse k, syscat.tabconst t where k.constname = t.constname and t.tabschema = '" + jdbcSchemaName + "' and t.type='U'";
                            if (tableName2 != null) {
                                sql = sql + " and t.tabname = '" + tableName2 + "'";
                            }
                        }
                    } else if (database instanceof Db2zDatabase) {
                        sql = "select distinct k.constname as constraint_name, t.tbname as TABLE_NAME from SYSIBM.SYSKEYCOLUSE k, SYSIBM.SYSTABCONST t where k.constname = t.constname and k.TBCREATOR = t.TBCREATOR and t.TBCREATOR = '" + jdbcSchemaName + "' ";
                        if (tableName2 != null) {
                            sql = sql + " and t.tbname = '" + tableName2 + "'";
                        }
                    } else if (database instanceof FirebirdDatabase) {
                        sql = "SELECT TRIM(RDB$INDICES.RDB$INDEX_NAME) AS CONSTRAINT_NAME, TRIM(RDB$INDICES.RDB$RELATION_NAME) AS TABLE_NAME FROM RDB$INDICES LEFT JOIN RDB$RELATION_CONSTRAINTS ON RDB$RELATION_CONSTRAINTS.RDB$INDEX_NAME = RDB$INDICES.RDB$INDEX_NAME WHERE RDB$INDICES.RDB$UNIQUE_FLAG IS NOT NULL AND (RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_TYPE IS NULL OR TRIM(RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_TYPE)='UNIQUE') AND NOT(RDB$INDICES.RDB$INDEX_NAME LIKE 'RDB$%')";
                        if (tableName2 != null) {
                            sql = sql + " AND TRIM(RDB$INDICES.RDB$RELATION_NAME)='" + tableName2 + "'";
                        }
                    } else if (database instanceof DerbyDatabase) {
                        sql = "select c.constraintname as CONSTRAINT_NAME, tablename AS TABLE_NAME from sys.systables t, sys.sysconstraints c, sys.sysschemas s where s.schemaname='" + jdbcCatalogName + "' and t.tableid = c.tableid and t.schemaid=s.schemaid and c.type = 'U'";
                        if (tableName2 != null) {
                            sql = sql + " AND t.tablename = '" + tableName2 + "'";
                        }
                    } else if (database instanceof InformixDatabase) {
                        sql = "select unique sysindexes.idxname as CONSTRAINT_NAME, sysindexes.idxtype, systables.tabname as TABLE_NAME from sysindexes, systables left outer join sysconstraints on sysconstraints.tabid = systables.tabid and sysconstraints.constrtype = 'P' where sysindexes.tabid = systables.tabid and sysindexes.idxtype = 'U' and sysconstraints.idxname != sysindexes.idxname and sysconstraints.tabid = sysindexes.tabid";
                        if (tableName2 != null) {
                            sql = sql + " and systables.tabname = '" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else {
                        if (database instanceof SybaseDatabase) {
                            LogService.getLog(((Object)((Object)this)).getClass()).warning(LogType.LOG, "Finding unique constraints not currently supported for Sybase");
                            return null;
                        }
                        if (database instanceof SybaseASADatabase) {
                            sql = "select sysconstraint.constraint_name, sysconstraint.constraint_type, systable.table_name from sysconstraint, systable where sysconstraint.table_object_id = systable.object_id and sysconstraint.constraint_type = 'U'";
                            if (tableName2 != null) {
                                sql = sql + " and systable.table_name = '" + tableName2 + "'";
                            }
                        } else {
                            sql = "select CONSTRAINT_NAME, CONSTRAINT_TYPE, TABLE_NAME from " + database.getSystemSchema() + ".constraints where constraint_schema='" + jdbcSchemaName + "' and constraint_catalog='" + jdbcCatalogName + "' and constraint_type='UNIQUE'";
                            if (tableName2 != null) {
                                sql = sql + " and table_name='" + tableName2 + "'";
                            }
                        }
                    }
                    return sql;
                }
            });
        }
    }
}

