/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.lang.reflect.Field;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.OfflineConnection;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.DmJdbcDatabaseSnapshot;
import liquibase.snapshot.EmptyDatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.DatabaseObject;
import org.flowable.idm.api.User;
import org.flowable.ui.common.security.SecurityUtils;

public class DmSnapshotGeneratorFactory
extends SnapshotGeneratorFactory {
    public static void init() {
        try {
            Field vField = SnapshotGeneratorFactory.class.getDeclaredField("instance");
            vField.setAccessible(true);
            vField.set(null, (Object)new DmSnapshotGeneratorFactory());
            System.out.println("11");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UserEntityImpl vUser = new UserEntityImpl();
        vUser.setId("1");
        SecurityUtils.assumeUser((User)vUser);
    }

    public DatabaseSnapshot createSnapshot(DatabaseObject[] examples, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        DatabaseConnection conn = database.getConnection();
        if (conn == null) {
            return new EmptyDatabaseSnapshot(database, snapshotControl);
        }
        if (conn instanceof OfflineConnection) {
            DatabaseSnapshot snapshot = ((OfflineConnection)conn).getSnapshot(examples);
            if (snapshot == null) {
                throw new DatabaseException("No snapshotFile parameter specified for offline database");
            }
            return snapshot;
        }
        return new DmJdbcDatabaseSnapshot(examples, database, snapshotControl);
    }

    public static class UserEntityImpl
    implements User {
        private String id;
        private String firstName;
        private String lastName;
        private String displayName;
        private String email;
        private String password;
        private String tenantId;
        private Boolean pictureSet = false;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public boolean isPictureSet() {
            return this.pictureSet;
        }
    }
}

