CREATE SEQUENCE "ACT_HI_TASK_EVT_LOG_SEQ"
INCREMENT BY 1
START WITH 2
MAXVALUE 9223372036854775807
MINVALUE 1;

CREATE SEQUENCE "ACT_EVT_LOG_SEQ"
INCREMENT BY 1
START WITH 2
MAXVALUE 9223372036854775807
MINVALUE 1;

CREATE TABLE "FLW_RU_BATCH_PART"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "BATCH_ID_" NVARCHAR2 NULL,
 "TYPE_" NVARCHAR2 NOT NULL,
 "SCOPE_ID_" NVARCHAR2 NULL,
 "SUB_SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "SEARCH_KEY_" NVARCHAR2 NULL,
 "SEARCH_KEY2_" NVARCHAR2 NULL,
 "CREATE_TIME_" TIMESTAMP(6) NOT NULL,
 "COMPLETE_TIME_" TIMESTAMP(6) NULL,
 "STATUS_" NVARCHAR2 NULL,
 "RESULT_DOC_ID_" NVARCHAR2 NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "FLW_RU_BATCH"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "TYPE_" NVARCHAR2 NOT NULL,
 "SEARCH_KEY_" NVARCHAR2 NULL,
 "SEARCH_KEY2_" NVARCHAR2 NULL,
 "CREATE_TIME_" TIMESTAMP(6) NOT NULL,
 "COMPLETE_TIME_" TIMESTAMP(6) NULL,
 "STATUS_" NVARCHAR2 NULL,
 "BATCH_DOC_ID_" NVARCHAR2 NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "FLW_EV_DATABASECHANGELOGLOCK"
(
 "ID" INTEGER NOT NULL,
 "LOCKED" NUMBER(1,0) NOT NULL,
 "LOCKGRANTED" TIMESTAMP(6) NULL,
 "LOCKEDBY" VARCHAR2(255) NULL,
   CONSTRAINT "PK_FLW_EV_DATABASECHANGELOGLOC"  CLUSTER PRIMARY KEY("ID") ENABLE 
);

CREATE TABLE "FLW_EV_DATABASECHANGELOG"
(
 "ID" VARCHAR2(255) NOT NULL,
 "AUTHOR" VARCHAR2(255) NOT NULL,
 "FILENAME" VARCHAR2(255) NOT NULL,
 "DATEEXECUTED" TIMESTAMP(6) NOT NULL,
 "ORDEREXECUTED" INTEGER NOT NULL,
 "EXECTYPE" VARCHAR2(10) NOT NULL,
 "MD5SUM" VARCHAR2(35) NULL,
 "DESCRIPTION" VARCHAR2(255) NULL,
 "COMMENTS" VARCHAR2(255) NULL,
 "TAG" VARCHAR2(255) NULL,
 "LIQUIBASE" VARCHAR2(20) NULL,
 "CONTEXTS" VARCHAR2(255) NULL,
 "LABELS" VARCHAR2(255) NULL,
 "DEPLOYMENT_ID" VARCHAR2(10) NULL
);

CREATE TABLE "FLW_EVENT_RESOURCE"
(
 "ID_" VARCHAR2(255) NOT NULL,
 "NAME_" VARCHAR2(255) NULL,
 "DEPLOYMENT_ID_" VARCHAR2(255) NULL,
 "RESOURCE_BYTES_" BLOB NULL
);

CREATE TABLE "FLW_EVENT_DEPLOYMENT"
(
 "ID_" VARCHAR2(255) NOT NULL,
 "NAME_" VARCHAR2(255) NULL,
 "CATEGORY_" VARCHAR2(255) NULL,
 "DEPLOY_TIME_" TIMESTAMP(3) NULL,
 "TENANT_ID_" VARCHAR2(255) NULL,
 "PARENT_DEPLOYMENT_ID_" VARCHAR2(255) NULL,
   CONSTRAINT "PK_FLW_EVENT_DEPLOYMENT"  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "FLW_EVENT_DEFINITION"
(
 "ID_" VARCHAR2(255) NOT NULL,
 "NAME_" VARCHAR2(255) NULL,
 "VERSION_" INTEGER NULL,
 "KEY_" VARCHAR2(255) NULL,
 "CATEGORY_" VARCHAR2(255) NULL,
 "DEPLOYMENT_ID_" VARCHAR2(255) NULL,
 "TENANT_ID_" VARCHAR2(255) NULL,
 "RESOURCE_NAME_" VARCHAR2(255) NULL,
 "DESCRIPTION_" VARCHAR2(255) NULL,
   CONSTRAINT "PK_FLW_EVENT_DEFINITION"  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "FLW_CHANNEL_DEFINITION"
(
 "ID_" VARCHAR2(255) NOT NULL,
 "NAME_" VARCHAR2(255) NULL,
 "VERSION_" INTEGER NULL,
 "KEY_" VARCHAR2(255) NULL,
 "CATEGORY_" VARCHAR2(255) NULL,
 "DEPLOYMENT_ID_" VARCHAR2(255) NULL,
 "CREATE_TIME_" TIMESTAMP(3) NULL,
 "TENANT_ID_" VARCHAR2(255) NULL,
 "RESOURCE_NAME_" VARCHAR2(255) NULL,
 "DESCRIPTION_" VARCHAR2(255) NULL,
   CONSTRAINT "PK_FLW_CHANNEL_DEFINITION"  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_RU_VARIABLE"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "TYPE_" NVARCHAR2 NOT NULL,
 "NAME_" NVARCHAR2 NOT NULL,
 "EXECUTION_ID_" NVARCHAR2 NULL,
 "PROC_INST_ID_" NVARCHAR2 NULL,
 "TASK_ID_" NVARCHAR2 NULL,
 "SCOPE_ID_" NVARCHAR2 NULL,
 "SUB_SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "BYTEARRAY_ID_" NVARCHAR2 NULL,
 "DOUBLE_" NUMBER(38,10) NULL,
 "LONG_" NUMBER(19,0) NULL,
 "TEXT_" NVARCHAR2 NULL,
 "TEXT2_" NVARCHAR2 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_RU_TIMER_JOB"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "TYPE_" NVARCHAR2 NOT NULL,
 "LOCK_EXP_TIME_" TIMESTAMP(6) NULL,
 "LOCK_OWNER_" NVARCHAR2 NULL,
 "EXCLUSIVE_" NUMBER(1,0) NULL,
 "EXECUTION_ID_" NVARCHAR2 NULL,
 "PROCESS_INSTANCE_ID_" NVARCHAR2 NULL,
 "PROC_DEF_ID_" NVARCHAR2 NULL,
 "ELEMENT_ID_" NVARCHAR2 NULL,
 "ELEMENT_NAME_" NVARCHAR2 NULL,
 "SCOPE_ID_" NVARCHAR2 NULL,
 "SUB_SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "SCOPE_DEFINITION_ID_" NVARCHAR2 NULL,
 "RETRIES_" INTEGER NULL,
 "EXCEPTION_STACK_ID_" NVARCHAR2 NULL,
 "EXCEPTION_MSG_" NVARCHAR2 NULL,
 "DUEDATE_" TIMESTAMP(6) NULL,
 "REPEAT_" NVARCHAR2 NULL,
 "HANDLER_TYPE_" NVARCHAR2 NULL,
 "HANDLER_CFG_" NVARCHAR2 NULL,
 "CUSTOM_VALUES_ID_" NVARCHAR2 NULL,
 "CREATE_TIME_" TIMESTAMP(6) NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_RU_TASK"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "EXECUTION_ID_" NVARCHAR2 NULL,
 "PROC_INST_ID_" NVARCHAR2 NULL,
 "PROC_DEF_ID_" NVARCHAR2 NULL,
 "TASK_DEF_ID_" NVARCHAR2 NULL,
 "SCOPE_ID_" NVARCHAR2 NULL,
 "SUB_SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "SCOPE_DEFINITION_ID_" NVARCHAR2 NULL,
 "PROPAGATED_STAGE_INST_ID_" NVARCHAR2 NULL,
 "NAME_" NVARCHAR2 NULL,
 "PARENT_TASK_ID_" NVARCHAR2 NULL,
 "DESCRIPTION_" NVARCHAR2 NULL,
 "TASK_DEF_KEY_" NVARCHAR2 NULL,
 "OWNER_" NVARCHAR2 NULL,
 "ASSIGNEE_" NVARCHAR2 NULL,
 "DELEGATION_" NVARCHAR2 NULL,
 "PRIORITY_" INTEGER NULL,
 "CREATE_TIME_" TIMESTAMP(6) NULL,
 "DUE_DATE_" TIMESTAMP(6) NULL,
 "CATEGORY_" NVARCHAR2 NULL,
 "SUSPENSION_STATE_" INTEGER NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
 "FORM_KEY_" NVARCHAR2 NULL,
 "CLAIM_TIME_" TIMESTAMP(6) NULL,
 "IS_COUNT_ENABLED_" NUMBER(1,0) NULL,
 "VAR_COUNT_" INTEGER NULL,
 "ID_LINK_COUNT_" INTEGER NULL,
 "SUB_TASK_COUNT_" INTEGER NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_RU_SUSPENDED_JOB"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "TYPE_" NVARCHAR2 NOT NULL,
 "EXCLUSIVE_" NUMBER(1,0) NULL,
 "EXECUTION_ID_" NVARCHAR2 NULL,
 "PROCESS_INSTANCE_ID_" NVARCHAR2 NULL,
 "PROC_DEF_ID_" NVARCHAR2 NULL,
 "ELEMENT_ID_" NVARCHAR2 NULL,
 "ELEMENT_NAME_" NVARCHAR2 NULL,
 "SCOPE_ID_" NVARCHAR2 NULL,
 "SUB_SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "SCOPE_DEFINITION_ID_" NVARCHAR2 NULL,
 "RETRIES_" INTEGER NULL,
 "EXCEPTION_STACK_ID_" NVARCHAR2 NULL,
 "EXCEPTION_MSG_" NVARCHAR2 NULL,
 "DUEDATE_" TIMESTAMP(6) NULL,
 "REPEAT_" NVARCHAR2 NULL,
 "HANDLER_TYPE_" NVARCHAR2 NULL,
 "HANDLER_CFG_" NVARCHAR2 NULL,
 "CUSTOM_VALUES_ID_" NVARCHAR2 NULL,
 "CREATE_TIME_" TIMESTAMP(6) NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_RU_JOB"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "TYPE_" NVARCHAR2 NOT NULL,
 "LOCK_EXP_TIME_" TIMESTAMP(6) NULL,
 "LOCK_OWNER_" NVARCHAR2 NULL,
 "EXCLUSIVE_" NUMBER(1,0) NULL,
 "EXECUTION_ID_" NVARCHAR2 NULL,
 "PROCESS_INSTANCE_ID_" NVARCHAR2 NULL,
 "PROC_DEF_ID_" NVARCHAR2 NULL,
 "ELEMENT_ID_" NVARCHAR2 NULL,
 "ELEMENT_NAME_" NVARCHAR2 NULL,
 "SCOPE_ID_" NVARCHAR2 NULL,
 "SUB_SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "SCOPE_DEFINITION_ID_" NVARCHAR2 NULL,
 "RETRIES_" INTEGER NULL,
 "EXCEPTION_STACK_ID_" NVARCHAR2 NULL,
 "EXCEPTION_MSG_" NVARCHAR2 NULL,
 "DUEDATE_" TIMESTAMP(6) NULL,
 "REPEAT_" NVARCHAR2 NULL,
 "HANDLER_TYPE_" NVARCHAR2 NULL,
 "HANDLER_CFG_" NVARCHAR2 NULL,
 "CUSTOM_VALUES_ID_" NVARCHAR2 NULL,
 "CREATE_TIME_" TIMESTAMP(6) NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_RU_IDENTITYLINK"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "GROUP_ID_" NVARCHAR2 NULL,
 "TYPE_" NVARCHAR2 NULL,
 "USER_ID_" NVARCHAR2 NULL,
 "TASK_ID_" NVARCHAR2 NULL,
 "PROC_INST_ID_" NVARCHAR2 NULL,
 "PROC_DEF_ID_" NVARCHAR2 NULL,
 "SCOPE_ID_" NVARCHAR2 NULL,
 "SUB_SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "SCOPE_DEFINITION_ID_" NVARCHAR2 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_RU_HISTORY_JOB"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "LOCK_EXP_TIME_" TIMESTAMP(6) NULL,
 "LOCK_OWNER_" NVARCHAR2 NULL,
 "RETRIES_" INTEGER NULL,
 "EXCEPTION_STACK_ID_" NVARCHAR2 NULL,
 "EXCEPTION_MSG_" NVARCHAR2 NULL,
 "HANDLER_TYPE_" NVARCHAR2 NULL,
 "HANDLER_CFG_" NVARCHAR2 NULL,
 "CUSTOM_VALUES_ID_" NVARCHAR2 NULL,
 "ADV_HANDLER_CFG_ID_" NVARCHAR2 NULL,
 "CREATE_TIME_" TIMESTAMP(6) NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_RU_EXECUTION"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "PROC_INST_ID_" NVARCHAR2 NULL,
 "BUSINESS_KEY_" NVARCHAR2 NULL,
 "PARENT_ID_" NVARCHAR2 NULL,
 "PROC_DEF_ID_" NVARCHAR2 NULL,
 "SUPER_EXEC_" NVARCHAR2 NULL,
 "ROOT_PROC_INST_ID_" NVARCHAR2 NULL,
 "ACT_ID_" NVARCHAR2 NULL,
 "IS_ACTIVE_" NUMBER(1,0) NULL,
 "IS_CONCURRENT_" NUMBER(1,0) NULL,
 "IS_SCOPE_" NUMBER(1,0) NULL,
 "IS_EVENT_SCOPE_" NUMBER(1,0) NULL,
 "IS_MI_ROOT_" NUMBER(1,0) NULL,
 "SUSPENSION_STATE_" INTEGER NULL,
 "CACHED_ENT_STATE_" INTEGER NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
 "NAME_" NVARCHAR2 NULL,
 "START_ACT_ID_" NVARCHAR2 NULL,
 "START_TIME_" TIMESTAMP(6) NULL,
 "START_USER_ID_" NVARCHAR2 NULL,
 "LOCK_TIME_" TIMESTAMP(6) NULL,
 "IS_COUNT_ENABLED_" NUMBER(1,0) NULL,
 "EVT_SUBSCR_COUNT_" INTEGER NULL,
 "TASK_COUNT_" INTEGER NULL,
 "JOB_COUNT_" INTEGER NULL,
 "TIMER_JOB_COUNT_" INTEGER NULL,
 "SUSP_JOB_COUNT_" INTEGER NULL,
 "DEADLETTER_JOB_COUNT_" INTEGER NULL,
 "VAR_COUNT_" INTEGER NULL,
 "ID_LINK_COUNT_" INTEGER NULL,
 "CALLBACK_ID_" NVARCHAR2 NULL,
 "CALLBACK_TYPE_" NVARCHAR2 NULL,
 "REFERENCE_ID_" NVARCHAR2 NULL,
 "REFERENCE_TYPE_" NVARCHAR2 NULL,
 "PROPAGATED_STAGE_INST_ID_" NVARCHAR2 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_RU_EVENT_SUBSCR"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "EVENT_TYPE_" NVARCHAR2 NOT NULL,
 "EVENT_NAME_" NVARCHAR2 NULL,
 "EXECUTION_ID_" NVARCHAR2 NULL,
 "PROC_INST_ID_" NVARCHAR2 NULL,
 "ACTIVITY_ID_" NVARCHAR2 NULL,
 "CONFIGURATION_" NVARCHAR2 NULL,
 "CREATED_" TIMESTAMP(6) NOT NULL,
 "PROC_DEF_ID_" NVARCHAR2 NULL,
 "SUB_SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_DEFINITION_ID_" NVARCHAR2 NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_RU_ENTITYLINK"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "CREATE_TIME_" TIMESTAMP(6) NULL,
 "LINK_TYPE_" NVARCHAR2 NULL,
 "SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "SCOPE_DEFINITION_ID_" NVARCHAR2 NULL,
 "REF_SCOPE_ID_" NVARCHAR2 NULL,
 "REF_SCOPE_TYPE_" NVARCHAR2 NULL,
 "REF_SCOPE_DEFINITION_ID_" NVARCHAR2 NULL,
 "HIERARCHY_TYPE_" NVARCHAR2 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_RU_DEADLETTER_JOB"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "TYPE_" NVARCHAR2 NOT NULL,
 "EXCLUSIVE_" NUMBER(1,0) NULL,
 "EXECUTION_ID_" NVARCHAR2 NULL,
 "PROCESS_INSTANCE_ID_" NVARCHAR2 NULL,
 "PROC_DEF_ID_" NVARCHAR2 NULL,
 "ELEMENT_ID_" NVARCHAR2 NULL,
 "ELEMENT_NAME_" NVARCHAR2 NULL,
 "SCOPE_ID_" NVARCHAR2 NULL,
 "SUB_SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "SCOPE_DEFINITION_ID_" NVARCHAR2 NULL,
 "EXCEPTION_STACK_ID_" NVARCHAR2 NULL,
 "EXCEPTION_MSG_" NVARCHAR2 NULL,
 "DUEDATE_" TIMESTAMP(6) NULL,
 "REPEAT_" NVARCHAR2 NULL,
 "HANDLER_TYPE_" NVARCHAR2 NULL,
 "HANDLER_CFG_" NVARCHAR2 NULL,
 "CUSTOM_VALUES_ID_" NVARCHAR2 NULL,
 "CREATE_TIME_" TIMESTAMP(6) NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_RU_ACTINST"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER DEFAULT 1
 NULL,
 "PROC_DEF_ID_" NVARCHAR2 NOT NULL,
 "PROC_INST_ID_" NVARCHAR2 NOT NULL,
 "EXECUTION_ID_" NVARCHAR2 NOT NULL,
 "ACT_ID_" NVARCHAR2 NOT NULL,
 "TASK_ID_" NVARCHAR2 NULL,
 "CALL_PROC_INST_ID_" NVARCHAR2 NULL,
 "ACT_NAME_" NVARCHAR2 NULL,
 "ACT_TYPE_" NVARCHAR2 NOT NULL,
 "ASSIGNEE_" NVARCHAR2 NULL,
 "START_TIME_" TIMESTAMP(6) NOT NULL,
 "END_TIME_" TIMESTAMP(6) NULL,
 "DURATION_" NUMBER(19,0) NULL,
 "DELETE_REASON_" NVARCHAR2 NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_RE_PROCDEF"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "CATEGORY_" NVARCHAR2 NULL,
 "NAME_" NVARCHAR2 NULL,
 "KEY_" NVARCHAR2 NOT NULL,
 "VERSION_" INTEGER NOT NULL,
 "DEPLOYMENT_ID_" NVARCHAR2 NULL,
 "RESOURCE_NAME_" NVARCHAR2 NULL,
 "DGRM_RESOURCE_NAME_" VARCHAR(4000) NULL,
 "DESCRIPTION_" NVARCHAR2 NULL,
 "HAS_START_FORM_KEY_" NUMBER(1,0) NULL,
 "HAS_GRAPHICAL_NOTATION_" NUMBER(1,0) NULL,
 "SUSPENSION_STATE_" INTEGER NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
 "DERIVED_FROM_" NVARCHAR2 NULL,
 "DERIVED_FROM_ROOT_" NVARCHAR2 NULL,
 "DERIVED_VERSION_" INTEGER DEFAULT 0
 NOT NULL,
 "ENGINE_VERSION_" NVARCHAR2 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_RE_MODEL"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "NAME_" NVARCHAR2 NULL,
 "KEY_" NVARCHAR2 NULL,
 "CATEGORY_" NVARCHAR2 NULL,
 "CREATE_TIME_" TIMESTAMP(6) NULL,
 "LAST_UPDATE_TIME_" TIMESTAMP(6) NULL,
 "VERSION_" INTEGER NULL,
 "META_INFO_" NVARCHAR2 NULL,
 "DEPLOYMENT_ID_" NVARCHAR2 NULL,
 "EDITOR_SOURCE_VALUE_ID_" NVARCHAR2 NULL,
 "EDITOR_SOURCE_EXTRA_VALUE_ID_" NVARCHAR2 NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_RE_DEPLOYMENT"
(
 "ID_" NVARCHAR2 NOT NULL,
 "NAME_" NVARCHAR2 NULL,
 "CATEGORY_" NVARCHAR2 NULL,
 "KEY_" NVARCHAR2 NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
 "DEPLOY_TIME_" TIMESTAMP(6) NULL,
 "DERIVED_FROM_" NVARCHAR2 NULL,
 "DERIVED_FROM_ROOT_" NVARCHAR2 NULL,
 "PARENT_DEPLOYMENT_ID_" NVARCHAR2 NULL,
 "ENGINE_VERSION_" NVARCHAR2 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_PROCDEF_INFO"
(
 "ID_" NVARCHAR2 NOT NULL,
 "PROC_DEF_ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "INFO_JSON_ID_" NVARCHAR2 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_ID_USER"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "FIRST_" NVARCHAR2 NULL,
 "LAST_" NVARCHAR2 NULL,
 "DISPLAY_NAME_" NVARCHAR2 NULL,
 "EMAIL_" NVARCHAR2 NULL,
 "PWD_" NVARCHAR2 NULL,
 "PICTURE_ID_" NVARCHAR2 NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_ID_TOKEN"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "TOKEN_VALUE_" NVARCHAR2 NULL,
 "TOKEN_DATE_" TIMESTAMP(6) NULL,
 "IP_ADDRESS_" NVARCHAR2 NULL,
 "USER_AGENT_" NVARCHAR2 NULL,
 "USER_ID_" NVARCHAR2 NULL,
 "TOKEN_DATA_" NVARCHAR2 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_ID_PROPERTY"
(
 "NAME_" NVARCHAR2 NOT NULL,
 "VALUE_" NVARCHAR2 NULL,
 "REV_" INTEGER NULL,
  CLUSTER PRIMARY KEY("NAME_") ENABLE 
);

CREATE TABLE "ACT_ID_PRIV_MAPPING"
(
 "ID_" NVARCHAR2 NOT NULL,
 "PRIV_ID_" NVARCHAR2 NOT NULL,
 "USER_ID_" NVARCHAR2 NULL,
 "GROUP_ID_" NVARCHAR2 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_ID_PRIV"
(
 "ID_" NVARCHAR2 NOT NULL,
 "NAME_" NVARCHAR2 NOT NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_ID_MEMBERSHIP"
(
 "USER_ID_" NVARCHAR2 NOT NULL,
 "GROUP_ID_" NVARCHAR2 NOT NULL,
  CLUSTER PRIMARY KEY("USER_ID_","GROUP_ID_") ENABLE 
);

CREATE TABLE "ACT_ID_INFO"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "USER_ID_" NVARCHAR2 NULL,
 "TYPE_" NVARCHAR2 NULL,
 "KEY_" NVARCHAR2 NULL,
 "VALUE_" NVARCHAR2 NULL,
 "PASSWORD_" BLOB NULL,
 "PARENT_ID_" NVARCHAR2 NULL
);

CREATE TABLE "ACT_ID_GROUP"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "NAME_" NVARCHAR2 NULL,
 "TYPE_" NVARCHAR2 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_ID_BYTEARRAY"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "NAME_" NVARCHAR2 NULL,
 "BYTES_" BLOB NULL
);

CREATE TABLE "ACT_HI_VARINST"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER DEFAULT 1
 NULL,
 "PROC_INST_ID_" NVARCHAR2 NULL,
 "EXECUTION_ID_" NVARCHAR2 NULL,
 "TASK_ID_" NVARCHAR2 NULL,
 "NAME_" NVARCHAR2 NOT NULL,
 "VAR_TYPE_" NVARCHAR2 NULL,
 "SCOPE_ID_" NVARCHAR2 NULL,
 "SUB_SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "BYTEARRAY_ID_" NVARCHAR2 NULL,
 "DOUBLE_" NUMBER(38,10) NULL,
 "LONG_" NUMBER(19,0) NULL,
 "TEXT_" NVARCHAR2 NULL,
 "TEXT2_" NVARCHAR2 NULL,
 "CREATE_TIME_" TIMESTAMP(6) NULL,
 "LAST_UPDATED_TIME_" TIMESTAMP(6) NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_HI_TSK_LOG"
(
 "ID_" NUMBER(19,0) NOT NULL,
 "TYPE_" NVARCHAR2 NULL,
 "TASK_ID_" NVARCHAR2 NOT NULL,
 "TIME_STAMP_" TIMESTAMP(6) NOT NULL,
 "USER_ID_" NVARCHAR2 NULL,
 "DATA_" NVARCHAR2 NULL,
 "EXECUTION_ID_" NVARCHAR2 NULL,
 "PROC_INST_ID_" NVARCHAR2 NULL,
 "PROC_DEF_ID_" NVARCHAR2 NULL,
 "SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_DEFINITION_ID_" NVARCHAR2 NULL,
 "SUB_SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_HI_TASKINST"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER DEFAULT 1
 NULL,
 "PROC_DEF_ID_" NVARCHAR2 NULL,
 "TASK_DEF_ID_" NVARCHAR2 NULL,
 "TASK_DEF_KEY_" NVARCHAR2 NULL,
 "PROC_INST_ID_" NVARCHAR2 NULL,
 "EXECUTION_ID_" NVARCHAR2 NULL,
 "SCOPE_ID_" NVARCHAR2 NULL,
 "SUB_SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "SCOPE_DEFINITION_ID_" NVARCHAR2 NULL,
 "PROPAGATED_STAGE_INST_ID_" NVARCHAR2 NULL,
 "PARENT_TASK_ID_" NVARCHAR2 NULL,
 "NAME_" NVARCHAR2 NULL,
 "DESCRIPTION_" NVARCHAR2 NULL,
 "OWNER_" NVARCHAR2 NULL,
 "ASSIGNEE_" NVARCHAR2 NULL,
 "START_TIME_" TIMESTAMP(6) NOT NULL,
 "CLAIM_TIME_" TIMESTAMP(6) NULL,
 "END_TIME_" TIMESTAMP(6) NULL,
 "DURATION_" NUMBER(19,0) NULL,
 "DELETE_REASON_" NVARCHAR2 NULL,
 "PRIORITY_" INTEGER NULL,
 "DUE_DATE_" TIMESTAMP(6) NULL,
 "FORM_KEY_" NVARCHAR2 NULL,
 "CATEGORY_" NVARCHAR2 NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
 "LAST_UPDATED_TIME_" TIMESTAMP(6) NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_HI_PROCINST"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER DEFAULT 1
 NULL,
 "PROC_INST_ID_" NVARCHAR2 NOT NULL,
 "BUSINESS_KEY_" NVARCHAR2 NULL,
 "PROC_DEF_ID_" NVARCHAR2 NOT NULL,
 "START_TIME_" TIMESTAMP(6) NOT NULL,
 "END_TIME_" TIMESTAMP(6) NULL,
 "DURATION_" NUMBER(19,0) NULL,
 "START_USER_ID_" NVARCHAR2 NULL,
 "START_ACT_ID_" NVARCHAR2 NULL,
 "END_ACT_ID_" NVARCHAR2 NULL,
 "SUPER_PROCESS_INSTANCE_ID_" NVARCHAR2 NULL,
 "DELETE_REASON_" NVARCHAR2 NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
 "NAME_" NVARCHAR2 NULL,
 "CALLBACK_ID_" NVARCHAR2 NULL,
 "CALLBACK_TYPE_" NVARCHAR2 NULL,
 "REFERENCE_ID_" NVARCHAR2 NULL,
 "REFERENCE_TYPE_" NVARCHAR2 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_HI_IDENTITYLINK"
(
 "ID_" NVARCHAR2 NOT NULL,
 "GROUP_ID_" NVARCHAR2 NULL,
 "TYPE_" NVARCHAR2 NULL,
 "USER_ID_" NVARCHAR2 NULL,
 "TASK_ID_" NVARCHAR2 NULL,
 "CREATE_TIME_" TIMESTAMP(6) NULL,
 "PROC_INST_ID_" NVARCHAR2 NULL,
 "SCOPE_ID_" NVARCHAR2 NULL,
 "SUB_SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "SCOPE_DEFINITION_ID_" NVARCHAR2 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_HI_ENTITYLINK"
(
 "ID_" NVARCHAR2 NOT NULL,
 "LINK_TYPE_" NVARCHAR2 NULL,
 "CREATE_TIME_" TIMESTAMP(6) NULL,
 "SCOPE_ID_" NVARCHAR2 NULL,
 "SCOPE_TYPE_" NVARCHAR2 NULL,
 "SCOPE_DEFINITION_ID_" NVARCHAR2 NULL,
 "REF_SCOPE_ID_" NVARCHAR2 NULL,
 "REF_SCOPE_TYPE_" NVARCHAR2 NULL,
 "REF_SCOPE_DEFINITION_ID_" NVARCHAR2 NULL,
 "HIERARCHY_TYPE_" NVARCHAR2 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_HI_DETAIL"
(
 "ID_" NVARCHAR2 NOT NULL,
 "TYPE_" NVARCHAR2 NOT NULL,
 "PROC_INST_ID_" NVARCHAR2 NULL,
 "EXECUTION_ID_" NVARCHAR2 NULL,
 "TASK_ID_" NVARCHAR2 NULL,
 "ACT_INST_ID_" NVARCHAR2 NULL,
 "NAME_" NVARCHAR2 NOT NULL,
 "VAR_TYPE_" NVARCHAR2 NULL,
 "REV_" INTEGER NULL,
 "TIME_" TIMESTAMP(6) NOT NULL,
 "BYTEARRAY_ID_" NVARCHAR2 NULL,
 "DOUBLE_" NUMBER(38,10) NULL,
 "LONG_" NUMBER(19,0) NULL,
 "TEXT_" NVARCHAR2 NULL,
 "TEXT2_" NVARCHAR2 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_HI_COMMENT"
(
 "ID_" NVARCHAR2 NOT NULL,
 "TYPE_" NVARCHAR2 NULL,
 "TIME_" TIMESTAMP(6) NOT NULL,
 "USER_ID_" NVARCHAR2 NULL,
 "TASK_ID_" NVARCHAR2 NULL,
 "PROC_INST_ID_" NVARCHAR2 NULL,
 "ACTION_" NVARCHAR2 NULL,
 "MESSAGE_" NVARCHAR2 NULL,
 "FULL_MSG_" BLOB NULL
);

CREATE TABLE "ACT_HI_ATTACHMENT"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "USER_ID_" NVARCHAR2 NULL,
 "NAME_" NVARCHAR2 NULL,
 "DESCRIPTION_" NVARCHAR2 NULL,
 "TYPE_" NVARCHAR2 NULL,
 "TASK_ID_" NVARCHAR2 NULL,
 "PROC_INST_ID_" NVARCHAR2 NULL,
 "URL_" NVARCHAR2 NULL,
 "CONTENT_ID_" NVARCHAR2 NULL,
 "TIME_" TIMESTAMP(6) NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_HI_ACTINST"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER DEFAULT 1
 NULL,
 "PROC_DEF_ID_" NVARCHAR2 NOT NULL,
 "PROC_INST_ID_" NVARCHAR2 NOT NULL,
 "EXECUTION_ID_" NVARCHAR2 NOT NULL,
 "ACT_ID_" NVARCHAR2 NOT NULL,
 "TASK_ID_" NVARCHAR2 NULL,
 "CALL_PROC_INST_ID_" NVARCHAR2 NULL,
 "ACT_NAME_" NVARCHAR2 NULL,
 "ACT_TYPE_" NVARCHAR2 NOT NULL,
 "ASSIGNEE_" NVARCHAR2 NULL,
 "START_TIME_" TIMESTAMP(6) NOT NULL,
 "END_TIME_" TIMESTAMP(6) NULL,
 "DURATION_" NUMBER(19,0) NULL,
 "DELETE_REASON_" NVARCHAR2 NULL,
 "TENANT_ID_" NVARCHAR2 DEFAULT ''
 NULL,
  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_GE_PROPERTY"
(
 "NAME_" NVARCHAR2 NOT NULL,
 "VALUE_" NVARCHAR2 NULL,
 "REV_" INTEGER NULL,
  CLUSTER PRIMARY KEY("NAME_") ENABLE 
);

CREATE TABLE "ACT_GE_BYTEARRAY"
(
 "ID_" NVARCHAR2 NOT NULL,
 "REV_" INTEGER NULL,
 "NAME_" NVARCHAR2 NULL,
 "DEPLOYMENT_ID_" NVARCHAR2 NULL,
 "BYTES_" BLOB NULL,
 "GENERATED_" NUMBER(1,0) NULL
);

CREATE TABLE "ACT_EVT_LOG"
(
 "LOG_NR_" NUMBER(19,0) NOT NULL,
 "TYPE_" NVARCHAR2 NULL,
 "PROC_DEF_ID_" NVARCHAR2 NULL,
 "PROC_INST_ID_" NVARCHAR2 NULL,
 "EXECUTION_ID_" NVARCHAR2 NULL,
 "TASK_ID_" NVARCHAR2 NULL,
 "TIME_STAMP_" TIMESTAMP(6) NOT NULL,
 "USER_ID_" NVARCHAR2 NULL,
 "DATA_" BLOB NULL,
 "LOCK_OWNER_" NVARCHAR2 NULL,
 "LOCK_TIME_" TIMESTAMP(6) NULL,
 "IS_PROCESSED_" NUMBER(3,0) DEFAULT 0
 NULL
);

CREATE TABLE "ACT_DE_MODEL_RELATION"
(
 "ID" VARCHAR2(255) NOT NULL,
 "PARENT_MODEL_ID" VARCHAR2(255) NULL,
 "MODEL_ID" VARCHAR2(255) NULL,
 "RELATION_TYPE" VARCHAR2(255) NULL,
   CONSTRAINT "PK_ACT_DE_MODEL_RELATION"  CLUSTER PRIMARY KEY("ID") ENABLE 
);

CREATE TABLE "ACT_DE_MODEL_HISTORY"
(
 "ID" VARCHAR2(255) NOT NULL,
 "NAME" VARCHAR2(400) NOT NULL,
 "MODEL_KEY" VARCHAR2(400) NOT NULL,
 "DESCRIPTION" VARCHAR2(4000) NULL,
 "MODEL_COMMENT" VARCHAR2(4000) NULL,
 "CREATED" TIMESTAMP(6) NULL,
 "CREATED_BY" VARCHAR2(255) NULL,
 "LAST_UPDATED" TIMESTAMP(6) NULL,
 "LAST_UPDATED_BY" VARCHAR2(255) NULL,
 "REMOVAL_DATE" TIMESTAMP(6) NULL,
 "VERSION" INTEGER NULL,
 "MODEL_EDITOR_JSON" CLOB NULL,
 "MODEL_ID" VARCHAR2(255) NOT NULL,
 "MODEL_TYPE" INTEGER NULL,
 "TENANT_ID" VARCHAR2(255) NULL
);

CREATE TABLE "ACT_DE_MODEL"
(
 "ID" VARCHAR2(255) NOT NULL,
 "NAME" VARCHAR2(400) NOT NULL,
 "MODEL_KEY" VARCHAR2(400) NOT NULL,
 "DESCRIPTION" VARCHAR2(4000) NULL,
 "MODEL_COMMENT" VARCHAR2(4000) NULL,
 "CREATED" TIMESTAMP(6) NULL,
 "CREATED_BY" VARCHAR2(255) NULL,
 "LAST_UPDATED" TIMESTAMP(6) NULL,
 "LAST_UPDATED_BY" VARCHAR2(255) NULL,
 "VERSION" INTEGER NULL,
 "MODEL_EDITOR_JSON" CLOB NULL,
 "THUMBNAIL" BLOB NULL,
 "MODEL_TYPE" INTEGER NULL,
 "TENANT_ID" VARCHAR2(255) NULL
);

CREATE TABLE "ACT_DE_DATABASECHANGELOGLOCK"
(
 "ID" INTEGER NOT NULL,
 "LOCKED" NUMBER(1,0) NOT NULL,
 "LOCKGRANTED" TIMESTAMP(6) NULL,
 "LOCKEDBY" VARCHAR2(255) NULL,
   CONSTRAINT "PK_ACT_DE_DATABASECHANGELOGLOC"  CLUSTER PRIMARY KEY("ID") ENABLE 
);

CREATE TABLE "ACT_DE_DATABASECHANGELOG"
(
 "ID" VARCHAR2(255) NOT NULL,
 "AUTHOR" VARCHAR2(255) NOT NULL,
 "FILENAME" VARCHAR2(255) NOT NULL,
 "DATEEXECUTED" TIMESTAMP(6) NOT NULL,
 "ORDEREXECUTED" INTEGER NOT NULL,
 "EXECTYPE" VARCHAR2(10) NOT NULL,
 "MD5SUM" VARCHAR2(35) NULL,
 "DESCRIPTION" VARCHAR2(255) NULL,
 "COMMENTS" VARCHAR2(255) NULL,
 "TAG" VARCHAR2(255) NULL,
 "LIQUIBASE" VARCHAR2(20) NULL,
 "CONTEXTS" VARCHAR2(255) NULL,
 "LABELS" VARCHAR2(255) NULL,
 "DEPLOYMENT_ID" VARCHAR2(10) NULL
);

CREATE TABLE "ACT_APP_DEPLOYMENT_RESOURCE"
(
 "ID_" VARCHAR2(255) NOT NULL,
 "NAME_" VARCHAR2(255) NULL,
 "DEPLOYMENT_ID_" VARCHAR2(255) NULL,
 "RESOURCE_BYTES_" BLOB NULL
);

CREATE TABLE "ACT_APP_DEPLOYMENT"
(
 "ID_" VARCHAR2(255) NOT NULL,
 "NAME_" VARCHAR2(255) NULL,
 "CATEGORY_" VARCHAR2(255) NULL,
 "KEY_" VARCHAR2(255) NULL,
 "DEPLOY_TIME_" TIMESTAMP(6) NULL,
 "TENANT_ID_" VARCHAR2(255) DEFAULT ''
 NULL,
   CONSTRAINT "PK_ACT_APP_DEPLOYMENT"  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

CREATE TABLE "ACT_APP_DATABASECHANGELOGLOCK"
(
 "ID" INTEGER NOT NULL,
 "LOCKED" NUMBER(1,0) NOT NULL,
 "LOCKGRANTED" TIMESTAMP(6) NULL,
 "LOCKEDBY" VARCHAR2(255) NULL,
   CONSTRAINT "PK_ACT_APP_DATABASECHANGELOGLO"  CLUSTER PRIMARY KEY("ID") ENABLE 
);

CREATE TABLE "ACT_APP_DATABASECHANGELOG"
(
 "ID" VARCHAR2(255) NOT NULL,
 "AUTHOR" VARCHAR2(255) NOT NULL,
 "FILENAME" VARCHAR2(255) NOT NULL,
 "DATEEXECUTED" TIMESTAMP(6) NOT NULL,
 "ORDEREXECUTED" INTEGER NOT NULL,
 "EXECTYPE" VARCHAR2(10) NOT NULL,
 "MD5SUM" VARCHAR2(35) NULL,
 "DESCRIPTION" VARCHAR2(255) NULL,
 "COMMENTS" VARCHAR2(255) NULL,
 "TAG" VARCHAR2(255) NULL,
 "LIQUIBASE" VARCHAR2(20) NULL,
 "CONTEXTS" VARCHAR2(255) NULL,
 "LABELS" VARCHAR2(255) NULL,
 "DEPLOYMENT_ID" VARCHAR2(10) NULL
);

CREATE TABLE "ACT_APP_APPDEF"
(
 "ID_" VARCHAR2(255) NOT NULL,
 "REV_" INTEGER NOT NULL,
 "NAME_" VARCHAR2(255) NULL,
 "KEY_" VARCHAR2(255) NOT NULL,
 "VERSION_" INTEGER NOT NULL,
 "CATEGORY_" VARCHAR2(255) NULL,
 "DEPLOYMENT_ID_" VARCHAR2(255) NULL,
 "RESOURCE_NAME_" VARCHAR2(4000) NULL,
 "DESCRIPTION_" VARCHAR2(4000) NULL,
 "TENANT_ID_" VARCHAR2(255) DEFAULT ''
 NULL,
   CONSTRAINT "PK_ACT_APP_APPDEF"  CLUSTER PRIMARY KEY("ID_") ENABLE 
);

ALTER TABLE "FLW_RU_BATCH_PART" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "FLW_RU_BATCH" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "FLW_EV_DATABASECHANGELOGLOCK" ADD CONSTRAINT "PK_FLW_EV_DATABASECHANGELOGLOC" CLUSTER  PRIMARY KEY("ID") ENABLE ;

ALTER TABLE "FLW_EVENT_RESOURCE" ADD CONSTRAINT "PK_FLW_EVENT_RESOURCE" PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "FLW_EVENT_DEPLOYMENT" ADD CONSTRAINT "PK_FLW_EVENT_DEPLOYMENT" CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "FLW_EVENT_DEFINITION" ADD CONSTRAINT "PK_FLW_EVENT_DEFINITION" CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "FLW_CHANNEL_DEFINITION" ADD CONSTRAINT "PK_FLW_CHANNEL_DEFINITION" CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_RU_VARIABLE" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_RU_TIMER_JOB" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_RU_TASK" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_RU_SUSPENDED_JOB" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_RU_JOB" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_RU_IDENTITYLINK" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_RU_HISTORY_JOB" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_RU_EXECUTION" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_RU_EVENT_SUBSCR" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_RU_ENTITYLINK" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_RU_DEADLETTER_JOB" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_RU_ACTINST" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_RE_PROCDEF" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_RE_PROCDEF" ADD CONSTRAINT "ACT_UNIQ_PROCDEF" UNIQUE("KEY_","VERSION_","DERIVED_VERSION_","TENANT_ID_") ENABLE ;

ALTER TABLE "ACT_RE_MODEL" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_RE_DEPLOYMENT" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_PROCDEF_INFO" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_PROCDEF_INFO" ADD CONSTRAINT "ACT_UNIQ_INFO_PROCDEF" UNIQUE("PROC_DEF_ID_") ENABLE ;

ALTER TABLE "ACT_ID_USER" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_ID_TOKEN" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_ID_PROPERTY" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("NAME_") ENABLE ;

ALTER TABLE "ACT_ID_PRIV_MAPPING" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_ID_PRIV" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_ID_PRIV" ADD CONSTRAINT "ACT_UNIQ_PRIV_NAME" UNIQUE("NAME_") ENABLE ;

ALTER TABLE "ACT_ID_MEMBERSHIP" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("USER_ID_","GROUP_ID_") ENABLE ;

ALTER TABLE "ACT_ID_INFO" ADD CONSTRAINT  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_ID_GROUP" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_ID_BYTEARRAY" ADD CONSTRAINT  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_HI_VARINST" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_HI_TSK_LOG" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_HI_TASKINST" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_HI_PROCINST" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_HI_PROCINST" ADD CONSTRAINT "CONS134230712" UNIQUE("PROC_INST_ID_") ENABLE ;

ALTER TABLE "ACT_HI_IDENTITYLINK" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_HI_ENTITYLINK" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_HI_DETAIL" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_HI_COMMENT" ADD CONSTRAINT  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_HI_ATTACHMENT" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_HI_ACTINST" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_GE_PROPERTY" ADD CONSTRAINT  CLUSTER  PRIMARY KEY("NAME_") ENABLE ;

ALTER TABLE "ACT_GE_BYTEARRAY" ADD CONSTRAINT  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_EVT_LOG" ADD CONSTRAINT  PRIMARY KEY("LOG_NR_") ENABLE ;

ALTER TABLE "ACT_DE_MODEL_RELATION" ADD CONSTRAINT "PK_ACT_DE_MODEL_RELATION" CLUSTER  PRIMARY KEY("ID") ENABLE ;

ALTER TABLE "ACT_DE_MODEL_HISTORY" ADD CONSTRAINT "PK_ACT_DE_MODEL_HISTORY" PRIMARY KEY("ID") ENABLE ;

ALTER TABLE "ACT_DE_MODEL" ADD CONSTRAINT "PK_ACT_DE_MODEL" PRIMARY KEY("ID") ENABLE ;

ALTER TABLE "ACT_DE_DATABASECHANGELOGLOCK" ADD CONSTRAINT "PK_ACT_DE_DATABASECHANGELOGLOC" CLUSTER  PRIMARY KEY("ID") ENABLE ;

ALTER TABLE "ACT_APP_DEPLOYMENT_RESOURCE" ADD CONSTRAINT "PK_APP_DEPLOYMENT_RESOURCE" PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_APP_DEPLOYMENT" ADD CONSTRAINT "PK_ACT_APP_DEPLOYMENT" CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "ACT_APP_DATABASECHANGELOGLOCK" ADD CONSTRAINT "PK_ACT_APP_DATABASECHANGELOGLO" CLUSTER  PRIMARY KEY("ID") ENABLE ;

ALTER TABLE "ACT_APP_APPDEF" ADD CONSTRAINT "PK_ACT_APP_APPDEF" CLUSTER  PRIMARY KEY("ID_") ENABLE ;

ALTER TABLE "FLW_RU_BATCH_PART" ADD CONSTRAINT "FLW_FK_BATCH_PART_PARENT" FOREIGN KEY("BATCH_ID_") REFERENCES "FLW_RU_BATCH"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_VARIABLE" ADD CONSTRAINT "ACT_FK_VAR_EXE" FOREIGN KEY("EXECUTION_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_VARIABLE" ADD CONSTRAINT "ACT_FK_VAR_PROCINST" FOREIGN KEY("PROC_INST_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_VARIABLE" ADD CONSTRAINT "ACT_FK_VAR_BYTEARRAY" FOREIGN KEY("BYTEARRAY_ID_") REFERENCES "ACT_GE_BYTEARRAY"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_TIMER_JOB" ADD CONSTRAINT "ACT_FK_TJOB_PROC_DEF" FOREIGN KEY("PROC_DEF_ID_") REFERENCES "ACT_RE_PROCDEF"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_TIMER_JOB" ADD CONSTRAINT "ACT_FK_TJOB_EXECUTION" FOREIGN KEY("EXECUTION_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_TIMER_JOB" ADD CONSTRAINT "ACT_FK_TJOB_PROCESS_INSTANCE" FOREIGN KEY("PROCESS_INSTANCE_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_TIMER_JOB" ADD CONSTRAINT "ACT_FK_TJOB_EXCEPTION" FOREIGN KEY("EXCEPTION_STACK_ID_") REFERENCES "ACT_GE_BYTEARRAY"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_TIMER_JOB" ADD CONSTRAINT "ACT_FK_TJOB_CUSTOM_VAL" FOREIGN KEY("CUSTOM_VALUES_ID_") REFERENCES "ACT_GE_BYTEARRAY"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_TASK" ADD CONSTRAINT "ACT_FK_TASK_PROCDEF" FOREIGN KEY("PROC_DEF_ID_") REFERENCES "ACT_RE_PROCDEF"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_TASK" ADD CONSTRAINT "ACT_FK_TASK_PROCINST" FOREIGN KEY("PROC_INST_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_TASK" ADD CONSTRAINT "ACT_FK_TASK_EXE" FOREIGN KEY("EXECUTION_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_SUSPENDED_JOB" ADD CONSTRAINT "ACT_FK_SJOB_CUSTOM_VAL" FOREIGN KEY("CUSTOM_VALUES_ID_") REFERENCES "ACT_GE_BYTEARRAY"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_SUSPENDED_JOB" ADD CONSTRAINT "ACT_FK_SJOB_EXCEPTION" FOREIGN KEY("EXCEPTION_STACK_ID_") REFERENCES "ACT_GE_BYTEARRAY"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_SUSPENDED_JOB" ADD CONSTRAINT "ACT_FK_SJOB_EXECUTION" FOREIGN KEY("EXECUTION_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_SUSPENDED_JOB" ADD CONSTRAINT "ACT_FK_SJOB_PROC_DEF" FOREIGN KEY("PROC_DEF_ID_") REFERENCES "ACT_RE_PROCDEF"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_SUSPENDED_JOB" ADD CONSTRAINT "ACT_FK_SJOB_PROCESS_INSTANCE" FOREIGN KEY("PROCESS_INSTANCE_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_JOB" ADD CONSTRAINT "ACT_FK_JOB_EXCEPTION" FOREIGN KEY("EXCEPTION_STACK_ID_") REFERENCES "ACT_GE_BYTEARRAY"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_JOB" ADD CONSTRAINT "ACT_FK_JOB_PROC_DEF" FOREIGN KEY("PROC_DEF_ID_") REFERENCES "ACT_RE_PROCDEF"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_JOB" ADD CONSTRAINT "ACT_FK_JOB_CUSTOM_VAL" FOREIGN KEY("CUSTOM_VALUES_ID_") REFERENCES "ACT_GE_BYTEARRAY"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_JOB" ADD CONSTRAINT "ACT_FK_JOB_PROCESS_INSTANCE" FOREIGN KEY("PROCESS_INSTANCE_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_JOB" ADD CONSTRAINT "ACT_FK_JOB_EXECUTION" FOREIGN KEY("EXECUTION_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_IDENTITYLINK" ADD CONSTRAINT "ACT_FK_IDL_PROCINST" FOREIGN KEY("PROC_INST_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_IDENTITYLINK" ADD CONSTRAINT "ACT_FK_TSKASS_TASK" FOREIGN KEY("TASK_ID_") REFERENCES "ACT_RU_TASK"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_IDENTITYLINK" ADD CONSTRAINT "ACT_FK_ATHRZ_PROCEDEF" FOREIGN KEY("PROC_DEF_ID_") REFERENCES "ACT_RE_PROCDEF"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_EXECUTION" ADD CONSTRAINT "ACT_FK_EXE_PARENT" FOREIGN KEY("PARENT_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") with index ENABLE ;

ALTER TABLE "ACT_RU_EXECUTION" ADD CONSTRAINT "ACT_FK_EXE_SUPER" FOREIGN KEY("SUPER_EXEC_") REFERENCES "ACT_RU_EXECUTION"("ID_") with index ENABLE ;

ALTER TABLE "ACT_RU_EXECUTION" ADD CONSTRAINT "ACT_FK_EXE_PROCDEF" FOREIGN KEY("PROC_DEF_ID_") REFERENCES "ACT_RE_PROCDEF"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_EXECUTION" ADD CONSTRAINT "ACT_FK_EXE_PROCINST" FOREIGN KEY("PROC_INST_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") with index ENABLE ;

ALTER TABLE "ACT_RU_EVENT_SUBSCR" ADD CONSTRAINT "ACT_FK_EVENT_EXEC" FOREIGN KEY("EXECUTION_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_DEADLETTER_JOB" ADD CONSTRAINT "ACT_FK_DJOB_EXECUTION" FOREIGN KEY("EXECUTION_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_DEADLETTER_JOB" ADD CONSTRAINT "ACT_FK_DJOB_EXCEPTION" FOREIGN KEY("EXCEPTION_STACK_ID_") REFERENCES "ACT_GE_BYTEARRAY"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_DEADLETTER_JOB" ADD CONSTRAINT "ACT_FK_DJOB_CUSTOM_VAL" FOREIGN KEY("CUSTOM_VALUES_ID_") REFERENCES "ACT_GE_BYTEARRAY"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_DEADLETTER_JOB" ADD CONSTRAINT "ACT_FK_DJOB_PROCESS_INSTANCE" FOREIGN KEY("PROCESS_INSTANCE_ID_") REFERENCES "ACT_RU_EXECUTION"("ID_") ENABLE ;

ALTER TABLE "ACT_RU_DEADLETTER_JOB" ADD CONSTRAINT "ACT_FK_DJOB_PROC_DEF" FOREIGN KEY("PROC_DEF_ID_") REFERENCES "ACT_RE_PROCDEF"("ID_") ENABLE ;

ALTER TABLE "ACT_RE_MODEL" ADD CONSTRAINT "ACT_FK_MODEL_SOURCE" FOREIGN KEY("EDITOR_SOURCE_VALUE_ID_") REFERENCES "ACT_GE_BYTEARRAY"("ID_") ENABLE ;

ALTER TABLE "ACT_RE_MODEL" ADD CONSTRAINT "ACT_FK_MODEL_DEPLOYMENT" FOREIGN KEY("DEPLOYMENT_ID_") REFERENCES "ACT_RE_DEPLOYMENT"("ID_") ENABLE ;

ALTER TABLE "ACT_RE_MODEL" ADD CONSTRAINT "ACT_FK_MODEL_SOURCE_EXTRA" FOREIGN KEY("EDITOR_SOURCE_EXTRA_VALUE_ID_") REFERENCES "ACT_GE_BYTEARRAY"("ID_") ENABLE ;

ALTER TABLE "ACT_PROCDEF_INFO" ADD CONSTRAINT "ACT_FK_INFO_JSON_BA" FOREIGN KEY("INFO_JSON_ID_") REFERENCES "ACT_GE_BYTEARRAY"("ID_") ENABLE ;

ALTER TABLE "ACT_PROCDEF_INFO" ADD CONSTRAINT "ACT_FK_INFO_PROCDEF" FOREIGN KEY("PROC_DEF_ID_") REFERENCES "ACT_RE_PROCDEF"("ID_") ENABLE ;

ALTER TABLE "ACT_ID_PRIV_MAPPING" ADD CONSTRAINT "ACT_FK_PRIV_MAPPING" FOREIGN KEY("PRIV_ID_") REFERENCES "ACT_ID_PRIV"("ID_") ENABLE ;

ALTER TABLE "ACT_ID_MEMBERSHIP" ADD CONSTRAINT "ACT_FK_MEMB_GROUP" FOREIGN KEY("GROUP_ID_") REFERENCES "ACT_ID_GROUP"("ID_") ENABLE ;

ALTER TABLE "ACT_ID_MEMBERSHIP" ADD CONSTRAINT "ACT_FK_MEMB_USER" FOREIGN KEY("USER_ID_") REFERENCES "ACT_ID_USER"("ID_") ENABLE ;

ALTER TABLE "ACT_GE_BYTEARRAY" ADD CONSTRAINT "ACT_FK_BYTEARR_DEPL" FOREIGN KEY("DEPLOYMENT_ID_") REFERENCES "ACT_RE_DEPLOYMENT"("ID_") ENABLE ;

ALTER TABLE "ACT_DE_MODEL_RELATION" ADD CONSTRAINT "FK_RELATION_PARENT" FOREIGN KEY("PARENT_MODEL_ID") REFERENCES "ACT_DE_MODEL"("ID") ENABLE ;

ALTER TABLE "ACT_DE_MODEL_RELATION" ADD CONSTRAINT "FK_RELATION_CHILD" FOREIGN KEY("MODEL_ID") REFERENCES "ACT_DE_MODEL"("ID") ENABLE ;

ALTER TABLE "ACT_APP_DEPLOYMENT_RESOURCE" ADD CONSTRAINT "ACT_FK_APP_RSRC_DPL" FOREIGN KEY("DEPLOYMENT_ID_") REFERENCES "ACT_APP_DEPLOYMENT"("ID_") ENABLE ;

ALTER TABLE "ACT_APP_APPDEF" ADD CONSTRAINT "ACT_FK_APP_DEF_DPLY" FOREIGN KEY("DEPLOYMENT_ID_") REFERENCES "ACT_APP_DEPLOYMENT"("ID_") ENABLE ;

CREATE INDEX "FLW_IDX_BATCH_PART"
ON "FLW_RU_BATCH_PART"("BATCH_ID_");

CREATE UNIQUE INDEX "ACT_IDX_EVENT_DEF_UNIQ"
ON "FLW_EVENT_DEFINITION"("KEY_","VERSION_","TENANT_ID_");

CREATE UNIQUE INDEX "ACT_IDX_CHANNEL_DEF_UNIQ"
ON "FLW_CHANNEL_DEFINITION"("KEY_","VERSION_","TENANT_ID_");

CREATE INDEX "ACT_IDX_VAR_EXE"
ON "ACT_RU_VARIABLE"("EXECUTION_ID_");

CREATE INDEX "ACT_IDX_VARIABLE_TASK_ID"
ON "ACT_RU_VARIABLE"("TASK_ID_");

CREATE INDEX "ACT_IDX_VAR_BYTEARRAY"
ON "ACT_RU_VARIABLE"("BYTEARRAY_ID_");

CREATE INDEX "ACT_IDX_RU_VAR_SUB_ID_TYPE"
ON "ACT_RU_VARIABLE"("SUB_SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_RU_VAR_SCOPE_ID_TYPE"
ON "ACT_RU_VARIABLE"("SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_VAR_PROCINST"
ON "ACT_RU_VARIABLE"("PROC_INST_ID_");

ALTER TABLE "ACT_RU_TIMER_JOB" ADD CHECK ("EXCLUSIVE_" IN (1, 0)) ENABLE ;

CREATE INDEX "ACT_IDX_TJOB_SCOPE_DEF"
ON "ACT_RU_TIMER_JOB"("SCOPE_DEFINITION_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_TJOB_PROC_INST_ID"
ON "ACT_RU_TIMER_JOB"("PROCESS_INSTANCE_ID_");

CREATE INDEX "ACT_IDX_TJOB_SUB_SCOPE"
ON "ACT_RU_TIMER_JOB"("SUB_SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_TJOB_CUSTOM_VAL_ID"
ON "ACT_RU_TIMER_JOB"("CUSTOM_VALUES_ID_");

CREATE INDEX "ACT_IDX_TJOB_EXECUTION_ID"
ON "ACT_RU_TIMER_JOB"("EXECUTION_ID_");

CREATE INDEX "ACT_IDX_TJOB_EXCEPTION"
ON "ACT_RU_TIMER_JOB"("EXCEPTION_STACK_ID_");

CREATE INDEX "ACT_IDX_TJOB_SCOPE"
ON "ACT_RU_TIMER_JOB"("SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_TJOB_PROC_DEF_ID"
ON "ACT_RU_TIMER_JOB"("PROC_DEF_ID_");

ALTER TABLE "ACT_RU_TASK" ADD CHECK ("IS_COUNT_ENABLED_" IN (1, 0)) ENABLE ;

CREATE INDEX "ACT_IDX_TASK_SCOPE"
ON "ACT_RU_TASK"("SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_TASK_SCOPE_DEF"
ON "ACT_RU_TASK"("SCOPE_DEFINITION_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_TASK_PROCDEF"
ON "ACT_RU_TASK"("PROC_DEF_ID_");

CREATE INDEX "ACT_IDX_TASK_CREATE"
ON "ACT_RU_TASK"("CREATE_TIME_");

CREATE INDEX "ACT_IDX_TASK_SUB_SCOPE"
ON "ACT_RU_TASK"("SUB_SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_TASK_EXEC"
ON "ACT_RU_TASK"("EXECUTION_ID_");

CREATE INDEX "ACT_IDX_TASK_PROCINST"
ON "ACT_RU_TASK"("PROC_INST_ID_");

ALTER TABLE "ACT_RU_SUSPENDED_JOB" ADD CHECK ("EXCLUSIVE_" IN (1, 0)) ENABLE ;

CREATE INDEX "ACT_IDX_SJOB_SCOPE_DEF"
ON "ACT_RU_SUSPENDED_JOB"("SCOPE_DEFINITION_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_SJOB_EXCEPTION"
ON "ACT_RU_SUSPENDED_JOB"("EXCEPTION_STACK_ID_");

CREATE INDEX "ACT_IDX_SJOB_CUSTOM_VAL_ID"
ON "ACT_RU_SUSPENDED_JOB"("CUSTOM_VALUES_ID_");

CREATE INDEX "ACT_IDX_SJOB_SUB_SCOPE"
ON "ACT_RU_SUSPENDED_JOB"("SUB_SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_SJOB_PROC_DEF_ID"
ON "ACT_RU_SUSPENDED_JOB"("PROC_DEF_ID_");

CREATE INDEX "ACT_IDX_SJOB_PROC_INST_ID"
ON "ACT_RU_SUSPENDED_JOB"("PROCESS_INSTANCE_ID_");

CREATE INDEX "ACT_IDX_SJOB_EXECUTION_ID"
ON "ACT_RU_SUSPENDED_JOB"("EXECUTION_ID_");

CREATE INDEX "ACT_IDX_SJOB_SCOPE"
ON "ACT_RU_SUSPENDED_JOB"("SCOPE_ID_","SCOPE_TYPE_");

ALTER TABLE "ACT_RU_JOB" ADD CHECK ("EXCLUSIVE_" IN (1, 0)) ENABLE ;

CREATE INDEX "ACT_IDX_JOB_SCOPE_DEF"
ON "ACT_RU_JOB"("SCOPE_DEFINITION_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_JOB_PROC_INST_ID"
ON "ACT_RU_JOB"("PROCESS_INSTANCE_ID_");

CREATE INDEX "ACT_IDX_JOB_SCOPE"
ON "ACT_RU_JOB"("SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_JOB_CUSTOM_VAL_ID"
ON "ACT_RU_JOB"("CUSTOM_VALUES_ID_");

CREATE INDEX "ACT_IDX_JOB_EXECUTION_ID"
ON "ACT_RU_JOB"("EXECUTION_ID_");

CREATE INDEX "ACT_IDX_JOB_SUB_SCOPE"
ON "ACT_RU_JOB"("SUB_SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_JOB_PROC_DEF_ID"
ON "ACT_RU_JOB"("PROC_DEF_ID_");

CREATE INDEX "ACT_IDX_JOB_EXCEPTION"
ON "ACT_RU_JOB"("EXCEPTION_STACK_ID_");

CREATE INDEX "ACT_IDX_IDENT_LNK_SUB_SCOPE"
ON "ACT_RU_IDENTITYLINK"("SUB_SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_IDENT_LNK_SCOPE"
ON "ACT_RU_IDENTITYLINK"("SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_IDENT_LNK_SCOPE_DEF"
ON "ACT_RU_IDENTITYLINK"("SCOPE_DEFINITION_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_ATHRZ_PROCEDEF"
ON "ACT_RU_IDENTITYLINK"("PROC_DEF_ID_");

CREATE INDEX "ACT_IDX_TSKASS_TASK"
ON "ACT_RU_IDENTITYLINK"("TASK_ID_");

CREATE INDEX "ACT_IDX_IDL_PROCINST"
ON "ACT_RU_IDENTITYLINK"("PROC_INST_ID_");

CREATE INDEX "ACT_IDX_IDENT_LNK_USER"
ON "ACT_RU_IDENTITYLINK"("USER_ID_");

CREATE INDEX "ACT_IDX_IDENT_LNK_GROUP"
ON "ACT_RU_IDENTITYLINK"("GROUP_ID_");

ALTER TABLE "ACT_RU_EXECUTION" ADD CHECK ("IS_ACTIVE_" IN (1, 0)) ENABLE ;

ALTER TABLE "ACT_RU_EXECUTION" ADD CHECK ("IS_COUNT_ENABLED_" IN (1, 0)) ENABLE ;

ALTER TABLE "ACT_RU_EXECUTION" ADD CHECK ("IS_MI_ROOT_" IN (1, 0)) ENABLE ;

ALTER TABLE "ACT_RU_EXECUTION" ADD CHECK ("IS_EVENT_SCOPE_" IN (1, 0)) ENABLE ;

ALTER TABLE "ACT_RU_EXECUTION" ADD CHECK ("IS_SCOPE_" IN (1, 0)) ENABLE ;

ALTER TABLE "ACT_RU_EXECUTION" ADD CHECK ("IS_CONCURRENT_" IN (1, 0)) ENABLE ;

CREATE INDEX "ACT_IDX_EXE_SUPER"
ON "ACT_RU_EXECUTION"("SUPER_EXEC_");

CREATE INDEX "ACT_IDX_EXE_PROCINST"
ON "ACT_RU_EXECUTION"("PROC_INST_ID_");

CREATE INDEX "ACT_IDX_EXEC_BUSKEY"
ON "ACT_RU_EXECUTION"("BUSINESS_KEY_");

CREATE INDEX "ACT_IDX_EXE_PROCDEF"
ON "ACT_RU_EXECUTION"("PROC_DEF_ID_");

CREATE INDEX "ACT_IDX_EXE_PARENT"
ON "ACT_RU_EXECUTION"("PARENT_ID_");

CREATE INDEX "ACT_IDX_EXEC_ROOT"
ON "ACT_RU_EXECUTION"("ROOT_PROC_INST_ID_");

CREATE INDEX "ACT_IDX_EVENT_SUBSCR_CONFIG_"
ON "ACT_RU_EVENT_SUBSCR"("CONFIGURATION_");

CREATE INDEX "ACT_IDX_EVENT_SUBSCR"
ON "ACT_RU_EVENT_SUBSCR"("EXECUTION_ID_");

CREATE INDEX "ACT_IDX_ENT_LNK_SCOPE"
ON "ACT_RU_ENTITYLINK"("SCOPE_ID_","SCOPE_TYPE_","LINK_TYPE_");

CREATE INDEX "ACT_IDX_ENT_LNK_SCOPE_DEF"
ON "ACT_RU_ENTITYLINK"("SCOPE_DEFINITION_ID_","SCOPE_TYPE_","LINK_TYPE_");

ALTER TABLE "ACT_RU_DEADLETTER_JOB" ADD CHECK ("EXCLUSIVE_" IN (1, 0)) ENABLE ;

CREATE INDEX "ACT_IDX_DJOB_PROC_DEF_ID"
ON "ACT_RU_DEADLETTER_JOB"("PROC_DEF_ID_");

CREATE INDEX "ACT_IDX_DJOB_EXCEPTION"
ON "ACT_RU_DEADLETTER_JOB"("EXCEPTION_STACK_ID_");

CREATE INDEX "ACT_IDX_DJOB_SCOPE"
ON "ACT_RU_DEADLETTER_JOB"("SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_DJOB_SCOPE_DEF"
ON "ACT_RU_DEADLETTER_JOB"("SCOPE_DEFINITION_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_DJOB_CUSTOM_VAL_ID"
ON "ACT_RU_DEADLETTER_JOB"("CUSTOM_VALUES_ID_");

CREATE INDEX "ACT_IDX_DJOB_SUB_SCOPE"
ON "ACT_RU_DEADLETTER_JOB"("SUB_SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_DJOB_EXECUTION_ID"
ON "ACT_RU_DEADLETTER_JOB"("EXECUTION_ID_");

CREATE INDEX "ACT_IDX_DJOB_PROC_INST_ID"
ON "ACT_RU_DEADLETTER_JOB"("PROCESS_INSTANCE_ID_");

CREATE INDEX "ACT_IDX_RU_ACTI_PROC_ACT"
ON "ACT_RU_ACTINST"("PROC_INST_ID_","ACT_ID_");

CREATE INDEX "ACT_IDX_RU_ACTI_EXEC_ACT"
ON "ACT_RU_ACTINST"("EXECUTION_ID_","ACT_ID_");

CREATE INDEX "ACT_IDX_RU_ACTI_END"
ON "ACT_RU_ACTINST"("END_TIME_");

CREATE INDEX "ACT_IDX_RU_ACTI_START"
ON "ACT_RU_ACTINST"("START_TIME_");

CREATE INDEX "ACT_IDX_RU_ACTI_EXEC"
ON "ACT_RU_ACTINST"("EXECUTION_ID_");

CREATE INDEX "ACT_IDX_RU_ACTI_PROC"
ON "ACT_RU_ACTINST"("PROC_INST_ID_");

ALTER TABLE "ACT_RE_PROCDEF" ADD CHECK ("HAS_START_FORM_KEY_" IN (1, 0)) ENABLE ;

ALTER TABLE "ACT_RE_PROCDEF" ADD CHECK ("HAS_GRAPHICAL_NOTATION_" IN (1, 0)) ENABLE ;

CREATE INDEX "ACT_IDX_MODEL_SOURCE"
ON "ACT_RE_MODEL"("EDITOR_SOURCE_VALUE_ID_");

CREATE INDEX "ACT_IDX_MODEL_SOURCE_EXTRA"
ON "ACT_RE_MODEL"("EDITOR_SOURCE_EXTRA_VALUE_ID_");

CREATE INDEX "ACT_IDX_MODEL_DEPLOYMENT"
ON "ACT_RE_MODEL"("DEPLOYMENT_ID_");

CREATE INDEX "ACT_IDX_PROCDEF_INFO_JSON"
ON "ACT_PROCDEF_INFO"("INFO_JSON_ID_");

CREATE INDEX "ACT_IDX_PROCDEF_INFO_PROC"
ON "ACT_PROCDEF_INFO"("PROC_DEF_ID_");

CREATE INDEX "ACT_IDX_PRIV_GROUP"
ON "ACT_ID_PRIV_MAPPING"("GROUP_ID_");

CREATE INDEX "ACT_IDX_PRIV_USER"
ON "ACT_ID_PRIV_MAPPING"("USER_ID_");

CREATE INDEX "ACT_IDX_PRIV_MAPPING"
ON "ACT_ID_PRIV_MAPPING"("PRIV_ID_");

CREATE INDEX "ACT_IDX_MEMB_USER"
ON "ACT_ID_MEMBERSHIP"("USER_ID_");

CREATE INDEX "ACT_IDX_MEMB_GROUP"
ON "ACT_ID_MEMBERSHIP"("GROUP_ID_");

CREATE INDEX "ACT_IDX_HI_PROCVAR_PROC_INST"
ON "ACT_HI_VARINST"("PROC_INST_ID_");

CREATE INDEX "ACT_IDX_HI_VAR_SUB_ID_TYPE"
ON "ACT_HI_VARINST"("SUB_SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_HI_PROCVAR_EXE"
ON "ACT_HI_VARINST"("EXECUTION_ID_");

CREATE INDEX "ACT_IDX_HI_VAR_SCOPE_ID_TYPE"
ON "ACT_HI_VARINST"("SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_HI_PROCVAR_NAME_TYPE"
ON "ACT_HI_VARINST"("NAME_","VAR_TYPE_");

CREATE INDEX "ACT_IDX_HI_PROCVAR_TASK_ID"
ON "ACT_HI_VARINST"("TASK_ID_");

CREATE INDEX "ACT_IDX_HI_TASK_SCOPE_DEF"
ON "ACT_HI_TASKINST"("SCOPE_DEFINITION_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_HI_TASK_INST_PROCINST"
ON "ACT_HI_TASKINST"("PROC_INST_ID_");

CREATE INDEX "ACT_IDX_HI_TASK_SUB_SCOPE"
ON "ACT_HI_TASKINST"("SUB_SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_HI_TASK_SCOPE"
ON "ACT_HI_TASKINST"("SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_HI_PRO_I_BUSKEY"
ON "ACT_HI_PROCINST"("BUSINESS_KEY_");

CREATE INDEX "ACT_IDX_HI_PRO_INST_END"
ON "ACT_HI_PROCINST"("END_TIME_");

CREATE INDEX "ACT_IDX_HI_IDENT_LNK_TASK"
ON "ACT_HI_IDENTITYLINK"("TASK_ID_");

CREATE INDEX "ACT_IDX_HI_IDENT_LNK_SUB_SCOPE"
ON "ACT_HI_IDENTITYLINK"("SUB_SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_HI_IDENT_LNK_SCOPE_DEF"
ON "ACT_HI_IDENTITYLINK"("SCOPE_DEFINITION_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_HI_IDENT_LNK_PROCINST"
ON "ACT_HI_IDENTITYLINK"("PROC_INST_ID_");

CREATE INDEX "ACT_IDX_HI_IDENT_LNK_USER"
ON "ACT_HI_IDENTITYLINK"("USER_ID_");

CREATE INDEX "ACT_IDX_HI_IDENT_LNK_SCOPE"
ON "ACT_HI_IDENTITYLINK"("SCOPE_ID_","SCOPE_TYPE_");

CREATE INDEX "ACT_IDX_HI_ENT_LNK_SCOPE"
ON "ACT_HI_ENTITYLINK"("SCOPE_ID_","SCOPE_TYPE_","LINK_TYPE_");

CREATE INDEX "ACT_IDX_HI_ENT_LNK_SCOPE_DEF"
ON "ACT_HI_ENTITYLINK"("SCOPE_DEFINITION_ID_","SCOPE_TYPE_","LINK_TYPE_");

CREATE INDEX "ACT_IDX_HI_DETAIL_TASK_ID"
ON "ACT_HI_DETAIL"("TASK_ID_");

CREATE INDEX "ACT_IDX_HI_DETAIL_TIME"
ON "ACT_HI_DETAIL"("TIME_");

CREATE INDEX "ACT_IDX_HI_DETAIL_PROC_INST"
ON "ACT_HI_DETAIL"("PROC_INST_ID_");

CREATE INDEX "ACT_IDX_HI_DETAIL_NAME"
ON "ACT_HI_DETAIL"("NAME_");

CREATE INDEX "ACT_IDX_HI_DETAIL_ACT_INST"
ON "ACT_HI_DETAIL"("ACT_INST_ID_");

CREATE INDEX "ACT_IDX_HI_ACT_INST_PROCINST"
ON "ACT_HI_ACTINST"("PROC_INST_ID_","ACT_ID_");

CREATE INDEX "ACT_IDX_HI_ACT_INST_EXEC"
ON "ACT_HI_ACTINST"("EXECUTION_ID_","ACT_ID_");

CREATE INDEX "ACT_IDX_HI_ACT_INST_END"
ON "ACT_HI_ACTINST"("END_TIME_");

CREATE INDEX "ACT_IDX_HI_ACT_INST_START"
ON "ACT_HI_ACTINST"("START_TIME_");

ALTER TABLE "ACT_GE_BYTEARRAY" ADD CHECK ("GENERATED_" IN (1, 0)) ENABLE ;

CREATE INDEX "ACT_IDX_BYTEAR_DEPL"
ON "ACT_GE_BYTEARRAY"("DEPLOYMENT_ID_");

CREATE INDEX "IDX_PROC_MOD_HISTORY_PROC"
ON "ACT_DE_MODEL_HISTORY"("MODEL_ID");

CREATE INDEX "IDX_PROC_MOD_CREATED"
ON "ACT_DE_MODEL"("CREATED_BY");

CREATE INDEX "ACT_IDX_APP_RSRC_DPL"
ON "ACT_APP_DEPLOYMENT_RESOURCE"("DEPLOYMENT_ID_");

CREATE INDEX "ACT_IDX_APP_DEF_DPLY"
ON "ACT_APP_APPDEF"("DEPLOYMENT_ID_");

CREATE UNIQUE INDEX "ACT_IDX_APP_DEF_UNIQ"
ON "ACT_APP_APPDEF"("KEY_","VERSION_","TENANT_ID_");

