/*
 * Decompiled with CFR 0.152.
 */
package com.github.tix320.skimp.collection.map.mutable.internal;

import com.github.tix320.skimp.collection.map.BiMap;
import com.github.tix320.skimp.collection.map.internal.AbstractBiMap;
import com.github.tix320.skimp.collection.map.mutable.MutableSortedBiMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class ComparatorBasedBiMap<F, S>
extends AbstractBiMap<F, S>
implements MutableSortedBiMap<F, S> {
    private final SortedMap<EntryImpl<F, S>, EntryImpl<F, S>> backingMap;
    private final StraightView straightView;
    private final InverseView inverseView;

    protected ComparatorBasedBiMap(SortedMap<EntryImpl<F, S>, EntryImpl<F, S>> backingMap) {
        this.backingMap = backingMap;
        this.straightView = new StraightView();
        this.inverseView = new InverseView();
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public final boolean contains(F key) {
        return this.straightView.containsKey(key);
    }

    @Override
    public final boolean inverseContains(S key) {
        return this.inverseView.containsKey(key);
    }

    @Override
    public final S get(F key) {
        return this.straightView.get(key);
    }

    @Override
    public final F inverseGet(S key) {
        return this.inverseView.get(key);
    }

    @Override
    public final Map<F, S> view() {
        return this.straightView;
    }

    @Override
    public final Map<S, F> inverseView() {
        return this.inverseView;
    }

    @Override
    public final Iterator<BiMap.Entry<F, S>> iterator() {
        final Iterator<Map.Entry<EntryImpl<F, S>, EntryImpl<F, S>>> iterator = this.backingMap.entrySet().iterator();
        return new Iterator<BiMap.Entry<F, S>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public BiMap.Entry<F, S> next() {
                return (BiMap.Entry)((Map.Entry)iterator.next()).getKey();
            }
        };
    }

    @Override
    public final void put(F item1, S item2) {
        EntryImpl<F, S> entry = new EntryImpl<F, S>(item1, item2);
        this.backingMap.put(entry, entry);
    }

    @Override
    public final S remove(F key) {
        EntryImpl<F, Object> entry = new EntryImpl<F, Object>(key, null);
        EntryImpl removedEntry = (EntryImpl)this.backingMap.remove(entry);
        return removedEntry == null ? null : (S)removedEntry.second;
    }

    @Override
    public final F removeInverse(S key) {
        EntryImpl<Object, S> entry = new EntryImpl<Object, S>(null, key);
        EntryImpl removedEntry = (EntryImpl)this.backingMap.remove(entry);
        return removedEntry == null ? null : (F)removedEntry.first;
    }

    @Override
    public final void clear() {
        this.backingMap.clear();
    }

    protected static <F, S> Comparator<EntryImpl<F, S>> buildComparator(Comparator<? super F> firstComparator, Comparator<? super S> secondComparator) {
        return new EntryComparator<F, S>(firstComparator, secondComparator);
    }

    private final class StraightView
    extends AbstractView<F, S> {
        private StraightView() {
        }

        @Override
        public boolean containsKey(Object key) {
            return ComparatorBasedBiMap.this.backingMap.containsKey(new EntryImpl<Object, Object>(key, null));
        }

        @Override
        public boolean containsValue(Object value) {
            return ComparatorBasedBiMap.this.backingMap.containsKey(new EntryImpl<Object, Object>(null, value));
        }

        @Override
        public S get(Object key) {
            EntryImpl entry = (EntryImpl)ComparatorBasedBiMap.this.backingMap.get(new EntryImpl<Object, Object>(key, null));
            return entry == null ? null : (Object)entry.second;
        }

        @Override
        public void forEach(BiConsumer<? super F, ? super S> action) {
            for (BiMap.Entry entry : ComparatorBasedBiMap.this) {
                action.accept(entry.first(), entry.second());
            }
        }
    }

    private final class InverseView
    extends AbstractView<S, F> {
        private InverseView() {
        }

        @Override
        public boolean containsKey(Object key) {
            return ComparatorBasedBiMap.this.backingMap.containsKey(new EntryImpl<Object, Object>(null, key));
        }

        @Override
        public boolean containsValue(Object value) {
            return ComparatorBasedBiMap.this.backingMap.containsKey(new EntryImpl<Object, Object>(value, null));
        }

        @Override
        public F get(Object key) {
            EntryImpl entry = (EntryImpl)ComparatorBasedBiMap.this.backingMap.get(new EntryImpl<Object, Object>(null, key));
            return entry == null ? null : (Object)entry.first;
        }

        @Override
        public void forEach(BiConsumer<? super S, ? super F> action) {
            for (BiMap.Entry entry : ComparatorBasedBiMap.this) {
                action.accept(entry.second(), entry.first());
            }
        }
    }

    protected record EntryImpl<F, S>(F first, S second) implements BiMap.Entry<F, S>
    {
    }

    private static final class EntryComparator<F, S>
    implements Comparator<EntryImpl<F, S>> {
        private final Comparator<? super F> firstComparator;
        private final Comparator<? super S> secondComparator;

        private EntryComparator(Comparator<? super F> firstComparator, Comparator<? super S> secondComparator) {
            this.firstComparator = firstComparator;
            this.secondComparator = secondComparator;
        }

        @Override
        public int compare(EntryImpl<F, S> entry1, EntryImpl<F, S> entry2) {
            if (entry1.first == null || entry2.first == null) {
                return this.secondComparator.compare(entry1.second, entry2.second);
            }
            if (entry1.second == null || entry2.second == null) {
                return this.firstComparator.compare(entry1.first, entry2.first);
            }
            int compare = this.firstComparator.compare(entry1.first, entry2.first);
            if (compare == 0) {
                compare = this.secondComparator.compare(entry1.second, entry2.second);
            }
            return compare;
        }
    }

    private abstract class AbstractView<K, V>
    implements Map<K, V> {
        private AbstractView() {
        }

        @Override
        public final int size() {
            return ComparatorBasedBiMap.this.backingMap.size();
        }

        @Override
        public final boolean isEmpty() {
            return ComparatorBasedBiMap.this.backingMap.isEmpty();
        }

        @Override
        public final V put(K key, V value) {
            throw new UnsupportedOperationException("View collection");
        }

        @Override
        public final V remove(Object key) {
            throw new UnsupportedOperationException("View collection");
        }

        @Override
        public final void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException("View collection");
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException("View collection");
        }

        @Override
        public final void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            throw new UnsupportedOperationException("View collection");
        }

        @Override
        public final boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException("View collection");
        }

        @Override
        public final boolean replace(K key, V oldValue, V newValue) {
            throw new UnsupportedOperationException("View collection");
        }

        @Override
        public final V replace(K key, V value) {
            throw new UnsupportedOperationException("View collection");
        }

        @Override
        public final V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            throw new UnsupportedOperationException("View collection");
        }

        @Override
        public final V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException("View collection");
        }

        @Override
        public final V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException("View collection");
        }

        @Override
        public final V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException("View collection");
        }

        @Override
        public final Set<K> keySet() {
            throw new UnsupportedOperationException("");
        }

        @Override
        public final Collection<V> values() {
            throw new UnsupportedOperationException("");
        }

        @Override
        public final Set<Map.Entry<K, V>> entrySet() {
            throw new UnsupportedOperationException("");
        }

        @Override
        public final V putIfAbsent(K key, V value) {
            throw new UnsupportedOperationException("");
        }

        @Override
        public final V getOrDefault(Object key, V defaultValue) {
            Object value = this.get(key);
            return value == null ? defaultValue : value;
        }
    }
}

