/*
 * Decompiled with CFR 0.152.
 */
package com.github.tix320.skimp.interval;

import com.github.tix320.skimp.exception.ExceptionUtils;
import com.github.tix320.skimp.exception.ThreadInterruptedException;
import com.github.tix320.skimp.function.CheckedRunnable;
import com.github.tix320.skimp.function.CheckedSupplier;
import com.github.tix320.skimp.interval.ActionFailedException;
import com.github.tix320.skimp.interval.Interval;
import com.github.tix320.skimp.object.None;
import java.time.Duration;
import java.util.Optional;

public final class IntervalRepeater<T> {
    private final Interval interval;
    private final CheckedSupplier<T> action;

    private IntervalRepeater(Interval interval, CheckedSupplier<T> action) {
        this.interval = interval;
        this.action = action;
    }

    public T doNext() throws ThreadInterruptedException, ActionFailedException {
        Duration duration = this.interval.next();
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            throw new ThreadInterruptedException();
        }
        try {
            return this.action.get();
        }
        catch (Throwable e) {
            throw new ActionFailedException(e);
        }
    }

    public Optional<T> doUntilSuccess(int maxCount) throws ThreadInterruptedException {
        for (int remaining = maxCount; remaining != 0; --remaining) {
            try {
                return Optional.ofNullable(this.doNext());
            }
            catch (ThreadInterruptedException e) {
                throw new ThreadInterruptedException();
            }
            catch (ActionFailedException e) {
                ExceptionUtils.applyToUncaughtExceptionHandler(e);
                continue;
            }
        }
        return Optional.empty();
    }

    public static <T> IntervalRepeater<T> of(Interval interval, CheckedSupplier<T> runnable) {
        return new IntervalRepeater<T>(interval, runnable);
    }

    public static IntervalRepeater<None> of(Interval interval, CheckedRunnable runnable) {
        return IntervalRepeater.of(interval, () -> {
            runnable.run();
            return None.SELF;
        });
    }
}

