/*
 * Decompiled with CFR 0.152.
 */
package com.github.tix320.skimp.thread;

import com.github.tix320.skimp.exception.ExceptionUtils;
import java.util.concurrent.locks.LockSupport;

public final class LoopThread
extends Thread {
    private final Runnable loopAction;

    public LoopThread(Runnable loopAction) {
        this.loopAction = loopAction;
    }

    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        if (currentThread != this) {
            throw new IllegalStateException();
        }
        while (!currentThread.isInterrupted()) {
            try {
                this.loopAction.run();
            }
            catch (BreakLoopException e) {
                break;
            }
            catch (Throwable e) {
                ExceptionUtils.applyToUncaughtExceptionHandler(e);
            }
        }
    }

    public boolean isStarted() {
        return this.getState() != Thread.State.NEW;
    }

    public void unpark() {
        LockSupport.unpark(this);
    }

    public static final class BreakLoopException
    extends RuntimeException {
    }
}

