/*
 * Decompiled with CFR 0.152.
 */
package com.github.tix320.skimp.thread.tracer;

import com.github.tix320.skimp.assertion.AssertionUtils;
import com.github.tix320.skimp.thread.tracer.Tracer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class TrackableExecutorService
implements ExecutorService {
    private final ExecutorService executorService;

    private TrackableExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public static ExecutorService wrap(ExecutorService executorService) {
        if (AssertionUtils.isEnabled()) {
            return new TrackableExecutorService(executorService);
        }
        return executorService;
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(Tracer.INSTANCE.trackifyThreadTask(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executorService.submit(Tracer.INSTANCE.trackifyThreadTask(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executorService.submit(Tracer.INSTANCE.trackifyThreadTask(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executorService.invokeAll(Tracer.INSTANCE.trackifyThreadTasks(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.invokeAll(Tracer.INSTANCE.trackifyThreadTasks(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executorService.invokeAny(Tracer.INSTANCE.trackifyThreadTasks(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executorService.invokeAny(Tracer.INSTANCE.trackifyThreadTasks(tasks), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.executorService.execute(Tracer.INSTANCE.trackifyThreadTask(command));
    }
}

