/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.tensor.operations.cnative;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.PaddingLayout;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class NativeSimd {
    static final Arena LIBRARY_ARENA = Arena.ofAuto();
    static final boolean TRACE_DOWNCALLS = Boolean.getBoolean("jextract.trace.downcalls");
    static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.loaderLookup().or(Linker.nativeLinker().defaultLookup());
    public static final ValueLayout.OfBoolean C_BOOL = ValueLayout.JAVA_BOOLEAN;
    public static final ValueLayout.OfByte C_CHAR = ValueLayout.JAVA_BYTE;
    public static final ValueLayout.OfShort C_SHORT = ValueLayout.JAVA_SHORT;
    public static final ValueLayout.OfInt C_INT = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfLong C_LONG_LONG = ValueLayout.JAVA_LONG;
    public static final ValueLayout.OfFloat C_FLOAT = ValueLayout.JAVA_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE = ValueLayout.JAVA_DOUBLE;
    public static final AddressLayout C_POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
    public static final ValueLayout.OfLong C_LONG = ValueLayout.JAVA_LONG;
    private static final int HAS_F16C = 2;
    private static final int HAS_AVX2 = 4;
    private static final int IS_M_SERIES_MAC = 8;
    private static final int Q8_BLOCK_SIZE = 32;
    private static final int Q4_BLOCK_SIZE = 32;

    NativeSimd() {
    }

    static void traceDowncall(String name, Object ... args) {
        String traceArgs = Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", "));
        System.out.printf("%s(%s)\n", name, traceArgs);
    }

    static MemorySegment findOrThrow(String symbol) {
        return SYMBOL_LOOKUP.find(symbol).orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + symbol));
    }

    static MethodHandle upcallHandle(Class<?> fi, String name, FunctionDescriptor fdesc) {
        try {
            return MethodHandles.lookup().findVirtual(fi, name, fdesc.toMethodType());
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static MemoryLayout align(MemoryLayout layout, long align) {
        MemoryLayout memoryLayout = layout;
        Objects.requireNonNull(memoryLayout);
        MemoryLayout memoryLayout2 = memoryLayout;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PaddingLayout.class, ValueLayout.class, GroupLayout.class, SequenceLayout.class}, (Object)memoryLayout2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PaddingLayout p;
                yield p = (PaddingLayout)memoryLayout2;
            }
            case 1 -> {
                ValueLayout v = (ValueLayout)memoryLayout2;
                yield v.withByteAlignment(align);
            }
            case 2 -> {
                GroupLayout g = (GroupLayout)memoryLayout2;
                MemoryLayout[] alignedMembers = (MemoryLayout[])g.memberLayouts().stream().map(m -> NativeSimd.align(m, align)).toArray(MemoryLayout[]::new);
                if (g instanceof StructLayout) {
                    yield MemoryLayout.structLayout(alignedMembers);
                }
                yield MemoryLayout.unionLayout(alignedMembers);
            }
            case 3 -> {
                SequenceLayout s = (SequenceLayout)memoryLayout2;
                yield MemoryLayout.sequenceLayout(s.elementCount(), NativeSimd.align(s.elementLayout(), align));
            }
        };
    }

    public static int HAS_F16C() {
        return 2;
    }

    public static int HAS_AVX2() {
        return 4;
    }

    public static int IS_M_SERIES_MAC() {
        return 8;
    }

    public static int Q8_BLOCK_SIZE() {
        return 32;
    }

    public static int Q4_BLOCK_SIZE() {
        return 32;
    }

    public static FunctionDescriptor gemm_q8_q4$descriptor() {
        return gemm_q8_q4.DESC;
    }

    public static MethodHandle gemm_q8_q4$handle() {
        return gemm_q8_q4.HANDLE;
    }

    public static MemorySegment gemm_q8_q4$address() {
        return gemm_q8_q4.ADDR;
    }

    public static void gemm_q8_q4(int flags, MemorySegment af, MemorySegment a, int aoffset, MemorySegment bf, MemorySegment b, int boffset, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldaf, int ldb, int ldbf, int ldc) {
        MethodHandle mh$ = gemm_q8_q4.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimd.traceDowncall("gemm_q8_q4", flags, af, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldaf, ldb, ldbf, ldc);
            }
            mh$.invokeExact(flags, af, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldaf, ldb, ldbf, ldc);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor gemm_q8_q4_batch$descriptor() {
        return gemm_q8_q4_batch.DESC;
    }

    public static MethodHandle gemm_q8_q4_batch$handle() {
        return gemm_q8_q4_batch.HANDLE;
    }

    public static MemorySegment gemm_q8_q4_batch$address() {
        return gemm_q8_q4_batch.ADDR;
    }

    public static void gemm_q8_q4_batch(int flags, int batch_num, MemorySegment af, MemorySegment a, int aoffset, MemorySegment bf, MemorySegment b, int boffset, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldaf, int ldb, int ldbf, int ldc) {
        MethodHandle mh$ = gemm_q8_q4_batch.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimd.traceDowncall("gemm_q8_q4_batch", flags, batch_num, af, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldaf, ldb, ldbf, ldc);
            }
            mh$.invokeExact(flags, batch_num, af, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldaf, ldb, ldbf, ldc);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor gemm_f32$descriptor() {
        return gemm_f32.DESC;
    }

    public static MethodHandle gemm_f32$handle() {
        return gemm_f32.HANDLE;
    }

    public static MemorySegment gemm_f32$address() {
        return gemm_f32.ADDR;
    }

    public static void gemm_f32(int flags, MemorySegment a, int aoffset, MemorySegment b, int boffset, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc) {
        MethodHandle mh$ = gemm_f32.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimd.traceDowncall("gemm_f32", flags, a, aoffset, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldc);
            }
            mh$.invokeExact(flags, a, aoffset, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldc);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor gemm_f32_batch$descriptor() {
        return gemm_f32_batch.DESC;
    }

    public static MethodHandle gemm_f32_batch$handle() {
        return gemm_f32_batch.HANDLE;
    }

    public static MemorySegment gemm_f32_batch$address() {
        return gemm_f32_batch.ADDR;
    }

    public static void gemm_f32_batch(int flags, int batch_num, MemorySegment a, int aoffset, MemorySegment b, int boffset, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc) {
        MethodHandle mh$ = gemm_f32_batch.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimd.traceDowncall("gemm_f32_batch", flags, batch_num, a, aoffset, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldc);
            }
            mh$.invokeExact(flags, batch_num, a, aoffset, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldc);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor gemm_f32_q4$descriptor() {
        return gemm_f32_q4.DESC;
    }

    public static MethodHandle gemm_f32_q4$handle() {
        return gemm_f32_q4.HANDLE;
    }

    public static MemorySegment gemm_f32_q4$address() {
        return gemm_f32_q4.ADDR;
    }

    public static void gemm_f32_q4(int flags, MemorySegment a, int aoffset, MemorySegment bf, MemorySegment b, int boffset, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldbf, int ldc) {
        MethodHandle mh$ = gemm_f32_q4.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimd.traceDowncall("gemm_f32_q4", flags, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldbf, ldc);
            }
            mh$.invokeExact(flags, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldbf, ldc);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor gemm_f32_q4_batch$descriptor() {
        return gemm_f32_q4_batch.DESC;
    }

    public static MethodHandle gemm_f32_q4_batch$handle() {
        return gemm_f32_q4_batch.HANDLE;
    }

    public static MemorySegment gemm_f32_q4_batch$address() {
        return gemm_f32_q4_batch.ADDR;
    }

    public static void gemm_f32_q4_batch(int flags, int batch_num, MemorySegment a, int aoffset, MemorySegment bf, MemorySegment b, int boffset, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldbf, int ldc) {
        MethodHandle mh$ = gemm_f32_q4_batch.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimd.traceDowncall("gemm_f32_q4_batch", flags, batch_num, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldbf, ldc);
            }
            mh$.invokeExact(flags, batch_num, a, aoffset, bf, b, boffset, r, roffset, m, n0, n, k, lda, ldb, ldbf, ldc);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor gemm_bf16$descriptor() {
        return gemm_bf16.DESC;
    }

    public static MethodHandle gemm_bf16$handle() {
        return gemm_bf16.HANDLE;
    }

    public static MemorySegment gemm_bf16$address() {
        return gemm_bf16.ADDR;
    }

    public static void gemm_bf16(int flags, MemorySegment a, int aoffset, MemorySegment b, int boffset, MemorySegment cr, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc) {
        MethodHandle mh$ = gemm_bf16.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimd.traceDowncall("gemm_bf16", flags, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
            }
            mh$.invokeExact(flags, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor gemm_bf16_batch$descriptor() {
        return gemm_bf16_batch.DESC;
    }

    public static MethodHandle gemm_bf16_batch$handle() {
        return gemm_bf16_batch.HANDLE;
    }

    public static MemorySegment gemm_bf16_batch$address() {
        return gemm_bf16_batch.ADDR;
    }

    public static void gemm_bf16_batch(int flags, int batch_num, MemorySegment a, int aoffset, MemorySegment b, int boffset, MemorySegment cr, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc) {
        MethodHandle mh$ = gemm_bf16_batch.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimd.traceDowncall("gemm_bf16_batch", flags, batch_num, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
            }
            mh$.invokeExact(flags, batch_num, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor gemm_f32_bf16$descriptor() {
        return gemm_f32_bf16.DESC;
    }

    public static MethodHandle gemm_f32_bf16$handle() {
        return gemm_f32_bf16.HANDLE;
    }

    public static MemorySegment gemm_f32_bf16$address() {
        return gemm_f32_bf16.ADDR;
    }

    public static void gemm_f32_bf16(int flags, MemorySegment a, int aoffset, MemorySegment b, int boffset, MemorySegment cr, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc) {
        MethodHandle mh$ = gemm_f32_bf16.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimd.traceDowncall("gemm_f32_bf16", flags, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
            }
            mh$.invokeExact(flags, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor gemm_f32_bf16_batch$descriptor() {
        return gemm_f32_bf16_batch.DESC;
    }

    public static MethodHandle gemm_f32_bf16_batch$handle() {
        return gemm_f32_bf16_batch.HANDLE;
    }

    public static MemorySegment gemm_f32_bf16_batch$address() {
        return gemm_f32_bf16_batch.ADDR;
    }

    public static void gemm_f32_bf16_batch(int flags, int batch_num, MemorySegment a, int aoffset, MemorySegment b, int boffset, MemorySegment cr, MemorySegment r, int roffset, int m, int n0, int n, int k, int lda, int ldb, int ldc) {
        MethodHandle mh$ = gemm_f32_bf16_batch.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                NativeSimd.traceDowncall("gemm_f32_bf16_batch", flags, batch_num, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
            }
            mh$.invokeExact(flags, batch_num, a, aoffset, b, boffset, cr, r, roffset, m, n0, n, k, lda, ldb, ldc);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    private static class gemm_q8_q4 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_INT, C_POINTER, C_POINTER, C_INT, C_POINTER, C_POINTER, C_INT, C_POINTER, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT);
        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_q8_q4");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private gemm_q8_q4() {
        }
    }

    private static class gemm_q8_q4_batch {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_INT, C_INT, C_POINTER, C_POINTER, C_INT, C_POINTER, C_POINTER, C_INT, C_POINTER, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT);
        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_q8_q4_batch");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private gemm_q8_q4_batch() {
        }
    }

    private static class gemm_f32 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_INT, C_POINTER, C_INT, C_POINTER, C_INT, C_POINTER, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT);
        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_f32");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private gemm_f32() {
        }
    }

    private static class gemm_f32_batch {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_INT, C_INT, C_POINTER, C_INT, C_POINTER, C_INT, C_POINTER, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT);
        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_f32_batch");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private gemm_f32_batch() {
        }
    }

    private static class gemm_f32_q4 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_INT, C_POINTER, C_INT, C_POINTER, C_POINTER, C_INT, C_POINTER, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT);
        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_f32_q4");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private gemm_f32_q4() {
        }
    }

    private static class gemm_f32_q4_batch {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_INT, C_INT, C_POINTER, C_INT, C_POINTER, C_POINTER, C_INT, C_POINTER, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT);
        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_f32_q4_batch");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private gemm_f32_q4_batch() {
        }
    }

    private static class gemm_bf16 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_INT, C_POINTER, C_INT, C_POINTER, C_INT, C_POINTER, C_POINTER, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT);
        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_bf16");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private gemm_bf16() {
        }
    }

    private static class gemm_bf16_batch {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_INT, C_INT, C_POINTER, C_INT, C_POINTER, C_INT, C_POINTER, C_POINTER, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT);
        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_bf16_batch");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private gemm_bf16_batch() {
        }
    }

    private static class gemm_f32_bf16 {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_INT, C_POINTER, C_INT, C_POINTER, C_INT, C_POINTER, C_POINTER, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT);
        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_f32_bf16");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private gemm_f32_bf16() {
        }
    }

    private static class gemm_f32_bf16_batch {
        public static final FunctionDescriptor DESC = FunctionDescriptor.ofVoid(C_INT, C_INT, C_POINTER, C_INT, C_POINTER, C_INT, C_POINTER, C_POINTER, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT, C_INT);
        public static final MemorySegment ADDR = NativeSimd.findOrThrow("gemm_f32_bf16_batch");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private gemm_f32_bf16_batch() {
        }
    }
}

