/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjake.jlama.tensor.operations.util;

import com.github.tjake.jlama.util.RuntimeSupport;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarSupport {
    private static final Logger logger = LoggerFactory.getLogger(JarSupport.class);

    public static boolean maybeLoadLibrary() {
        String ext = RuntimeSupport.isMac() ? ".dylib" : (RuntimeSupport.isWin() ? ".dll" : ".so");
        URL lib = JarSupport.class.getClassLoader().getResource("META-INF/native/lib/libjlama" + ext);
        if (lib != null) {
            try {
                File libpath = Files.createTempDirectory("jlama", new FileAttribute[0]).toFile();
                libpath.deleteOnExit();
                File libfile = Paths.get(libpath.getAbsolutePath(), "libjlama" + ext).toFile();
                libfile.deleteOnExit();
                InputStream in = lib.openStream();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(libfile));
                int len = 0;
                byte[] buffer = new byte[8192];
                while ((len = in.read(buffer)) > -1) {
                    ((OutputStream)out).write(buffer, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
                System.load(libfile.getAbsolutePath());
                logger.debug("Loaded jlama-native library: {}", (Object)libfile.getAbsolutePath());
                return true;
            }
            catch (IOException e) {
                logger.warn("Error loading jlama-native library");
            }
        }
        logger.warn("jlama-native shared library not found");
        return false;
    }
}

