/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjni.captainhook.dagger.components;

import com.github.tjni.captainhook.dagger.components.PluginComponent;
import com.github.tjni.captainhook.dagger.modules.ProjectModule;
import com.github.tjni.captainhook.dagger.modules.ProjectModule_ProvideProjectFactory;
import com.github.tjni.captainhook.dagger.modules.SingletonModule;
import com.github.tjni.captainhook.dagger.modules.SingletonModule_ProvideClockFactory;
import com.github.tjni.captainhook.helpers.ApplyGitHooksHelper;
import com.github.tjni.captainhook.helpers.ApplyGitHooksHelper_Factory;
import com.github.tjni.captainhook.helpers.ExecHelper;
import com.github.tjni.captainhook.helpers.ExecHelper_Factory;
import com.github.tjni.captainhook.helpers.FilesHelper;
import com.github.tjni.captainhook.helpers.FilesHelper_Factory;
import com.github.tjni.captainhook.helpers.GitHelper;
import com.github.tjni.captainhook.helpers.GitHelper_Factory;
import com.github.tjni.captainhook.helpers.GradleHelper;
import com.github.tjni.captainhook.helpers.GradleHelper_Factory;
import com.github.tjni.captainhook.helpers.OperatingSystemHelper;
import com.github.tjni.captainhook.helpers.OperatingSystemHelper_Factory;
import com.github.tjni.captainhook.helpers.StagingHelper;
import com.github.tjni.captainhook.helpers.StagingHelper_Factory;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import java.time.Clock;
import javax.inject.Provider;
import org.gradle.api.Project;

public final class DaggerPluginComponent
implements PluginComponent {
    private Provider<FilesHelper> filesHelperProvider;
    private Provider<Project> provideProjectProvider;
    private Provider<ExecHelper> execHelperProvider;
    private Provider<GitHelper> gitHelperProvider;
    private Provider<GradleHelper> gradleHelperProvider;
    private Provider<Clock> provideClockProvider;
    private Provider<ApplyGitHooksHelper> applyGitHooksHelperProvider;
    private Provider<OperatingSystemHelper> operatingSystemHelperProvider;
    private Provider<StagingHelper> stagingHelperProvider;

    private DaggerPluginComponent(ProjectModule projectModuleParam) {
        this.initialize(projectModuleParam);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void initialize(ProjectModule projectModuleParam) {
        this.filesHelperProvider = DoubleCheck.provider((Provider)FilesHelper_Factory.create());
        this.provideProjectProvider = DoubleCheck.provider((Provider)ProjectModule_ProvideProjectFactory.create(projectModuleParam));
        this.execHelperProvider = DoubleCheck.provider((Provider)ExecHelper_Factory.create(this.provideProjectProvider));
        this.gitHelperProvider = DoubleCheck.provider((Provider)GitHelper_Factory.create(this.execHelperProvider));
        this.gradleHelperProvider = DoubleCheck.provider((Provider)GradleHelper_Factory.create(this.provideProjectProvider));
        this.provideClockProvider = DoubleCheck.provider((Provider)SingletonModule_ProvideClockFactory.create());
        this.applyGitHooksHelperProvider = DoubleCheck.provider((Provider)ApplyGitHooksHelper_Factory.create(this.filesHelperProvider, this.gitHelperProvider, this.gradleHelperProvider, this.provideClockProvider));
        this.operatingSystemHelperProvider = DoubleCheck.provider((Provider)OperatingSystemHelper_Factory.create());
        this.stagingHelperProvider = DoubleCheck.provider((Provider)StagingHelper_Factory.create(this.gitHelperProvider, this.filesHelperProvider, this.operatingSystemHelperProvider));
    }

    @Override
    public FilesHelper getFilesHelper() {
        return (FilesHelper)this.filesHelperProvider.get();
    }

    @Override
    public GitHelper getGitHelper() {
        return (GitHelper)this.gitHelperProvider.get();
    }

    @Override
    public GradleHelper getGradleHelper() {
        return (GradleHelper)this.gradleHelperProvider.get();
    }

    @Override
    public ApplyGitHooksHelper getApplyGitHooksHelper() {
        return (ApplyGitHooksHelper)this.applyGitHooksHelperProvider.get();
    }

    @Override
    public StagingHelper getStagingHelper() {
        return (StagingHelper)this.stagingHelperProvider.get();
    }

    @Override
    public Clock getClock() {
        return (Clock)this.provideClockProvider.get();
    }

    public static final class Builder {
        private ProjectModule projectModule;

        private Builder() {
        }

        public Builder projectModule(ProjectModule projectModule) {
            this.projectModule = (ProjectModule)Preconditions.checkNotNull((Object)projectModule);
            return this;
        }

        @Deprecated
        public Builder singletonModule(SingletonModule singletonModule) {
            Preconditions.checkNotNull((Object)singletonModule);
            return this;
        }

        public PluginComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.projectModule, ProjectModule.class);
            return new DaggerPluginComponent(this.projectModule);
        }
    }
}

