/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjni.captainhook.helpers;

import com.github.tjni.captainhook.annotations.ImmutableStyle;
import com.github.tjni.captainhook.helpers.FilesHelper;
import com.github.tjni.captainhook.helpers.GitHelper;
import com.github.tjni.captainhook.helpers.GitHook;
import com.github.tjni.captainhook.helpers.GradleHelper;
import com.github.tjni.captainhook.helpers.ImmutableGitHookTemplateData;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.immutables.value.Value;

@Singleton
public class ApplyGitHooksHelper {
    private static final Logger LOG = Logging.getLogger(ApplyGitHooksHelper.class);
    private final FilesHelper filesHelper;
    private final GitHelper gitHelper;
    private final GradleHelper gradleHelper;
    private final Clock clock;

    @Inject
    public ApplyGitHooksHelper(FilesHelper filesHelper, GitHelper gitHelper, GradleHelper gradleHelper, Clock clock) {
        this.filesHelper = filesHelper;
        this.gitHelper = gitHelper;
        this.gradleHelper = gradleHelper;
        this.clock = clock;
    }

    public void apply(Map<GitHook, String> gitHooks) {
        Path gitHooksDir = this.findGitHooksDirectory();
        if (!gitHooks.isEmpty()) {
            this.createGitHookDirectories(gitHooksDir);
        }
        GitHookTemplate template = new GitHookTemplate(this.filesHelper, this.createFreeMarkerConfiguration());
        this.addHookScripts(gitHooksDir, template, gitHooks);
        this.applyHooks(gitHooksDir, gitHooks);
        this.removeHookScripts(gitHooksDir, gitHooks);
        this.cleanEmptyHookScriptsDirectory(gitHooksDir);
    }

    void addHookScripts(Path gitHooksDir, GitHookTemplate template, Map<GitHook, String> gitHooks) {
        EntryStream.of(gitHooks).removeValues(String::isEmpty).mapKeys(gitHook -> ApplyGitHooksHelper.getGitHookScriptFile(gitHooksDir, gitHook)).mapValues(this::getGitHookTemplateData).mapKeyValue(template::writeTemplate).forEach(this::makeExecutable);
    }

    void removeHookScripts(Path gitHooksDir, Map<GitHook, String> gitHooks) {
        StreamEx.of((Object[])GitHook.values()).mapToEntry(gitHook -> gitHooks.getOrDefault(gitHook, "")).filterValues(String::isEmpty).keys().map(gitHook -> ApplyGitHooksHelper.getGitHookScriptFile(gitHooksDir, gitHook)).forEach(this.filesHelper::deleteIfExists);
    }

    void applyHooks(Path gitHooksDir, Map<GitHook, String> gitHooks) {
        Map fullGitHooks = StreamEx.of((Object[])GitHook.values()).mapToEntry(gitHook -> gitHooks.getOrDefault(gitHook, "")).toImmutableMap();
        EntryStream.of((Map)fullGitHooks).removeValues(String::isEmpty).keys().map(gitHook -> this.addGitHook(gitHooksDir, (GitHook)((Object)gitHook))).forEach(this::makeExecutable);
        EntryStream.of((Map)fullGitHooks).filterValues(String::isEmpty).keys().mapPartial(gitHook -> this.removeGitHook(gitHooksDir, (GitHook)((Object)gitHook))).forEach(this::makeExecutable);
    }

    Path findGitHooksDirectory() {
        return this.gitHelper.getCommonDirectory().resolve("hooks");
    }

    void createGitHookDirectories(Path gitHooksDir) {
        this.filesHelper.createDirectories(ApplyGitHooksHelper.getGitHookScriptsDirectory(gitHooksDir), new FileAttribute[0]);
    }

    private static Path getGitHookScriptsDirectory(Path gitHooksDir) {
        return gitHooksDir.resolve("git-hooks");
    }

    private static Path getGitHookScriptFile(Path gitHooksDir, GitHook gitHook) {
        return ApplyGitHooksHelper.getGitHookScriptsDirectory(gitHooksDir).resolve(gitHook.getHookName());
    }

    private static String getGitHookCommand(Path gitHooksDir, GitHook gitHook) {
        Path gitHookScriptFile = gitHooksDir.relativize(ApplyGitHooksHelper.getGitHookScriptFile(gitHooksDir, gitHook));
        return "`dirname \"$0\"`/" + gitHookScriptFile;
    }

    private Path addGitHook(Path gitHooksDir, GitHook gitHook) {
        String executeCommand;
        Path gitHookFile = gitHooksDir.resolve(gitHook.getHookName());
        String currentHookString = this.filesHelper.exists(gitHookFile) ? this.filesHelper.toString(gitHookFile).trim() : "#!/bin/sh -";
        if (currentHookString.contains(executeCommand = String.format("%n%n%s", ApplyGitHooksHelper.getGitHookCommand(gitHooksDir, gitHook)))) {
            return gitHookFile;
        }
        String newHookString = currentHookString + executeCommand;
        return this.filesHelper.write(gitHookFile, newHookString);
    }

    private Optional<Path> removeGitHook(Path gitHooksDir, GitHook gitHook) {
        Path gitHookFile = gitHooksDir.resolve(gitHook.getHookName());
        if (!this.filesHelper.exists(gitHookFile)) {
            return Optional.empty();
        }
        String currentHookString = this.filesHelper.toString(gitHookFile).trim();
        String executeCommand = String.format("%n%n%s", ApplyGitHooksHelper.getGitHookCommand(gitHooksDir, gitHook));
        if (!currentHookString.contains(executeCommand)) {
            return Optional.of(gitHookFile);
        }
        String newHookString = currentHookString.replace(executeCommand, "");
        if ("#!/bin/sh -".equals(newHookString)) {
            this.filesHelper.delete(gitHookFile);
            return Optional.empty();
        }
        return Optional.of(this.filesHelper.write(gitHookFile, newHookString));
    }

    private void makeExecutable(Path gitHookFile) {
        try {
            this.filesHelper.setPosixFilePermissions(gitHookFile, "rwxr--r--");
        }
        catch (UnsupportedOperationException e) {
            LOG.debug("Setting POSIX file permissions is unsupported, skipping.", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("An error occurred when setting POSIX file permissions for {}.", (Object)gitHookFile);
        }
    }

    void cleanEmptyHookScriptsDirectory(Path gitHooksDir) {
        Path gitHookScriptsDirectory = ApplyGitHooksHelper.getGitHookScriptsDirectory(gitHooksDir);
        if (!this.filesHelper.exists(gitHookScriptsDirectory)) {
            return;
        }
        if (!this.filesHelper.isDirectoryEmpty(gitHookScriptsDirectory)) {
            return;
        }
        this.filesHelper.delete(gitHookScriptsDirectory);
    }

    Configuration createFreeMarkerConfiguration() {
        Configuration freeMarkerConfiguration = new Configuration(Configuration.VERSION_2_3_29);
        freeMarkerConfiguration.setClassForTemplateLoading(this.getClass(), "/templates");
        freeMarkerConfiguration.setDefaultEncoding(StandardCharsets.UTF_8.name());
        freeMarkerConfiguration.setTemplateExceptionHandler(this.gradleHelper.isDebugLoggingEnabled() ? TemplateExceptionHandler.DEBUG_HANDLER : TemplateExceptionHandler.RETHROW_HANDLER);
        freeMarkerConfiguration.setLogTemplateExceptions(false);
        freeMarkerConfiguration.setWrapUncheckedExceptions(true);
        freeMarkerConfiguration.setFallbackOnNullLoopVariable(false);
        return freeMarkerConfiguration;
    }

    GitHookTemplateData getGitHookTemplateData(String hookScript) {
        return ImmutableGitHookTemplateData.builder().setCreatedAt(ZonedDateTime.ofInstant(this.clock.instant(), this.clock.getZone())).setHookScript(hookScript).build();
    }

    static class GitHookTemplate {
        private final FilesHelper _filesHelper;
        private final Template _template;

        GitHookTemplate(FilesHelper filesHelper, Configuration freeMarkerConfiguration) {
            this._filesHelper = filesHelper;
            this._template = this.getTemplate(freeMarkerConfiguration);
        }

        private Template getTemplate(Configuration freeMarkerConfiguration) {
            try {
                return freeMarkerConfiguration.getTemplate("git-hook.ftl");
            }
            catch (IOException e) {
                throw new RuntimeException("An error occurred when reading the git-hook.ftl template file.", e);
            }
        }

        Path writeTemplate(Path outputFile, GitHookTemplateData data) {
            try (Writer writer = this._filesHelper.createFileOutputStreamWriter(outputFile);){
                this._template.process((Object)data, writer);
            }
            catch (TemplateException | IOException e) {
                throw new RuntimeException("An error occurred when writing to " + outputFile + ".", e);
            }
            return outputFile;
        }
    }

    @Value.Immutable
    @ImmutableStyle
    public static abstract class GitHookTemplateData {
        private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("MMM d, yyyy hh:mm a z");

        @Value.Auxiliary
        abstract ZonedDateTime getCreatedAt();

        public abstract String getHookScript();

        @Value.Derived
        public String getFormattedCreatedAt() {
            return DATE_TIME_FORMATTER.format(this.getCreatedAt());
        }
    }
}

