/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjni.captainhook.helpers;

import com.github.tjni.captainhook.CaptainHookExtension;
import com.github.tjni.captainhook.dagger.components.PluginComponent;
import com.github.tjni.captainhook.helpers.GitHook;
import com.github.tjni.captainhook.helpers.StagingHelper;
import com.github.tjni.captainhook.tasks.ApplyGitHooksTask;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.util.streamex.EntryStream;
import org.gradle.BuildResult;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;

public class ApplyPluginHelper {
    private static final Logger LOG = Logging.getLogger(ApplyPluginHelper.class);
    private static final String STAGING_TASK_NAME = "staging";
    private final PluginComponent component;
    private final Project project;
    private final TaskContainer tasks;
    private final CaptainHookExtension extension;

    public ApplyPluginHelper(PluginComponent component) {
        this.component = component;
        this.project = component.getGradleHelper().getProject();
        this.tasks = component.getGradleHelper().getProject().getTasks();
        this.extension = component.getGradleHelper().getExtension();
    }

    public void createApplyGitHooksTask() {
        this.tasks.register("applyGitHooks", ApplyGitHooksTask.class, new Object[]{this.component}).configure(this::configureApplyGitHooksTask);
    }

    public void configureStaging() {
        List startTaskNames = this.project.getGradle().getStartParameter().getTaskNames();
        if (!startTaskNames.isEmpty() && ((String)startTaskNames.get(0)).equals(STAGING_TASK_NAME)) {
            this.createStagingRootTask();
            if (this.component.getStagingHelper().isStagingEmpty()) {
                LOG.warn("Not running any tasks because the staging area is empty.");
                this.project.getGradle().getStartParameter().setExcludedTaskNames((Iterable)startTaskNames);
            } else {
                StagingHelper.Snapshot snapshot = this.component.getStagingHelper().saveSnapshot();
                this.project.getExtensions().getExtraProperties().set(STAGING_TASK_NAME, snapshot.getStagedFiles());
                this.project.getGradle().buildFinished(buildResult -> this.handleStagingBuildFinished((BuildResult)buildResult, snapshot));
            }
        }
    }

    public void maybeAutoApplyGitHooks() {
        this.project.afterEvaluate(p -> this.doMaybeAutoApplyGitHooks());
    }

    private void doMaybeAutoApplyGitHooks() {
        if (((Boolean)this.extension.getAutoApplyGitHooks().get()).booleanValue()) {
            Map gitHooks = EntryStream.of(this.getGitHooks()).mapValues(Provider::get).toMap();
            this.component.getApplyGitHooksHelper().apply(gitHooks);
        }
    }

    private Map<GitHook, Provider<String>> getGitHooks() {
        HashMap<GitHook, Provider<String>> gitHooks = new HashMap<GitHook, Provider<String>>();
        if (this.extension.getApplypatchMsg().isPresent()) {
            gitHooks.put(GitHook.APPLYPATCH_MSG, (Provider<String>)this.extension.getApplypatchMsg());
        }
        if (this.extension.getPreApplypatch().isPresent()) {
            gitHooks.put(GitHook.PRE_APPLYPATCH, (Provider<String>)this.extension.getPreApplypatch());
        }
        if (this.extension.getPostApplypatch().isPresent()) {
            gitHooks.put(GitHook.POST_APPLYPATCH, (Provider<String>)this.extension.getPostApplypatch());
        }
        if (this.extension.getPreCommit().isPresent()) {
            gitHooks.put(GitHook.PRE_COMMIT, (Provider<String>)this.extension.getPreCommit());
        }
        if (this.extension.getPreMergeCommit().isPresent()) {
            gitHooks.put(GitHook.PRE_MERGE_COMMIT, (Provider<String>)this.extension.getPreMergeCommit());
        }
        if (this.extension.getPrepareCommitMsg().isPresent()) {
            gitHooks.put(GitHook.PREPARE_COMMIT_MSG, (Provider<String>)this.extension.getPrepareCommitMsg());
        }
        if (this.extension.getCommitMsg().isPresent()) {
            gitHooks.put(GitHook.COMMIT_MSG, (Provider<String>)this.extension.getCommitMsg());
        }
        if (this.extension.getPostCommit().isPresent()) {
            gitHooks.put(GitHook.POST_COMMIT, (Provider<String>)this.extension.getPostCommit());
        }
        if (this.extension.getPreRebase().isPresent()) {
            gitHooks.put(GitHook.PRE_REBASE, (Provider<String>)this.extension.getPreRebase());
        }
        if (this.extension.getPostCheckout().isPresent()) {
            gitHooks.put(GitHook.POST_CHECKOUT, (Provider<String>)this.extension.getPostCheckout());
        }
        if (this.extension.getPostMerge().isPresent()) {
            gitHooks.put(GitHook.POST_MERGE, (Provider<String>)this.extension.getPostMerge());
        }
        if (this.extension.getPrePush().isPresent()) {
            gitHooks.put(GitHook.PRE_PUSH, (Provider<String>)this.extension.getPrePush());
        }
        if (this.extension.getPreReceive().isPresent()) {
            gitHooks.put(GitHook.PRE_RECEIVE, (Provider<String>)this.extension.getPreReceive());
        }
        if (this.extension.getUpdate().isPresent()) {
            gitHooks.put(GitHook.UPDATE, (Provider<String>)this.extension.getUpdate());
        }
        if (this.extension.getPostReceive().isPresent()) {
            gitHooks.put(GitHook.POST_RECEIVE, (Provider<String>)this.extension.getPostReceive());
        }
        if (this.extension.getPostUpdate().isPresent()) {
            gitHooks.put(GitHook.POST_UPDATE, (Provider<String>)this.extension.getPostUpdate());
        }
        if (this.extension.getPushToCheckout().isPresent()) {
            gitHooks.put(GitHook.PUSH_TO_CHECKOUT, (Provider<String>)this.extension.getPushToCheckout());
        }
        if (this.extension.getPreAutoGc().isPresent()) {
            gitHooks.put(GitHook.PRE_AUTO_GC, (Provider<String>)this.extension.getPreAutoGc());
        }
        if (this.extension.getPostRewrite().isPresent()) {
            gitHooks.put(GitHook.POST_REWRITE, (Provider<String>)this.extension.getPostRewrite());
        }
        if (this.extension.getSendemailValidate().isPresent()) {
            gitHooks.put(GitHook.SENDEMAIL_VALIDATE, (Provider<String>)this.extension.getSendemailValidate());
        }
        return gitHooks;
    }

    private void configureApplyGitHooksTask(ApplyGitHooksTask task) {
        this.getGitHooks().forEach((arg_0, arg_1) -> task.getGitHooks().put(arg_0, arg_1));
    }

    private void createStagingRootTask() {
        this.tasks.register(STAGING_TASK_NAME);
    }

    private void handleStagingBuildFinished(BuildResult buildResult, StagingHelper.Snapshot snapshot) {
        if (buildResult.getFailure() == null) {
            try {
                this.component.getStagingHelper().applyModifications(snapshot);
            }
            catch (Exception e) {
                this.component.getStagingHelper().restoreSnapshot(snapshot);
                throw e;
            }
        } else {
            this.component.getStagingHelper().restoreSnapshot(snapshot);
        }
        this.component.getStagingHelper().deleteSnapshot(snapshot);
    }
}

