/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjni.captainhook.helpers;

import com.github.tjni.captainhook.annotations.ImmutableStyle;
import com.github.tjni.captainhook.helpers.ImmutableExecRequest;
import com.github.tjni.captainhook.helpers.ImmutableExecResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import one.util.streamex.StreamEx;
import org.gradle.api.Project;
import org.immutables.value.Value;

@Singleton
public class ExecHelper {
    private final Path workingDir;

    @Inject
    public ExecHelper(Project project) {
        this.workingDir = project.getRootDir().toPath();
    }

    public String exec(String executable, String ... args) {
        ExecResult result = this.rawExec(executable, args);
        if (result.getExitCode() != 0) {
            throw new ExecException(String.join((CharSequence)" ", ExecHelper.getCommand(executable, args)), result.getExitCode(), result.getStderr());
        }
        return result.getStdout();
    }

    public ExecResult rawExec(String executable, String ... args) {
        return this.rawExec(ImmutableExecRequest.builder().setExecutable(executable).setArgs(args).build());
    }

    private ExecResult rawExec(ExecRequest request) {
        int exitCode;
        Process process;
        List<String> command = ExecHelper.getCommand(request.getExecutable(), request.getArgs());
        ProcessBuilder processBuilder = new ProcessBuilder(command).directory(this.workingDir.toFile());
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        ExecHelper.writeStdin(process, request.getStdin());
        String stdout = ExecHelper.readStream(process.getInputStream()).trim();
        String stderr = ExecHelper.readStream(process.getErrorStream()).trim();
        try {
            exitCode = process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("The thread waiting for the process was interrupted.", e);
        }
        return ImmutableExecResult.builder().setExitCode(exitCode).setStdout(stdout).setStderr(stderr).build();
    }

    private static void writeStdin(Process process, String stdin) {
        if (!stdin.isEmpty()) {
            OutputStream stream = process.getOutputStream();
            try (OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
                writer.write(stdin);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static String readStream(InputStream stream) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int length;
            byte[] buffer = new byte[1024];
            while ((length = stream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            return result.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static List<String> getCommand(String executable, String ... args) {
        return StreamEx.of((Object)executable).append((Object[])args).toList();
    }

    @Value.Immutable
    @ImmutableStyle
    public static interface ExecResult {
        public int getExitCode();

        public String getStdout();

        public String getStderr();
    }

    public static class ExecException
    extends RuntimeException {
        private final String error;

        public ExecException(String command, int exitCode, String error) {
            super(String.format("Command %s exited with code %d and error %s.", command, exitCode, error));
            this.error = error;
        }

        public String getError() {
            return this.error;
        }
    }

    @Value.Immutable
    @ImmutableStyle
    public static interface ExecRequest {
        public String getExecutable();

        public String[] getArgs();

        @Value.Default
        default public String getStdin() {
            return "";
        }
    }
}

