/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjni.captainhook.helpers;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FilesHelper {
    @Inject
    public FilesHelper() {
    }

    public boolean exists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    public String toString(Path file) {
        try {
            return new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Path write(Path file, String str) {
        try {
            return Files.write(file, str.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void delete(Path file) {
        try {
            Files.delete(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void delete(Iterable<Path> files) {
        files.forEach(this::delete);
    }

    public boolean deleteIfExists(Path file) {
        try {
            return Files.deleteIfExists(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean isFileEmpty(Path file) {
        return file.toFile().length() == 0L;
    }

    public boolean isTrimmedFileEmpty(Path file) {
        return this.isFileEmpty(file) || this.toString(file).trim().isEmpty();
    }

    public boolean isDirectoryEmpty(Path dir) {
        boolean bl;
        block8: {
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir);
            try {
                boolean bl2 = bl = !dirStream.iterator().hasNext();
                if (dirStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dirStream != null) {
                        try {
                            dirStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            dirStream.close();
        }
        return bl;
    }

    public Path createDirectories(Path dir, FileAttribute<?> ... attrs) {
        try {
            return Files.createDirectories(dir, attrs);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Writer createFileOutputStreamWriter(Path file) {
        FileOutputStream fileOutputStream;
        try {
            fileOutputStream = new FileOutputStream(file.toFile());
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
        return new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);
    }

    public Path setPosixFilePermissions(Path path, String permissions) {
        try {
            return Files.setPosixFilePermissions(path, PosixFilePermissions.fromString(permissions));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

