/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjni.captainhook.helpers;

import com.github.tjni.captainhook.annotations.ImmutableStyle;
import com.github.tjni.captainhook.helpers.ExecHelper;
import com.github.tjni.captainhook.helpers.ImmutableGitStatus;
import com.github.tjni.captainhook.helpers.ImmutableGitStatusLine;
import com.github.tjni.captainhook.helpers.ImmutableRepositoryCache;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import one.util.streamex.StreamEx;
import org.immutables.value.Value;

@Singleton
public class GitHelper {
    private final RepositoryCache repositoryCache = ImmutableRepositoryCache.builder().setCommonDirectorySupplier(this::getCommonDirectoryFromGit).setTopLevelDirectorySupplier(this::getTopLevelDirectoryFromGit).build();
    private final ExecHelper execHelper;

    @Inject
    public GitHelper(ExecHelper execHelper) {
        this.execHelper = execHelper;
    }

    public String git(String command, String ... options) {
        String[] args = (String[])StreamEx.of((Object)command).append((Object[])options).toArray(String.class);
        return this.execHelper.exec("git", args);
    }

    public String stash(String subCommand, String ... options) {
        String[] args = (String[])StreamEx.of((Object)subCommand).append((Object[])options).toArray(String.class);
        return this.git("stash", args);
    }

    public Path getCommonDirectory() {
        return this.repositoryCache.getCommonDirectory();
    }

    private Path getCommonDirectoryFromGit() {
        String relativeGitCommonDir = this.git("rev-parse", "--git-common-dir");
        return this.getTopLevelDirectory().resolve(relativeGitCommonDir);
    }

    public Path getTopLevelDirectory() {
        return this.repositoryCache.getTopLevelDirectory();
    }

    private Path getTopLevelDirectoryFromGit() {
        return Paths.get(this.git("rev-parse", "--show-toplevel"), new String[0]);
    }

    GitStatus status(String ... options) {
        String[] args = (String[])StreamEx.of((Object)"--porcelain").append((Object[])options).toArray(String.class);
        String output = this.git("status", args);
        List statusLines = output.isEmpty() ? Collections.emptyList() : StreamEx.of((Object[])output.split("\n")).map(ImmutableGitStatusLine::of).toList();
        return ImmutableGitStatus.of(statusLines);
    }

    List<Path> lsFiles(String ... options) {
        String output = this.git("ls-files", options);
        if (output.isEmpty()) {
            return Collections.emptyList();
        }
        return StreamEx.of((Object[])output.split("\n")).map(this.getTopLevelDirectory()::resolve).toImmutableList();
    }

    @Value.Immutable
    @ImmutableStyle
    static abstract class RepositoryCache {
        RepositoryCache() {
        }

        abstract Supplier<Path> commonDirectorySupplier();

        abstract Supplier<Path> topLevelDirectorySupplier();

        @Value.Lazy
        Path getCommonDirectory() {
            return this.commonDirectorySupplier().get();
        }

        @Value.Lazy
        Path getTopLevelDirectory() {
            return this.topLevelDirectorySupplier().get();
        }
    }

    @Value.Immutable(builder=false)
    @ImmutableStyle
    public static abstract class GitStatusLine {
        @Value.Auxiliary
        @Value.Parameter
        abstract String getGitStatusShortOutputLine();

        @Value.Derived
        public char getIndexStatus() {
            return this.getGitStatusShortOutputLine().charAt(0);
        }

        @Value.Derived
        public char getWorkingTreeStatus() {
            return this.getGitStatusShortOutputLine().charAt(1);
        }

        @Value.Derived
        public Path getRelativePath() {
            return Paths.get(this.getGitStatusShortOutputLine().substring(3), new String[0]);
        }

        public boolean isIgnored() {
            return this.getIndexStatus() == '!' && this.getWorkingTreeStatus() == '!';
        }
    }

    @Value.Immutable(builder=false)
    @ImmutableStyle
    public static abstract class GitStatus {
        @Value.Parameter
        abstract List<GitStatusLine> getStatusLines();

        public Optional<GitStatusLine> findByFilePath(String filePath) {
            return StreamEx.of(this.getStatusLines()).findFirst(statusLine -> statusLine.getRelativePath().toString().equals(filePath));
        }

        public boolean isEmpty() {
            return this.getStatusLines().isEmpty();
        }
    }
}

