/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjni.captainhook.helpers;

import com.github.tjni.captainhook.helpers.ExecHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ExecHelper.ExecRequest", generator="Immutables")
@Immutable
public final class ImmutableExecRequest
implements ExecHelper.ExecRequest {
    private final String executable;
    private final String[] args;
    private final String stdin;

    private ImmutableExecRequest(Builder builder) {
        this.executable = builder.executable;
        this.args = builder.args;
        this.stdin = builder.stdinIsSet() ? builder.stdin : Objects.requireNonNull(ExecHelper.ExecRequest.super.getStdin(), "stdin");
    }

    private ImmutableExecRequest(String executable, String[] args, String stdin) {
        this.executable = executable;
        this.args = args;
        this.stdin = stdin;
    }

    @Override
    public String getExecutable() {
        return this.executable;
    }

    @Override
    public String[] getArgs() {
        return (String[])this.args.clone();
    }

    @Override
    public String getStdin() {
        return this.stdin;
    }

    public final ImmutableExecRequest withExecutable(String value) {
        String newValue = Objects.requireNonNull(value, "executable");
        if (this.executable.equals(newValue)) {
            return this;
        }
        return new ImmutableExecRequest(newValue, this.args, this.stdin);
    }

    public final ImmutableExecRequest withArgs(String ... elements) {
        String[] newValue = (String[])elements.clone();
        return new ImmutableExecRequest(this.executable, newValue, this.stdin);
    }

    public final ImmutableExecRequest withStdin(String value) {
        String newValue = Objects.requireNonNull(value, "stdin");
        if (this.stdin.equals(newValue)) {
            return this;
        }
        return new ImmutableExecRequest(this.executable, this.args, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExecRequest && this.equalTo((ImmutableExecRequest)another);
    }

    private boolean equalTo(ImmutableExecRequest another) {
        return this.executable.equals(another.executable) && Arrays.equals(this.args, another.args) && this.stdin.equals(another.stdin);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.executable.hashCode();
        h += (h << 5) + Arrays.hashCode(this.args);
        h += (h << 5) + this.stdin.hashCode();
        return h;
    }

    public String toString() {
        return "ExecRequest{executable=" + this.executable + ", args=" + Arrays.toString(this.args) + ", stdin=" + this.stdin + "}";
    }

    public static ImmutableExecRequest copyOf(ExecHelper.ExecRequest instance) {
        if (instance instanceof ImmutableExecRequest) {
            return (ImmutableExecRequest)instance;
        }
        return ImmutableExecRequest.builder().setExecutable(instance.getExecutable()).setArgs(instance.getArgs()).setStdin(instance.getStdin()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExecHelper.ExecRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXECUTABLE = 1L;
        private static final long INIT_BIT_ARGS = 2L;
        private static final long OPT_BIT_STDIN = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String executable;
        @Nullable
        private String[] args;
        @Nullable
        private String stdin;

        private Builder() {
        }

        public final Builder setExecutable(String executable) {
            Builder.checkNotIsSet(this.executableIsSet(), "executable");
            this.executable = Objects.requireNonNull(executable, "executable");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setArgs(String ... args) {
            Builder.checkNotIsSet(this.argsIsSet(), "args");
            this.args = (String[])args.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setStdin(String stdin) {
            Builder.checkNotIsSet(this.stdinIsSet(), "stdin");
            this.stdin = Objects.requireNonNull(stdin, "stdin");
            this.optBits |= 1L;
            return this;
        }

        public ImmutableExecRequest build() {
            this.checkRequiredAttributes();
            return new ImmutableExecRequest(this);
        }

        private boolean stdinIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean executableIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean argsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ExecRequest is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.executableIsSet()) {
                attributes.add("executable");
            }
            if (!this.argsIsSet()) {
                attributes.add("args");
            }
            return "Cannot build ExecRequest, some of required attributes are not set " + attributes;
        }
    }
}

