/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjni.captainhook.helpers;

import com.github.tjni.captainhook.helpers.ExecHelper;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ExecHelper.ExecResult", generator="Immutables")
@Immutable
public final class ImmutableExecResult
implements ExecHelper.ExecResult {
    private final int exitCode;
    private final String stdout;
    private final String stderr;

    private ImmutableExecResult(int exitCode, String stdout, String stderr) {
        this.exitCode = exitCode;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public String getStdout() {
        return this.stdout;
    }

    @Override
    public String getStderr() {
        return this.stderr;
    }

    public final ImmutableExecResult withExitCode(int value) {
        if (this.exitCode == value) {
            return this;
        }
        return new ImmutableExecResult(value, this.stdout, this.stderr);
    }

    public final ImmutableExecResult withStdout(String value) {
        String newValue = Objects.requireNonNull(value, "stdout");
        if (this.stdout.equals(newValue)) {
            return this;
        }
        return new ImmutableExecResult(this.exitCode, newValue, this.stderr);
    }

    public final ImmutableExecResult withStderr(String value) {
        String newValue = Objects.requireNonNull(value, "stderr");
        if (this.stderr.equals(newValue)) {
            return this;
        }
        return new ImmutableExecResult(this.exitCode, this.stdout, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExecResult && this.equalTo((ImmutableExecResult)another);
    }

    private boolean equalTo(ImmutableExecResult another) {
        return this.exitCode == another.exitCode && this.stdout.equals(another.stdout) && this.stderr.equals(another.stderr);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.exitCode;
        h += (h << 5) + this.stdout.hashCode();
        h += (h << 5) + this.stderr.hashCode();
        return h;
    }

    public String toString() {
        return "ExecResult{exitCode=" + this.exitCode + ", stdout=" + this.stdout + ", stderr=" + this.stderr + "}";
    }

    public static ImmutableExecResult copyOf(ExecHelper.ExecResult instance) {
        if (instance instanceof ImmutableExecResult) {
            return (ImmutableExecResult)instance;
        }
        return ImmutableExecResult.builder().setExitCode(instance.getExitCode()).setStdout(instance.getStdout()).setStderr(instance.getStderr()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExecHelper.ExecResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXIT_CODE = 1L;
        private static final long INIT_BIT_STDOUT = 2L;
        private static final long INIT_BIT_STDERR = 4L;
        private long initBits = 7L;
        private int exitCode;
        @Nullable
        private String stdout;
        @Nullable
        private String stderr;

        private Builder() {
        }

        public final Builder setExitCode(int exitCode) {
            Builder.checkNotIsSet(this.exitCodeIsSet(), "exitCode");
            this.exitCode = exitCode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setStdout(String stdout) {
            Builder.checkNotIsSet(this.stdoutIsSet(), "stdout");
            this.stdout = Objects.requireNonNull(stdout, "stdout");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setStderr(String stderr) {
            Builder.checkNotIsSet(this.stderrIsSet(), "stderr");
            this.stderr = Objects.requireNonNull(stderr, "stderr");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableExecResult build() {
            this.checkRequiredAttributes();
            return new ImmutableExecResult(this.exitCode, this.stdout, this.stderr);
        }

        private boolean exitCodeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean stdoutIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean stderrIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ExecResult is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.exitCodeIsSet()) {
                attributes.add("exitCode");
            }
            if (!this.stdoutIsSet()) {
                attributes.add("stdout");
            }
            if (!this.stderrIsSet()) {
                attributes.add("stderr");
            }
            return "Cannot build ExecResult, some of required attributes are not set " + attributes;
        }
    }
}

