/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjni.captainhook.helpers;

import com.github.tjni.captainhook.helpers.GitHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="GitHelper.GitStatusLine", generator="Immutables")
@Immutable
public final class ImmutableGitStatusLine
extends GitHelper.GitStatusLine {
    private final String gitStatusShortOutputLine;
    private final transient char indexStatus;
    private final transient char workingTreeStatus;
    private final transient Path relativePath;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGitStatusLine(String gitStatusShortOutputLine) {
        this.gitStatusShortOutputLine = Objects.requireNonNull(gitStatusShortOutputLine, "gitStatusShortOutputLine");
        this.indexStatus = this.initShim.getIndexStatus();
        this.workingTreeStatus = this.initShim.getWorkingTreeStatus();
        this.relativePath = this.initShim.getRelativePath();
        this.initShim = null;
    }

    private ImmutableGitStatusLine(ImmutableGitStatusLine original, String gitStatusShortOutputLine) {
        this.gitStatusShortOutputLine = gitStatusShortOutputLine;
        this.indexStatus = this.initShim.getIndexStatus();
        this.workingTreeStatus = this.initShim.getWorkingTreeStatus();
        this.relativePath = this.initShim.getRelativePath();
        this.initShim = null;
    }

    @Override
    String getGitStatusShortOutputLine() {
        return this.gitStatusShortOutputLine;
    }

    @Override
    public char getIndexStatus() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getIndexStatus() : this.indexStatus;
    }

    @Override
    public char getWorkingTreeStatus() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getWorkingTreeStatus() : this.workingTreeStatus;
    }

    @Override
    public Path getRelativePath() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRelativePath() : this.relativePath;
    }

    public final ImmutableGitStatusLine withGitStatusShortOutputLine(String value) {
        String newValue = Objects.requireNonNull(value, "gitStatusShortOutputLine");
        if (this.gitStatusShortOutputLine.equals(newValue)) {
            return this;
        }
        return new ImmutableGitStatusLine(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGitStatusLine && this.equalTo((ImmutableGitStatusLine)another);
    }

    private boolean equalTo(ImmutableGitStatusLine another) {
        return this.indexStatus == another.indexStatus && this.workingTreeStatus == another.workingTreeStatus && this.relativePath.equals(another.relativePath);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Character.hashCode(this.indexStatus);
        h += (h << 5) + Character.hashCode(this.workingTreeStatus);
        h += (h << 5) + this.relativePath.hashCode();
        return h;
    }

    public String toString() {
        return "GitStatusLine{indexStatus=" + this.indexStatus + ", workingTreeStatus=" + this.workingTreeStatus + ", relativePath=" + this.relativePath + "}";
    }

    public static ImmutableGitStatusLine of(String gitStatusShortOutputLine) {
        return new ImmutableGitStatusLine(gitStatusShortOutputLine);
    }

    public static ImmutableGitStatusLine copyOf(GitHelper.GitStatusLine instance) {
        if (instance instanceof ImmutableGitStatusLine) {
            return (ImmutableGitStatusLine)instance;
        }
        return ImmutableGitStatusLine.of(instance.getGitStatusShortOutputLine());
    }

    @Generated(from="GitHelper.GitStatusLine", generator="Immutables")
    private final class InitShim {
        private byte indexStatusBuildStage = 0;
        private char indexStatus;
        private byte workingTreeStatusBuildStage = 0;
        private char workingTreeStatus;
        private byte relativePathBuildStage = 0;
        private Path relativePath;

        private InitShim() {
        }

        char getIndexStatus() {
            if (this.indexStatusBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.indexStatusBuildStage == 0) {
                this.indexStatusBuildStage = (byte)-1;
                this.indexStatus = ImmutableGitStatusLine.super.getIndexStatus();
                this.indexStatusBuildStage = 1;
            }
            return this.indexStatus;
        }

        char getWorkingTreeStatus() {
            if (this.workingTreeStatusBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.workingTreeStatusBuildStage == 0) {
                this.workingTreeStatusBuildStage = (byte)-1;
                this.workingTreeStatus = ImmutableGitStatusLine.super.getWorkingTreeStatus();
                this.workingTreeStatusBuildStage = 1;
            }
            return this.workingTreeStatus;
        }

        Path getRelativePath() {
            if (this.relativePathBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relativePathBuildStage == 0) {
                this.relativePathBuildStage = (byte)-1;
                this.relativePath = Objects.requireNonNull(ImmutableGitStatusLine.super.getRelativePath(), "relativePath");
                this.relativePathBuildStage = 1;
            }
            return this.relativePath;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.indexStatusBuildStage == -1) {
                attributes.add("indexStatus");
            }
            if (this.workingTreeStatusBuildStage == -1) {
                attributes.add("workingTreeStatus");
            }
            if (this.relativePathBuildStage == -1) {
                attributes.add("relativePath");
            }
            return "Cannot build GitStatusLine, attribute initializers form cycle " + attributes;
        }
    }
}

