/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjni.captainhook.helpers;

import com.github.tjni.captainhook.helpers.StagingHelper;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="StagingHelper.MergeStatus", generator="Immutables")
@Immutable
final class ImmutableMergeStatus
implements StagingHelper.MergeStatus {
    @Nullable
    private final String mergeHead;
    @Nullable
    private final String mergeMode;
    @Nullable
    private final String mergeMsg;

    private ImmutableMergeStatus(@Nullable String mergeHead, @Nullable String mergeMode, @Nullable String mergeMsg) {
        this.mergeHead = mergeHead;
        this.mergeMode = mergeMode;
        this.mergeMsg = mergeMsg;
    }

    @Override
    public Optional<String> getMergeHead() {
        return Optional.ofNullable(this.mergeHead);
    }

    @Override
    public Optional<String> getMergeMode() {
        return Optional.ofNullable(this.mergeMode);
    }

    @Override
    public Optional<String> getMergeMsg() {
        return Optional.ofNullable(this.mergeMsg);
    }

    public final ImmutableMergeStatus withMergeHead(String value) {
        String newValue = Objects.requireNonNull(value, "mergeHead");
        if (Objects.equals(this.mergeHead, newValue)) {
            return this;
        }
        return new ImmutableMergeStatus(newValue, this.mergeMode, this.mergeMsg);
    }

    public final ImmutableMergeStatus withMergeHead(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.mergeHead, value)) {
            return this;
        }
        return new ImmutableMergeStatus(value, this.mergeMode, this.mergeMsg);
    }

    public final ImmutableMergeStatus withMergeMode(String value) {
        String newValue = Objects.requireNonNull(value, "mergeMode");
        if (Objects.equals(this.mergeMode, newValue)) {
            return this;
        }
        return new ImmutableMergeStatus(this.mergeHead, newValue, this.mergeMsg);
    }

    public final ImmutableMergeStatus withMergeMode(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.mergeMode, value)) {
            return this;
        }
        return new ImmutableMergeStatus(this.mergeHead, value, this.mergeMsg);
    }

    public final ImmutableMergeStatus withMergeMsg(String value) {
        String newValue = Objects.requireNonNull(value, "mergeMsg");
        if (Objects.equals(this.mergeMsg, newValue)) {
            return this;
        }
        return new ImmutableMergeStatus(this.mergeHead, this.mergeMode, newValue);
    }

    public final ImmutableMergeStatus withMergeMsg(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.mergeMsg, value)) {
            return this;
        }
        return new ImmutableMergeStatus(this.mergeHead, this.mergeMode, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMergeStatus && this.equalTo((ImmutableMergeStatus)another);
    }

    private boolean equalTo(ImmutableMergeStatus another) {
        return Objects.equals(this.mergeHead, another.mergeHead) && Objects.equals(this.mergeMode, another.mergeMode) && Objects.equals(this.mergeMsg, another.mergeMsg);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.mergeHead);
        h += (h << 5) + Objects.hashCode(this.mergeMode);
        h += (h << 5) + Objects.hashCode(this.mergeMsg);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MergeStatus{");
        if (this.mergeHead != null) {
            builder.append("mergeHead=").append(this.mergeHead);
        }
        if (this.mergeMode != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("mergeMode=").append(this.mergeMode);
        }
        if (this.mergeMsg != null) {
            if (builder.length() > 12) {
                builder.append(", ");
            }
            builder.append("mergeMsg=").append(this.mergeMsg);
        }
        return builder.append("}").toString();
    }

    public static ImmutableMergeStatus copyOf(StagingHelper.MergeStatus instance) {
        if (instance instanceof ImmutableMergeStatus) {
            return (ImmutableMergeStatus)instance;
        }
        return ImmutableMergeStatus.builder().setMergeHead(instance.getMergeHead()).setMergeMode(instance.getMergeMode()).setMergeMsg(instance.getMergeMsg()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StagingHelper.MergeStatus", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_MERGE_HEAD = 1L;
        private static final long OPT_BIT_MERGE_MODE = 2L;
        private static final long OPT_BIT_MERGE_MSG = 4L;
        private long optBits;
        @Nullable
        private String mergeHead;
        @Nullable
        private String mergeMode;
        @Nullable
        private String mergeMsg;

        private Builder() {
        }

        public final Builder setMergeHead(String mergeHead) {
            Builder.checkNotIsSet(this.mergeHeadIsSet(), "mergeHead");
            this.mergeHead = Objects.requireNonNull(mergeHead, "mergeHead");
            this.optBits |= 1L;
            return this;
        }

        public final Builder setMergeHead(Optional<String> mergeHead) {
            Builder.checkNotIsSet(this.mergeHeadIsSet(), "mergeHead");
            this.mergeHead = mergeHead.orElse(null);
            this.optBits |= 1L;
            return this;
        }

        public final Builder setMergeMode(String mergeMode) {
            Builder.checkNotIsSet(this.mergeModeIsSet(), "mergeMode");
            this.mergeMode = Objects.requireNonNull(mergeMode, "mergeMode");
            this.optBits |= 2L;
            return this;
        }

        public final Builder setMergeMode(Optional<String> mergeMode) {
            Builder.checkNotIsSet(this.mergeModeIsSet(), "mergeMode");
            this.mergeMode = mergeMode.orElse(null);
            this.optBits |= 2L;
            return this;
        }

        public final Builder setMergeMsg(String mergeMsg) {
            Builder.checkNotIsSet(this.mergeMsgIsSet(), "mergeMsg");
            this.mergeMsg = Objects.requireNonNull(mergeMsg, "mergeMsg");
            this.optBits |= 4L;
            return this;
        }

        public final Builder setMergeMsg(Optional<String> mergeMsg) {
            Builder.checkNotIsSet(this.mergeMsgIsSet(), "mergeMsg");
            this.mergeMsg = mergeMsg.orElse(null);
            this.optBits |= 4L;
            return this;
        }

        public ImmutableMergeStatus build() {
            return new ImmutableMergeStatus(this.mergeHead, this.mergeMode, this.mergeMsg);
        }

        private boolean mergeHeadIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean mergeModeIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean mergeMsgIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of MergeStatus is strict, attribute is already set: ".concat(name));
            }
        }
    }
}

