/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjni.captainhook.helpers;

import com.github.tjni.captainhook.helpers.GitHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="GitHelper.RepositoryCache", generator="Immutables")
@Immutable
final class ImmutableRepositoryCache
extends GitHelper.RepositoryCache {
    private final Supplier<Path> commonDirectorySupplier;
    private final Supplier<Path> topLevelDirectorySupplier;
    private volatile transient long lazyInitBitmap;
    private static final long COMMON_DIRECTORY_LAZY_INIT_BIT = 1L;
    private transient Path commonDirectory;
    private static final long TOP_LEVEL_DIRECTORY_LAZY_INIT_BIT = 2L;
    private transient Path topLevelDirectory;

    private ImmutableRepositoryCache(Supplier<Path> commonDirectorySupplier, Supplier<Path> topLevelDirectorySupplier) {
        this.commonDirectorySupplier = commonDirectorySupplier;
        this.topLevelDirectorySupplier = topLevelDirectorySupplier;
    }

    @Override
    Supplier<Path> commonDirectorySupplier() {
        return this.commonDirectorySupplier;
    }

    @Override
    Supplier<Path> topLevelDirectorySupplier() {
        return this.topLevelDirectorySupplier;
    }

    public final ImmutableRepositoryCache withCommonDirectorySupplier(Supplier<Path> value) {
        if (this.commonDirectorySupplier == value) {
            return this;
        }
        Supplier<Path> newValue = Objects.requireNonNull(value, "commonDirectorySupplier");
        return new ImmutableRepositoryCache(newValue, this.topLevelDirectorySupplier);
    }

    public final ImmutableRepositoryCache withTopLevelDirectorySupplier(Supplier<Path> value) {
        if (this.topLevelDirectorySupplier == value) {
            return this;
        }
        Supplier<Path> newValue = Objects.requireNonNull(value, "topLevelDirectorySupplier");
        return new ImmutableRepositoryCache(this.commonDirectorySupplier, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepositoryCache && this.equalTo((ImmutableRepositoryCache)another);
    }

    private boolean equalTo(ImmutableRepositoryCache another) {
        return this.commonDirectorySupplier.equals(another.commonDirectorySupplier) && this.topLevelDirectorySupplier.equals(another.topLevelDirectorySupplier);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.commonDirectorySupplier.hashCode();
        h += (h << 5) + this.topLevelDirectorySupplier.hashCode();
        return h;
    }

    public String toString() {
        return "RepositoryCache{commonDirectorySupplier=" + this.commonDirectorySupplier + ", topLevelDirectorySupplier=" + this.topLevelDirectorySupplier + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Path getCommonDirectory() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableRepositoryCache immutableRepositoryCache = this;
            synchronized (immutableRepositoryCache) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.commonDirectory = Objects.requireNonNull(super.getCommonDirectory(), "commonDirectory");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.commonDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Path getTopLevelDirectory() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableRepositoryCache immutableRepositoryCache = this;
            synchronized (immutableRepositoryCache) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.topLevelDirectory = Objects.requireNonNull(super.getTopLevelDirectory(), "topLevelDirectory");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.topLevelDirectory;
    }

    public static ImmutableRepositoryCache copyOf(GitHelper.RepositoryCache instance) {
        if (instance instanceof ImmutableRepositoryCache) {
            return (ImmutableRepositoryCache)instance;
        }
        return ImmutableRepositoryCache.builder().setCommonDirectorySupplier(instance.commonDirectorySupplier()).setTopLevelDirectorySupplier(instance.topLevelDirectorySupplier()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GitHelper.RepositoryCache", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMMON_DIRECTORY_SUPPLIER = 1L;
        private static final long INIT_BIT_TOP_LEVEL_DIRECTORY_SUPPLIER = 2L;
        private long initBits = 3L;
        @Nullable
        private Supplier<Path> commonDirectorySupplier;
        @Nullable
        private Supplier<Path> topLevelDirectorySupplier;

        private Builder() {
        }

        public final Builder setCommonDirectorySupplier(Supplier<Path> commonDirectorySupplier) {
            Builder.checkNotIsSet(this.commonDirectorySupplierIsSet(), "commonDirectorySupplier");
            this.commonDirectorySupplier = Objects.requireNonNull(commonDirectorySupplier, "commonDirectorySupplier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTopLevelDirectorySupplier(Supplier<Path> topLevelDirectorySupplier) {
            Builder.checkNotIsSet(this.topLevelDirectorySupplierIsSet(), "topLevelDirectorySupplier");
            this.topLevelDirectorySupplier = Objects.requireNonNull(topLevelDirectorySupplier, "topLevelDirectorySupplier");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRepositoryCache build() {
            this.checkRequiredAttributes();
            return new ImmutableRepositoryCache(this.commonDirectorySupplier, this.topLevelDirectorySupplier);
        }

        private boolean commonDirectorySupplierIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean topLevelDirectorySupplierIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of RepositoryCache is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.commonDirectorySupplierIsSet()) {
                attributes.add("commonDirectorySupplier");
            }
            if (!this.topLevelDirectorySupplierIsSet()) {
                attributes.add("topLevelDirectorySupplier");
            }
            return "Cannot build RepositoryCache, some of required attributes are not set " + attributes;
        }
    }
}

