/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjni.captainhook.helpers;

import com.github.tjni.captainhook.helpers.StagingHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="StagingHelper.Snapshot", generator="Immutables")
@Immutable
public final class ImmutableSnapshot
implements StagingHelper.Snapshot {
    private final List<Path> stagedFiles;
    private final String stashMessage;
    private final Path unstagedPatchFile;
    private final Path untrackedPatchFile;

    private ImmutableSnapshot(List<Path> stagedFiles, String stashMessage, Path unstagedPatchFile, Path untrackedPatchFile) {
        this.stagedFiles = stagedFiles;
        this.stashMessage = stashMessage;
        this.unstagedPatchFile = unstagedPatchFile;
        this.untrackedPatchFile = untrackedPatchFile;
    }

    @Override
    public List<Path> getStagedFiles() {
        return this.stagedFiles;
    }

    @Override
    public String getStashMessage() {
        return this.stashMessage;
    }

    @Override
    public Path getUnstagedPatchFile() {
        return this.unstagedPatchFile;
    }

    @Override
    public Path getUntrackedPatchFile() {
        return this.untrackedPatchFile;
    }

    public final ImmutableSnapshot withStagedFiles(Path ... elements) {
        List<Path> newValue = ImmutableSnapshot.createUnmodifiableList(false, ImmutableSnapshot.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSnapshot(newValue, this.stashMessage, this.unstagedPatchFile, this.untrackedPatchFile);
    }

    public final ImmutableSnapshot withStagedFiles(Iterable<? extends Path> elements) {
        if (this.stagedFiles == elements) {
            return this;
        }
        List<Path> newValue = ImmutableSnapshot.createUnmodifiableList(false, ImmutableSnapshot.createSafeList(elements, true, false));
        return new ImmutableSnapshot(newValue, this.stashMessage, this.unstagedPatchFile, this.untrackedPatchFile);
    }

    public final ImmutableSnapshot withStashMessage(String value) {
        String newValue = Objects.requireNonNull(value, "stashMessage");
        if (this.stashMessage.equals(newValue)) {
            return this;
        }
        return new ImmutableSnapshot(this.stagedFiles, newValue, this.unstagedPatchFile, this.untrackedPatchFile);
    }

    public final ImmutableSnapshot withUnstagedPatchFile(Path value) {
        if (this.unstagedPatchFile == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "unstagedPatchFile");
        return new ImmutableSnapshot(this.stagedFiles, this.stashMessage, newValue, this.untrackedPatchFile);
    }

    public final ImmutableSnapshot withUntrackedPatchFile(Path value) {
        if (this.untrackedPatchFile == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "untrackedPatchFile");
        return new ImmutableSnapshot(this.stagedFiles, this.stashMessage, this.unstagedPatchFile, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSnapshot && this.equalTo((ImmutableSnapshot)another);
    }

    private boolean equalTo(ImmutableSnapshot another) {
        return this.stagedFiles.equals(another.stagedFiles) && this.stashMessage.equals(another.stashMessage) && this.unstagedPatchFile.equals(another.unstagedPatchFile) && this.untrackedPatchFile.equals(another.untrackedPatchFile);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.stagedFiles.hashCode();
        h += (h << 5) + this.stashMessage.hashCode();
        h += (h << 5) + this.unstagedPatchFile.hashCode();
        h += (h << 5) + this.untrackedPatchFile.hashCode();
        return h;
    }

    public String toString() {
        return "Snapshot{stagedFiles=" + this.stagedFiles + ", stashMessage=" + this.stashMessage + ", unstagedPatchFile=" + this.unstagedPatchFile + ", untrackedPatchFile=" + this.untrackedPatchFile + "}";
    }

    public static ImmutableSnapshot copyOf(StagingHelper.Snapshot instance) {
        if (instance instanceof ImmutableSnapshot) {
            return (ImmutableSnapshot)instance;
        }
        return ImmutableSnapshot.builder().addAllStagedFiles(instance.getStagedFiles()).setStashMessage(instance.getStashMessage()).setUnstagedPatchFile(instance.getUnstagedPatchFile()).setUntrackedPatchFile(instance.getUntrackedPatchFile()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="StagingHelper.Snapshot", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_STASH_MESSAGE = 1L;
        private static final long INIT_BIT_UNSTAGED_PATCH_FILE = 2L;
        private static final long INIT_BIT_UNTRACKED_PATCH_FILE = 4L;
        private long initBits = 7L;
        private final List<Path> stagedFiles = new ArrayList<Path>();
        @Nullable
        private String stashMessage;
        @Nullable
        private Path unstagedPatchFile;
        @Nullable
        private Path untrackedPatchFile;

        private Builder() {
        }

        public final Builder addStagedFile(Path element) {
            this.stagedFiles.add(Objects.requireNonNull(element, "stagedFiles element"));
            return this;
        }

        public final Builder addStagedFiles(Path ... elements) {
            for (Path element : elements) {
                this.stagedFiles.add(Objects.requireNonNull(element, "stagedFiles element"));
            }
            return this;
        }

        public final Builder addAllStagedFiles(Iterable<? extends Path> elements) {
            for (Path path : elements) {
                this.stagedFiles.add(Objects.requireNonNull(path, "stagedFiles element"));
            }
            return this;
        }

        public final Builder setStashMessage(String stashMessage) {
            Builder.checkNotIsSet(this.stashMessageIsSet(), "stashMessage");
            this.stashMessage = Objects.requireNonNull(stashMessage, "stashMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setUnstagedPatchFile(Path unstagedPatchFile) {
            Builder.checkNotIsSet(this.unstagedPatchFileIsSet(), "unstagedPatchFile");
            this.unstagedPatchFile = Objects.requireNonNull(unstagedPatchFile, "unstagedPatchFile");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setUntrackedPatchFile(Path untrackedPatchFile) {
            Builder.checkNotIsSet(this.untrackedPatchFileIsSet(), "untrackedPatchFile");
            this.untrackedPatchFile = Objects.requireNonNull(untrackedPatchFile, "untrackedPatchFile");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSnapshot build() {
            this.checkRequiredAttributes();
            return new ImmutableSnapshot(ImmutableSnapshot.createUnmodifiableList(true, this.stagedFiles), this.stashMessage, this.unstagedPatchFile, this.untrackedPatchFile);
        }

        private boolean stashMessageIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean unstagedPatchFileIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean untrackedPatchFileIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Snapshot is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.stashMessageIsSet()) {
                attributes.add("stashMessage");
            }
            if (!this.unstagedPatchFileIsSet()) {
                attributes.add("unstagedPatchFile");
            }
            if (!this.untrackedPatchFileIsSet()) {
                attributes.add("untrackedPatchFile");
            }
            return "Cannot build Snapshot, some of required attributes are not set " + attributes;
        }
    }
}

