/*
 * Decompiled with CFR 0.152.
 */
package com.github.tjni.captainhook.helpers;

import com.github.tjni.captainhook.annotations.ImmutableStyle;
import com.github.tjni.captainhook.helpers.ExecHelper;
import com.github.tjni.captainhook.helpers.FilesHelper;
import com.github.tjni.captainhook.helpers.GitHelper;
import com.github.tjni.captainhook.helpers.ImmutableMergeStatus;
import com.github.tjni.captainhook.helpers.ImmutableSnapshot;
import com.github.tjni.captainhook.helpers.OperatingSystemHelper;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import one.util.streamex.StreamEx;
import org.gradle.api.GradleException;
import org.immutables.value.Value;

@Singleton
public class StagingHelper {
    static final String BACKUP_STASH_MESSAGE = "Captain Hook backup";
    private final GitHelper gitHelper;
    private final FilesHelper filesHelper;
    private final OperatingSystemHelper operatingSystemHelper;

    @Inject
    public StagingHelper(GitHelper gitHelper, FilesHelper filesHelper, OperatingSystemHelper operatingSystemHelper) {
        this.gitHelper = gitHelper;
        this.filesHelper = filesHelper;
        this.operatingSystemHelper = operatingSystemHelper;
    }

    public boolean isStagingEmpty() {
        return this.getStagedFiles().isEmpty();
    }

    public Snapshot saveSnapshot() {
        if (!this.isGradleDirectoryIgnored()) {
            throw new GradleException("Please add the .gradle directory to the .gitignore file.");
        }
        Path gitCommonDir = this.gitHelper.getCommonDirectory();
        List<Path> stagedFiles = this.getStagedFiles();
        List<Path> deletedFiles = this.gitHelper.lsFiles("--deleted");
        String stashMessage = this.saveSnapshotStash();
        this.filesHelper.delete(deletedFiles);
        String stashName = this.findStashName(stashMessage);
        Path unstagedPatchFile = gitCommonDir.resolve("captain-hook_unstaged.patch");
        this.gitHelper.git("diff", "--binary", "--unified=0", "--no-color", "--no-ext-diff", "--patch", "--output=" + unstagedPatchFile, stashName, "-R");
        Path untrackedPatchFile = gitCommonDir.resolve("captain-hook_untracked.patch");
        this.gitHelper.git("show", "--binary", "--unified=0", "--no-color", "--no-ext-diff", "--patch", "--format=%b", "--output=" + untrackedPatchFile, stashName + "^3");
        return ImmutableSnapshot.builder().addAllStagedFiles(stagedFiles).setStashMessage(stashMessage).setUnstagedPatchFile(unstagedPatchFile).setUntrackedPatchFile(untrackedPatchFile).build();
    }

    public void applyModifications(Snapshot snapshot) {
        this.stageModifications(snapshot.getStagedFiles());
        if (this.gitHelper.status(new String[0]).isEmpty()) {
            return;
        }
        this.mergeSnapshot(snapshot);
    }

    public void restoreSnapshot(Snapshot snapshot) {
        MergeStatus mergeStatus = this.saveMergeStatus();
        this.gitHelper.git("reset", "--hard", "HEAD");
        String stashName = this.findStashName(snapshot.getStashMessage());
        this.gitHelper.stash("apply", "--quiet", "--index", stashName);
        this.restoreMergeStatus(mergeStatus);
    }

    public void deleteSnapshot(Snapshot snapshot) {
        this.filesHelper.deleteIfExists(snapshot.getUnstagedPatchFile());
        this.filesHelper.deleteIfExists(snapshot.getUntrackedPatchFile());
        String stashName = this.findStashName(snapshot.getStashMessage());
        this.gitHelper.stash("drop", "--quiet", stashName);
    }

    boolean isGradleDirectoryIgnored() {
        return this.gitHelper.status("--ignored").findByFilePath(".gradle").map(GitHelper.GitStatusLine::isIgnored).orElse(false);
    }

    List<Path> getStagedFiles() {
        String output = this.gitHelper.git("diff", "--staged", "--diff-filter=ACMR", "--name-only");
        if (output.isEmpty()) {
            return Collections.emptyList();
        }
        Path topLevelDir = this.gitHelper.getTopLevelDirectory();
        return StreamEx.of((Object[])output.split("\n")).map(topLevelDir::resolve).toImmutableList();
    }

    void mergeSnapshot(Snapshot snapshot) {
        if (!this.mergeUnstagedPatch(snapshot.getUnstagedPatchFile(), false)) {
            this.mergeUnstagedPatch(snapshot.getUnstagedPatchFile(), true);
        }
        this.mergeUntrackedPatch(snapshot.getUntrackedPatchFile());
    }

    boolean mergeUnstagedPatch(Path unstagedPatchFile, boolean is3way) {
        if (this.filesHelper.isFileEmpty(unstagedPatchFile)) {
            return true;
        }
        List args = StreamEx.of((Object[])new String[]{"-v", "--whitespace=nowarn", "--recount", "--unidiff-zero"}).toList();
        if (is3way) {
            args.add("--3way");
        }
        args.add(unstagedPatchFile.toString());
        try {
            this.gitHelper.git("apply", args.toArray(new String[0]));
            return true;
        }
        catch (ExecHelper.ExecException e) {
            return false;
        }
    }

    void mergeUntrackedPatch(Path untrackedPatchFile) {
        if (this.filesHelper.isTrimmedFileEmpty(untrackedPatchFile)) {
            return;
        }
        this.gitHelper.git("apply", "-v", "--whitespace=nowarn", "--recount", "--unidiff-zero", untrackedPatchFile.toString());
    }

    String saveSnapshotStash() {
        MergeStatus mergeStatus = this.saveMergeStatus();
        this.gitHelper.stash("push", "--include-untracked", "--keep-index", "--message=Captain Hook backup");
        this.restoreMergeStatus(mergeStatus);
        return BACKUP_STASH_MESSAGE;
    }

    MergeStatus saveMergeStatus() {
        Path mergeMsgFile;
        Path mergeModeFile;
        Path gitCommonDir = this.gitHelper.getCommonDirectory();
        ImmutableMergeStatus.Builder builder = ImmutableMergeStatus.builder();
        Path mergeHeadFile = gitCommonDir.resolve("MERGE_HEAD");
        if (this.filesHelper.exists(mergeHeadFile)) {
            builder.setMergeHead(this.filesHelper.toString(mergeHeadFile));
        }
        if (this.filesHelper.exists(mergeModeFile = gitCommonDir.resolve("MERGE_MODE"))) {
            builder.setMergeMode(this.filesHelper.toString(mergeModeFile));
        }
        if (this.filesHelper.exists(mergeMsgFile = gitCommonDir.resolve("MERGE_MSG"))) {
            builder.setMergeMsg(this.filesHelper.toString(mergeMsgFile));
        }
        return builder.build();
    }

    void restoreMergeStatus(MergeStatus mergeStatus) {
        Path gitCommonDir = this.gitHelper.getCommonDirectory();
        mergeStatus.getMergeHead().ifPresent(mergeHead -> this.filesHelper.write(gitCommonDir.resolve("MERGE_HEAD"), (String)mergeHead));
        mergeStatus.getMergeMode().ifPresent(mergeMode -> this.filesHelper.write(gitCommonDir.resolve("MERGE_MODE"), (String)mergeMode));
        mergeStatus.getMergeMsg().ifPresent(mergeMsg -> this.filesHelper.write(gitCommonDir.resolve("MERGE_MSG"), (String)mergeMsg));
    }

    String findStashName(String stashMessage) {
        Object[] stashList = this.gitHelper.stash("list", new String[0]).split("\n");
        long stashIndex = StreamEx.of((Object[])stashList).indexOf(message -> message.contains(stashMessage)).orElseThrow(() -> new RuntimeException(String.format("Did not find a stash with message \"%s\".", stashMessage)));
        return "stash@{" + stashIndex + "}";
    }

    void stageModifications(List<Path> previouslyStagedFiles) {
        if (!this.gitHelper.lsFiles("--modified").isEmpty()) {
            int maxCommandLineLen = this.operatingSystemHelper.getMaxCommandLength();
            int approxPathLen = StreamEx.of(previouslyStagedFiles).joining((CharSequence)" ").length();
            int numChunks = Math.min(StagingHelper.divideCeil(approxPathLen, maxCommandLineLen), previouslyStagedFiles.size());
            StreamEx.ofSubLists(previouslyStagedFiles, (int)(previouslyStagedFiles.size() / numChunks)).map(paths -> (String[])StreamEx.of((Collection)paths).map(Path::toString).toArray(String.class)).forEach(paths -> this.gitHelper.git("add", (String)paths));
        }
    }

    private static int divideCeil(int dividend, int divisor) {
        return (dividend + divisor - 1) / divisor;
    }

    @Value.Immutable
    @ImmutableStyle
    public static interface Snapshot {
        public static final String UNSTAGED_PATCH_FILE_NAME = "captain-hook_unstaged.patch";
        public static final String UNTRACKED_PATCH_FILE_NAME = "captain-hook_untracked.patch";

        public List<Path> getStagedFiles();

        public String getStashMessage();

        public Path getUnstagedPatchFile();

        public Path getUntrackedPatchFile();
    }

    @Value.Immutable
    @ImmutableStyle
    static interface MergeStatus {
        public Optional<String> getMergeHead();

        public Optional<String> getMergeMode();

        public Optional<String> getMergeMsg();
    }
}

