/*
 * Decompiled with CFR 0.152.
 */
package aerospiker.msgpack;

import aerospiker.msgpack.JsonPacker;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import scala.Array$;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuilder;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class JsonPacker$ {
    public static final JsonPacker$ MODULE$;
    private final ThreadLocal<CharsetEncoder> encoder;

    static {
        new JsonPacker$();
    }

    public JsonPacker apply() {
        return new JsonPacker();
    }

    public boolean double(BigDecimal x) {
        return x.scale() != 0;
    }

    public void formatArrayFamilyHeader(int size, ArrayBuilder<Object> builder) {
        if (size < 16) {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(0x90 | size))));
        } else if (size < 65536) {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)220)));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(size >>> 8))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(size >>> 0))));
        } else {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)221)));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(size >>> 24))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(size >>> 16))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(size >>> 8))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(size >>> 0))));
        }
    }

    public void formatMapFamilyHeader(int sz, ArrayBuilder<Object> builder) {
        if (sz < 16) {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(0x80 | sz))));
        } else if (sz < 65536) {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)222)));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 8))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 0))));
        } else {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)223)));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 24))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 16))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 8))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 0))));
        }
    }

    public void formatNil(ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)192)));
    }

    public void formatBoolFamily(boolean v, ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v ? 195 : 194))));
    }

    public void formatIntFamily(long l, ArrayBuilder<Object> builder) {
        if (0x100000000L <= l) {
            this.formatLong((byte)207, l, builder);
        } else if (65536L <= l) {
            this.formatInt((byte)206, (int)l, builder);
        } else if (256L <= l) {
            this.formatShort((byte)205, (int)l, builder);
        } else if (128L <= l) {
            this.formatByte((byte)204, (byte)l, builder);
        } else if (0L <= l) {
            this.formatByte((byte)l, builder);
        } else if (l >= -32L) {
            this.formatByte((byte)(0xE0L | l + 32L), builder);
        } else if (l >= (long)-128) {
            this.formatByte((byte)208, (byte)l, builder);
        } else if (l >= (long)Short.MIN_VALUE) {
            this.formatShort((byte)209, (int)l, builder);
        } else if (l >= (long)Integer.MIN_VALUE) {
            this.formatInt((byte)210, (int)l, builder);
        } else {
            this.formatLong((byte)211, l, builder);
        }
    }

    public void formatIntFamily(byte t, BigInt v, ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)t));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(56).toByte()));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(48).toByte()));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(40).toByte()));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(32).toByte()));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(24).toByte()));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(16).toByte()));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(8).toByte()));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v.$greater$greater(0).toByte()));
    }

    public void formatFloatFamily(double v, ArrayBuilder<Object> builder) {
        long x = Double.doubleToLongBits(v);
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)203)));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 56))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 48))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 40))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 32))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 24))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 16))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 8))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(x >>> 0))));
    }

    public void formatStrFamilyHeader(int sz, ArrayBuilder<Object> builder) {
        if (sz < 32) {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(0xA0 | sz))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)3)));
        } else if (sz < 65536) {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)218)));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 8))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 0))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)3)));
        } else {
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)219)));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 24))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 16))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 8))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(sz >>> 0))));
            builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)3)));
        }
    }

    public void formatStrFamily(String v, ArrayBuilder<Object> builder) {
        CharBuffer cb = CharBuffer.wrap(v);
        ByteBuffer buf = this.encoder.get().encode(cb);
        int len = buf.remaining() + 1;
        this.formatStrFamilyHeader(len, builder);
        byte[] arr = (byte[])Array$.MODULE$.ofDim(len - 1, ClassTag$.MODULE$.Byte());
        buf.get(arr);
        builder.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.byteArrayOps(arr));
        buf.clear();
        cb.clear();
    }

    public void formatByte(byte v, ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v));
    }

    public void formatByte(byte t, byte v, ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)t));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)v));
    }

    public void formatShort(byte t, int v, ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)t));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 8))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 0))));
    }

    public void formatInt(byte t, int v, ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)t));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 24))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 16))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 8))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 0))));
    }

    public void formatLong(byte t, long v, ArrayBuilder<Object> builder) {
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)t));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 56))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 48))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 40))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 32))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 24))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 16))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 8))));
        builder.$plus$eq((Object)BoxesRunTime.boxToByte((byte)((byte)(v >>> 0))));
    }

    private JsonPacker$() {
        MODULE$ = this;
        this.encoder = new ThreadLocal<CharsetEncoder>(){

            public CharsetEncoder initialValue() {
                return StandardCharsets.UTF_8.newEncoder();
            }
        };
    }
}

