/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test;

import com.github.tlrx.elasticsearch.test.EsSetupRuntimeException;
import com.github.tlrx.elasticsearch.test.provider.ClassPathJSONProvider;
import com.github.tlrx.elasticsearch.test.provider.ClientProvider;
import com.github.tlrx.elasticsearch.test.provider.DefaultClientProvider;
import com.github.tlrx.elasticsearch.test.provider.JSONProvider;
import com.github.tlrx.elasticsearch.test.provider.LocalClientProvider;
import com.github.tlrx.elasticsearch.test.request.Count;
import com.github.tlrx.elasticsearch.test.request.CreateIndex;
import com.github.tlrx.elasticsearch.test.request.CreateTemplate;
import com.github.tlrx.elasticsearch.test.request.Delete;
import com.github.tlrx.elasticsearch.test.request.DeleteIndices;
import com.github.tlrx.elasticsearch.test.request.DeleteTemplates;
import com.github.tlrx.elasticsearch.test.request.Exists;
import com.github.tlrx.elasticsearch.test.request.Index;
import com.github.tlrx.elasticsearch.test.request.Request;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.settings.Settings;

public class EsSetup {
    private final ClientProvider provider;

    protected EsSetup(ClientProvider clientProvider) {
        Preconditions.checkNotNull((Object)clientProvider, (Object)"No ClientProvider specified");
        this.provider = clientProvider;
    }

    public EsSetup() {
        this(new LocalClientProvider());
    }

    public EsSetup(Settings settings) {
        this(new LocalClientProvider(settings));
    }

    public EsSetup(Client client) {
        this(new DefaultClientProvider(client, false));
    }

    public EsSetup(Client client, boolean closeClientOnTerminate) {
        this(new DefaultClientProvider(client, closeClientOnTerminate));
    }

    public Client client() {
        return this.provider.client();
    }

    public EsSetup execute(Request ... requests) {
        this.provider.open();
        for (Request request : requests) {
            this.doExecute(request);
        }
        return this;
    }

    private <T> T doExecute(Request request) {
        Preconditions.checkNotNull((Object)request, (Object)"Request must not be null");
        this.provider.open();
        try {
            return request.execute(this.provider.client());
        }
        catch (EsSetupRuntimeException e) {
            throw new EsSetupRuntimeException("Exception when executing request " + request, e);
        }
    }

    public void terminate() {
        this.provider.close();
    }

    public static JSONProvider fromClassPath(String path) {
        return new ClassPathJSONProvider(Thread.currentThread().getContextClassLoader(), path);
    }

    public static JSONProvider fromClassPath(ClassLoader classLoader, String resourceName) {
        return new ClassPathJSONProvider(classLoader, resourceName);
    }

    public static JSONProvider fromClassPath(Class klass, String resourceName) {
        return new ClassPathJSONProvider(klass, resourceName);
    }

    public static CreateIndex createIndex(String index) {
        return new CreateIndex(index);
    }

    public static Index index(String index, String type) {
        return new Index(index, type);
    }

    public static Index index(String index, String type, String id) {
        return new Index(index, type, id);
    }

    public static Delete delete(String index, String type, String id) {
        return new Delete(index, type, id);
    }

    public static DeleteIndices deleteIndex(String index) {
        return new DeleteIndices(index);
    }

    public static DeleteIndices deleteIndices(String ... indices) {
        return new DeleteIndices(indices);
    }

    public static DeleteTemplates deleteTemplates(String ... templates) {
        return new DeleteTemplates(templates);
    }

    public static DeleteIndices deleteAll() {
        return new DeleteIndices("_all");
    }

    public static CreateTemplate createTemplate(String name) {
        return new CreateTemplate(name);
    }

    public Boolean exists(String index) {
        return (Boolean)this.doExecute(new Exists(index));
    }

    public Boolean exists(String index, String type, String id) {
        return (Boolean)this.doExecute(new Exists(index, type, id));
    }

    public Long countAll() {
        return (Long)this.doExecute(new Count());
    }

    public Long count(String ... indices) {
        return (Long)this.doExecute(new Count(indices));
    }
}

