/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.request;

import com.github.tlrx.elasticsearch.test.EsSetupRuntimeException;
import com.github.tlrx.elasticsearch.test.request.Request;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.IndicesAction;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.collect.Lists;

public class DeleteTemplates
implements Request<Void> {
    private final String[] templates;
    private boolean failFast = false;

    public DeleteTemplates(String ... templates) {
        this.templates = templates;
    }

    public DeleteTemplates failFast() {
        this.failFast = true;
        return this;
    }

    private Collection<String> getTemplates(Client client) {
        ArrayList templatesColl;
        if (this.templates == null || this.templates.length == 0) {
            ClusterStateRequestBuilder clusterStateRequestBuilder = ClusterStateAction.INSTANCE.newRequestBuilder(client.admin().cluster()).all().setMetaData(false);
            ClusterStateResponse clusterStateResponse = (ClusterStateResponse)clusterStateRequestBuilder.execute().actionGet();
            templatesColl = Lists.newArrayList((Iterator)clusterStateResponse.getState().getMetaData().getTemplates().keysIt());
        } else {
            templatesColl = Arrays.asList(this.templates);
        }
        return templatesColl;
    }

    @Override
    public Void execute(Client client) throws ElasticsearchException {
        HashSet<String> unacknowledgedTemplates = new HashSet<String>();
        EsSetupRuntimeException runtimeException = null;
        for (String template : this.getTemplates(client)) {
            try {
                DeleteIndexTemplateRequest request = new DeleteIndexTemplateRequest(template);
                DeleteIndexTemplateResponse response = (DeleteIndexTemplateResponse)client.admin().indices().execute((IndicesAction)DeleteIndexTemplateAction.INSTANCE, (ActionRequest)request).get();
                if (response.isAcknowledged()) continue;
                if (this.failFast) {
                    throw new EsSetupRuntimeException("Exception when deleting index template: " + template);
                }
                unacknowledgedTemplates.add(template);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                runtimeException = this.handleException(runtimeException, e);
            }
            catch (ExecutionException e) {
                runtimeException = this.handleException(runtimeException, e);
            }
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
        if (!unacknowledgedTemplates.isEmpty()) {
            throw new EsSetupRuntimeException("Exception when deleting index template: " + unacknowledgedTemplates);
        }
        return null;
    }

    private EsSetupRuntimeException handleException(EsSetupRuntimeException currentException, Exception newException) {
        if (this.failFast) {
            throw new EsSetupRuntimeException(newException);
        }
        if (currentException == null) {
            currentException = new EsSetupRuntimeException(newException);
        }
        return currentException;
    }

    public String toString() {
        return "delete templates [templates=" + (this.templates == null ? null : Arrays.asList(this.templates)) + ']';
    }
}

